/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Collections;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.AggStar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapStarSet {
    final RolapCube cube;
    private final RolapStar star;
    private final RolapMeasureGroup measureGroup;
    private final RolapMeasureGroup aggMeasureGroup;

    public RolapStarSet(RolapStar star, RolapMeasureGroup measureGroup, RolapMeasureGroup aggMeasureGroup) {
        this.star = star;
        this.cube = null;
        this.measureGroup = measureGroup;
        this.aggMeasureGroup = aggMeasureGroup;
        if (aggMeasureGroup != null) {
            Util.discard((int)0);
        }
    }

    List<RolapStar> getStars() {
        if (this.star != null) {
            return Collections.singletonList(this.star);
        }
        if (this.cube == null) {
            return Collections.emptyList();
        }
        return this.cube.getStars();
    }

    public RolapStar getStar() {
        if (this.star != null) {
            return this.star;
        }
        if (this.cube == null) {
            return null;
        }
        List<RolapStar> stars = this.cube.getStars();
        switch (stars.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return stars.get(0);
            }
        }
        throw Util.newInternal("Expected 0 or 1 stars, got " + stars);
    }

    public RolapStar getSoleStar() {
        if (this.star != null) {
            return this.star;
        }
        if (this.cube == null) {
            throw Util.newInternal("Expected 1 star, got 0");
        }
        List<RolapStar> starList = this.cube.getStars();
        if (starList.size() != 1) {
            throw Util.newInternal("Expected 1 star, got " + starList.size());
        }
        return starList.get(0);
    }

    public RolapMeasureGroup getMeasureGroup() {
        return this.measureGroup;
    }

    public AggStar getAggStar() {
        return (AggStar)((Object)this.aggMeasureGroup);
    }

    public RolapMeasureGroup getAggMeasureGroup() {
        return this.aggMeasureGroup;
    }
}

