/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.HashMap;
import java.util.Map;
import mondrian.olap.DimensionBase;
import mondrian.olap.Larder;
import mondrian.olap.Util;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapSchema;
import mondrian.util.Lazy;
import org.apache.log4j.Logger;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapDimension
extends DimensionBase {
    private static final Logger LOGGER = Logger.getLogger(RolapDimension.class);
    final RolapSchema schema;
    private final Larder larder;
    RolapAttribute keyAttribute;
    protected final Map<String, RolapAttribute> attributeMap = new HashMap<String, RolapAttribute>();
    Lazy<RolapSchema.PhysKey> key;
    final boolean hanger;

    RolapDimension(RolapSchema schema, String name, boolean visible, Dimension.Type dimensionType, boolean hanger, Larder larder) {
        super(name, visible, dimensionType);
        assert (larder != null);
        assert (schema != null);
        this.schema = schema;
        this.hanger = hanger;
        this.larder = larder;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public RolapHierarchy[] getHierarchies() {
        return (RolapHierarchy[])this.hierarchyList.toArray((Object[])new RolapHierarchy[this.hierarchyList.size()]);
    }

    public NamedList<? extends RolapHierarchy> getHierarchyList() {
        return this.hierarchyList;
    }

    @Override
    public RolapSchema getSchema() {
        return this.schema;
    }

    @Override
    public Larder getLarder() {
        return this.larder;
    }

    public RolapSchema.PhysPath getKeyPath(RolapSchema.PhysColumn column) {
        RolapSchema.PhysSchemaGraph graph = column.relation.getSchema().getGraph();
        try {
            RolapSchema.PhysRelation relation = this.getKeyTable();
            return graph.findPath(relation, column.relation);
        }
        catch (RolapSchema.PhysSchemaException e) {
            Util.deprecated("TODO", false);
            throw Util.newInternal(e, "while finding path from attribute to dimension key");
        }
    }

    void addHierarchy(RolapHierarchy hierarchy) {
        this.hierarchyList.add((Object)hierarchy);
    }

    public RolapAttribute getKeyAttribute() {
        return this.keyAttribute;
    }

    public RolapSchema.PhysRelation getKeyTable() {
        return this.key.get().relation;
    }
}

