/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import mondrian.olap.Formula;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapClosure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapSchemaLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCubeHierarchy
extends RolapHierarchy {
    final RolapCubeDimension cubeDimension;
    private final RolapHierarchy rolapHierarchy;
    private final int ordinal;
    MemberReader memberReader;
    RolapMember defaultMember;

    public RolapCubeHierarchy(RolapSchemaLoader schemaLoader, RolapCubeDimension cubeDimension, RolapHierarchy rolapHierarchy, String subName, String uniqueName, int ordinal, Larder larder) {
        super(cubeDimension, subName, uniqueName, rolapHierarchy.isVisible(), rolapHierarchy.hasAll(), rolapHierarchy.closureFor, rolapHierarchy.attribute, larder);
        this.ordinal = ordinal;
        this.rolapHierarchy = rolapHierarchy;
        this.cubeDimension = cubeDimension;
    }

    void initCubeHierarchy(RolapSchemaLoader schemaLoader, String allMemberName, String allMemberCaption) {
        for (RolapLevel rolapLevel : this.rolapHierarchy.getLevelList()) {
            RolapClosure closure;
            BitSet bitSet = schemaLoader.resourceHierarchyTags.get(this.getCube() + "." + this.uniqueName);
            Map<String, List<Larders.Resource>> resourceMap = bitSet != null && (bitSet.get(rolapLevel.getDepth()) || rolapLevel.isAll()) ? schemaLoader.resourceMap : null;
            if (rolapLevel.closure != null) {
                RolapDimension dimension = rolapLevel.closure.closedPeerLevel.getHierarchy().getDimension();
                RolapCubeDimension cubeDimension = new RolapCubeDimension(this.getCube(), dimension, this.getDimension().getName() + "$Closure", -1, Larders.EMPTY);
                schemaLoader.initCubeDimension(cubeDimension, null, this.getCube().hierarchyList);
                RolapCubeLevel closedPeerCubeLevel = ((RolapCubeHierarchy)cubeDimension.getHierarchyList().get(0)).getLevelList().get(1);
                closure = new RolapClosure(closedPeerCubeLevel, rolapLevel.closure.distanceColumn);
            } else {
                closure = null;
            }
            this.levelList.add((Object)new RolapCubeLevel(rolapLevel, this, resourceMap, closure));
        }
        if (this.hasAll) {
            this.allLevel = this.getLevelList().get(0);
        } else {
            this.allLevel = new RolapCubeLevel(this.rolapHierarchy.allLevel, this, schemaLoader.resourceMap, null);
            this.allLevel.initLevel(schemaLoader);
        }
        Larders.LarderBuilder builder = new Larders.LarderBuilder();
        builder.name(allMemberName);
        if (allMemberCaption != null && !allMemberCaption.equals(allMemberName)) {
            builder.caption(allMemberCaption);
        }
        this.allMember = new RolapMemberBase(null, (RolapCubeLevel)this.allLevel, Util.COMPARABLE_EMPTY_LIST, Member.MemberType.ALL, Util.makeFqName(this.allLevel.getHierarchy(), allMemberName), builder.build());
        this.allMember.setOrdinal(0);
        this.nullLevel = new RolapCubeLevel(this.rolapHierarchy.nullLevel, this, null, null);
        this.nullMember = new RolapHierarchy.RolapNullMember((RolapCubeLevel)this.nullLevel);
    }

    @Override
    public RolapCubeDimension getDimension() {
        return (RolapCubeDimension)this.dimension;
    }

    public RolapHierarchy getRolapHierarchy() {
        return this.rolapHierarchy;
    }

    public final int getOrdinalInCube() {
        return this.ordinal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RolapCubeHierarchy)) {
            return false;
        }
        RolapCubeHierarchy that = (RolapCubeHierarchy)o;
        return this.cubeDimension.equals(that.cubeDimension) && this.getUniqueName().equals(that.getUniqueName());
    }

    @Override
    protected int computeHashCode() {
        return Util.hash(super.computeHashCode(), this.cubeDimension.cube);
    }

    @Override
    public RolapMember createMember(Member _parent, Level _level, String name, Formula formula) {
        return this.createMember(_parent, _level, name, formula, (Comparable)((Object)name));
    }

    public RolapMember createMember(Member _parent, Level _level, String name, Formula formula, Comparable orderKey) {
        RolapCubeLevel level = (RolapCubeLevel)_level;
        RolapMember parent = (RolapMember)_parent;
        if (formula == null) {
            RolapMemberBase rolapMemberBase = new RolapMemberBase(parent, level, (Comparable)((Object)name), Member.MemberType.REGULAR, RolapMemberBase.deriveUniqueName(parent, level, name, false), Larders.ofName(name));
            rolapMemberBase.setOrderKey(orderKey);
            return rolapMemberBase;
        }
        if (level.isMeasure()) {
            return new RolapHierarchy.RolapCalculatedMeasure(parent, level, name, formula);
        }
        return new RolapCalculatedMember(parent, level, name, formula);
    }

    @Override
    public final RolapMember getDefaultMember() {
        assert (this.defaultMember != null);
        return this.defaultMember;
    }

    public void setDefaultMember(RolapMember member) {
        if (member != null) {
            this.defaultMember = member;
        }
    }

    void setMemberReader(MemberReader memberReader) {
        this.memberReader = memberReader;
    }

    final MemberReader getMemberReader() {
        return this.memberReader;
    }

    public final RolapCube getCube() {
        return this.cubeDimension.cube;
    }

    public List<? extends RolapCubeLevel> getLevelList() {
        return Util.cast(this.levelList);
    }
}

