/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractLevelCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;

public class MemberLevelFunDef
extends FunDefBase {
    static final MemberLevelFunDef instance = new MemberLevelFunDef();

    private MemberLevelFunDef() {
        super("Level", "Returns a member's level.", "plm");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        Type argType = args[0].getType();
        return LevelType.forType(argType);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new CalcImpl((Exp)call, memberCalc);
    }

    public static class CalcImpl
    extends AbstractLevelCalc {
        private final MemberCalc memberCalc;

        public CalcImpl(Exp exp, MemberCalc memberCalc) {
            super(exp, new Calc[]{memberCalc});
            this.memberCalc = memberCalc;
        }

        public Level evaluateLevel(Evaluator evaluator) {
            Member member = this.memberCalc.evaluateMember(evaluator);
            return member.getLevel();
        }
    }
}

