/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.information;

import org.pentaho.reporting.libraries.formula.CustomErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;

public class ErrorFunction
implements Function {
    @Override
    public String getCanonicalName() {
        return "ERROR";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        if (parameters.getParameterCount() > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type textType = parameters.getType(0);
        Object textValueRaw = parameters.getValue(0);
        String text = context.getTypeRegistry().convertToText(textType, textValueRaw);
        Number code = null;
        if (parameters.getParameterCount() == 2) {
            Type codeType = parameters.getType(1);
            Object codeRaw = parameters.getValue(1);
            code = context.getTypeRegistry().convertToNumber(codeType, codeRaw);
        }
        if (code == null) {
            code = -1;
        }
        throw EvaluationException.getInstance(new CustomErrorValue((int)code, text));
    }
}

