/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class LinkedMap
implements Cloneable,
Serializable {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object NULL_MARKER = new Object();
    private int size;
    private int mask;
    private float loadFactor;
    private int capacity;
    private MapEntry[] backend;
    private MapEntry firstEntry;
    private MapEntry lastEntry;

    public LinkedMap() {
        this(16, 0.75f);
    }

    public LinkedMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        int mask = 0;
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
            mask = mask << 1 | 1;
        }
        this.mask = mask;
        this.loadFactor = loadFactor;
        this.backend = new MapEntry[capacity];
        this.capacity = (int)Math.ceil((float)capacity * loadFactor);
    }

    private static Object ensureKey(Object o) {
        if (o == null) {
            return NULL_MARKER;
        }
        return o;
    }

    private static int cleanHash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private void ensureSize() {
        MapEntry[] backend = this.backend;
        if (this.size <= this.capacity) {
            return;
        }
        MapEntry[] newBackend = new MapEntry[backend.length << 1];
        int newMask = this.mask << 1 | 1;
        this.transferEntry(newBackend, newMask);
        this.mask = newMask;
        this.backend = newBackend;
        this.capacity = (int)Math.ceil(this.loadFactor * (float)backend.length);
    }

    private void transferEntry(MapEntry[] newBackend, int newMask) {
        int i;
        for (i = 0; i < this.backend.length; ++i) {
            MapEntry entry = this.backend[i];
            while (entry != null) {
                MapEntry next = entry.collisionNext;
                int insertIndex = entry.hashKey & newMask;
                entry.setCollisionNext(newBackend[insertIndex]);
                newBackend[insertIndex] = entry;
                entry = next;
            }
        }
        for (i = 0; i < newBackend.length; ++i) {
            MapEntry mapEntry = newBackend[i];
            while (mapEntry != null) {
                int insertIndex = mapEntry.hashKey & newMask;
                if (i != insertIndex) {
                    throw new IllegalStateException();
                }
                mapEntry = mapEntry.collisionNext;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public Object put(Object key, Object value) {
        Object realKey = LinkedMap.ensureKey(key);
        int hashKey = LinkedMap.cleanHash(realKey.hashCode());
        this.ensureSize();
        int index = hashKey & this.mask;
        MapEntry existingEntry = this.backend[index];
        if (existingEntry == null) {
            MapEntry entry = new MapEntry(realKey, hashKey, value);
            this.addNewRecord(index, entry);
            return null;
        }
        MapEntry colEntry = existingEntry;
        while (colEntry.hashKey != hashKey || !colEntry.key.equals(realKey)) {
            if (colEntry.collisionNext == null) {
                MapEntry entry = new MapEntry(realKey, hashKey, value);
                this.addCollisionRecord(index, entry);
                return null;
            }
            colEntry = colEntry.collisionNext;
        }
        return this.updateRecord(value, colEntry);
    }

    private Object updateRecord(Object value, MapEntry colEntry) {
        MapEntry nextEntry;
        Object oldValue = colEntry.value;
        colEntry.value = value;
        MapEntry firstEntry = this.firstEntry;
        MapEntry lastEntry = this.lastEntry;
        if (lastEntry == colEntry) {
            return oldValue;
        }
        if (firstEntry == colEntry) {
            this.firstEntry = colEntry.next;
            if (this.firstEntry != null) {
                this.firstEntry.previous = null;
            }
            colEntry.previous = lastEntry;
            colEntry.next = null;
            lastEntry.next = colEntry;
            this.lastEntry = colEntry;
            this.asserta();
            return oldValue;
        }
        MapEntry prevEntry = colEntry.previous;
        prevEntry.next = nextEntry = colEntry.next;
        nextEntry.previous = prevEntry;
        colEntry.previous = lastEntry;
        colEntry.next = null;
        lastEntry.next = colEntry;
        this.lastEntry = colEntry;
        this.asserta();
        return oldValue;
    }

    private void addCollisionRecord(int index, MapEntry entry) {
        MapEntry lastEntry;
        entry.setCollisionNext(this.backend[index]);
        this.backend[index] = entry;
        entry.previous = lastEntry = this.lastEntry;
        entry.next = null;
        lastEntry.next = entry;
        this.lastEntry = entry;
        ++this.size;
        this.asserta();
    }

    private void addNewRecord(int index, MapEntry entry) {
        MapEntry lastEntry = this.lastEntry;
        if (lastEntry == null) {
            this.firstEntry = entry;
        } else {
            entry.previous = lastEntry;
            lastEntry.next = entry;
        }
        this.lastEntry = entry;
        this.backend[index] = entry;
        ++this.size;
        this.asserta();
    }

    public Object get(Object key) {
        Object realKey = LinkedMap.ensureKey(key);
        int hashKey = LinkedMap.cleanHash(realKey.hashCode());
        int index = hashKey & this.mask;
        MapEntry existingEntry = this.backend[index];
        if (existingEntry == null) {
            return null;
        }
        MapEntry colEntry = existingEntry;
        while (colEntry != null) {
            if (colEntry.hashKey == hashKey && colEntry.key.equals(realKey)) {
                return colEntry.value;
            }
            colEntry = colEntry.collisionNext;
        }
        return null;
    }

    public Object remove(Object key) {
        Object realKey = LinkedMap.ensureKey(key);
        int hashKey = LinkedMap.cleanHash(realKey.hashCode());
        int index = hashKey & this.mask;
        MapEntry existingEntry = this.backend[index];
        if (existingEntry == null) {
            return null;
        }
        MapEntry prevEntry = null;
        MapEntry colEntry = existingEntry;
        while (colEntry != null) {
            if (colEntry.hashKey == hashKey && colEntry.key.equals(realKey)) {
                Object value = colEntry.value;
                if (prevEntry == null) {
                    this.backend[index] = colEntry.collisionNext;
                } else {
                    prevEntry.setCollisionNext(colEntry.collisionNext);
                }
                if (this.firstEntry == this.lastEntry) {
                    this.firstEntry = null;
                    this.lastEntry = null;
                    --this.size;
                    this.asserta();
                    return value;
                }
                if (this.firstEntry == colEntry) {
                    MapEntry nextfirstEntry = colEntry.next;
                    if (nextfirstEntry != null) {
                        nextfirstEntry.previous = null;
                        colEntry.next = null;
                    }
                    this.firstEntry = nextfirstEntry;
                } else if (this.lastEntry == colEntry) {
                    MapEntry nextLastEntry = colEntry.previous;
                    if (nextLastEntry != null) {
                        nextLastEntry.next = null;
                        colEntry.previous = null;
                    }
                    this.lastEntry = nextLastEntry;
                }
                if (colEntry.previous != null) {
                    colEntry.previous.next = colEntry.next;
                }
                if (colEntry.next != null) {
                    colEntry.next.previous = colEntry.previous;
                }
                --this.size;
                this.asserta();
                return value;
            }
            prevEntry = colEntry;
            colEntry = colEntry.collisionNext;
        }
        this.asserta();
        return null;
    }

    private void asserta() {
        if (this.firstEntry == null) {
            return;
        }
        if (this.firstEntry.previous != null) {
            throw new NullPointerException();
        }
    }

    public boolean containsKey(Object key) {
        Object realKey = LinkedMap.ensureKey(key);
        int hashKey = LinkedMap.cleanHash(realKey.hashCode());
        int index = hashKey & this.mask;
        MapEntry existingEntry = this.backend[index];
        if (existingEntry == null) {
            return false;
        }
        MapEntry colEntry = existingEntry;
        while (colEntry != null) {
            if (colEntry.hashKey == hashKey && colEntry.key.equals(realKey)) {
                return true;
            }
            colEntry = colEntry.collisionNext;
        }
        return false;
    }

    public Object[] keys(Object[] data) {
        Object[] list = data.length < this.size ? (Object[])Array.newInstance(data.getClass().getComponentType(), this.size) : data;
        int index = 0;
        MapEntry entry = this.firstEntry;
        while (entry != null) {
            Object o = entry.key;
            list[index] = o == NULL_MARKER ? null : o;
            entry = entry.getNext();
            ++index;
        }
        return list;
    }

    public Object[] keys() {
        return this.keys(new Object[this.size]);
    }

    public Object[] values() {
        return this.values(new Object[this.size]);
    }

    public Object[] values(Object[] data) {
        Object[] list = data.length < this.size ? (Object[])Array.newInstance(data.getClass().getComponentType(), this.size) : data;
        int index = 0;
        MapEntry entry = this.firstEntry;
        while (entry != null) {
            Object o;
            list[index] = o = entry.value;
            entry = entry.getNext();
            ++index;
        }
        return list;
    }

    public void clear() {
        if (this.firstEntry == null) {
            return;
        }
        this.firstEntry = null;
        this.lastEntry = null;
        Arrays.fill(this.backend, null);
        this.size = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        LinkedMap map = (LinkedMap)super.clone();
        map.backend = (MapEntry[])this.backend.clone();
        Arrays.fill(map.backend, null);
        map.firstEntry = null;
        map.lastEntry = null;
        map.size = 0;
        for (MapEntry entry = this.firstEntry; entry != null; entry = entry.getNext()) {
            map.put(entry.key, entry.value);
        }
        return map;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected static final class MapEntry
    implements Serializable {
        protected final int hashKey;
        protected final Object key;
        protected Object value;
        protected MapEntry previous;
        protected MapEntry next;
        protected MapEntry collisionNext;

        protected MapEntry(Object key, int hashKey, Object value) {
            if (key == null) {
                throw new NullPointerException();
            }
            this.key = key;
            this.hashKey = hashKey;
            this.value = value;
        }

        public MapEntry getPrevious() {
            return this.previous;
        }

        public void setPrevious(MapEntry previous) {
            this.previous = previous;
        }

        public MapEntry getNext() {
            return this.next;
        }

        public void setNext(MapEntry next) {
            this.next = next;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public MapEntry getCollisionNext() {
            return this.collisionNext;
        }

        public void setCollisionNext(MapEntry collisionNext) {
            if (collisionNext == this) {
                throw new IllegalStateException();
            }
            this.collisionNext = collisionNext;
        }
    }
}

