/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.xmlbeans.impl.piccolo.util.DuplicateKeyException;
import org.owasp.encoder.Encode;
import org.pentaho.di.core.gui.AreaOwner;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.SwingGC;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.JobPainter;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CarteObjectEntry;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.GetTransStatusServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.WebResult;

public class GetJobImageServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static final long serialVersionUID = -4365372274638005929L;
    private static Class<?> PKG = GetTransStatusServlet.class;
    public static final String CONTEXT_PATH = "/kettle/jobImage";

    public GetJobImageServlet() {
    }

    public GetJobImageServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Job job;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"GetJobImageServlet.Log.JobImageRequested", (String[])new String[0]));
        }
        String jobName = request.getParameter("name");
        String id = request.getParameter("id");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        if (Utils.isEmpty((CharSequence)id)) {
            CarteObjectEntry entry;
            try {
                entry = this.getJobMap().getUniqueCarteObjectEntry(jobName);
            }
            catch (DuplicateKeyException e) {
                this.buildDuplicateResponse(response, jobName, useXML);
                return;
            }
            if (entry == null) {
                job = null;
            } else {
                id = entry.getId();
                job = this.getJobMap().getJob(entry);
            }
        } else {
            CarteObjectEntry entry = new CarteObjectEntry(jobName, id);
            job = this.getJobMap().getJob(entry);
        }
        try {
            if (job != null) {
                this.buildOkResponse(response, job);
            } else {
                this.buildNotFoundResponse(response, jobName, id, useXML);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buildDuplicateResponse(HttpServletResponse response, String jobName, boolean useXML) {
        String message = BaseMessages.getString(PKG, (String)"GetJobImageServlet.Error.DuplicateJobName", (String[])new String[]{jobName});
        try {
            PrintWriter out = response.getWriter();
            if (useXML) {
                out.println(new WebResult("ERROR", message));
            } else {
                out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"GetJobImageServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                response.setStatus(409);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildOkResponse(HttpServletResponse response, Job job) throws Exception {
        response.setStatus(200);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("image/png");
        BufferedImage image = this.generateJobImage(job.getJobMeta());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
        }
        finally {
            os.flush();
        }
        response.setContentLength(os.size());
        ServletOutputStream out = response.getOutputStream();
        out.write(os.toByteArray());
    }

    private void buildNotFoundResponse(HttpServletResponse response, String jobName, String id, boolean useXML) throws Exception {
        String message = BaseMessages.getString(PKG, (String)"GetJobImageServlet.Error.CoundNotFindJob", (String[])new String[]{jobName, id});
        try {
            PrintWriter out = response.getWriter();
            if (useXML) {
                out.println(new WebResult("ERROR", message));
            } else {
                out.println("<H1>" + Encode.forHtml((String)message) + "</H1>");
                out.println("<a href=\"" + this.convertContextPath("/kettle/status") + "\">" + BaseMessages.getString(PKG, (String)"GetJobImageServlet.BackToStatusPage", (String[])new String[0]) + "</a><p>");
                response.setStatus(404);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    BufferedImage generateJobImage(JobMeta jobMeta) throws Exception {
        float magnification = 1.0f;
        Point maximum = jobMeta.getMaximum();
        maximum.multiply(magnification);
        SwingGC gc = new SwingGC(null, maximum, 32, 0, 0);
        JobPainter jobPainter = new JobPainter(gc, jobMeta, maximum, null, null, null, null, null, new ArrayList<AreaOwner>(), new ArrayList<JobEntryCopy>(), 32, 1, 0, 0, true, "Arial", 10);
        jobPainter.setMagnification(magnification);
        jobPainter.drawJob();
        BufferedImage image = (BufferedImage)gc.getImage();
        return image;
    }

    public String toString() {
        return "Job Image Handler";
    }

    @Override
    public String getService() {
        return "/kettle/jobImage (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

