/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobAdapter;
import org.pentaho.di.job.JobConfiguration;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.KettleAuthenticationException;
import org.pentaho.di.repository.KettleRepositoryNotFoundException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.www.BaseHttpServlet;
import org.pentaho.di.www.CartePluginInterface;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.WebResult;

public class ExecuteJobServlet
extends BaseHttpServlet
implements CartePluginInterface {
    private static Class<?> PKG = ExecuteJobServlet.class;
    private static final long serialVersionUID = -5879219287669847357L;
    public static final String CONTEXT_PATH = "/kettle/executeJob";

    public ExecuteJobServlet() {
    }

    public ExecuteJobServlet(JobMap jobMap) {
        super(jobMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JobMeta jobMeta;
        Repository repository;
        if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Log.ExecuteJobRequested", (String[])new String[0]));
        }
        String[] knownOptions = new String[]{"rep", "user", "pass", "job", "level"};
        String repOption = request.getParameter("rep");
        String userOption = request.getParameter("user");
        String passOption = Encr.decryptPasswordOptionallyEncrypted((String)request.getParameter("pass"));
        String jobOption = request.getParameter("job");
        String levelOption = request.getParameter("level");
        PrintWriter out = response.getWriter();
        try {
            repository = this.openRepository(repOption, userOption, passOption);
        }
        catch (KettleRepositoryNotFoundException krnfe) {
            response.setStatus(404);
            String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.UnableToFindRepository", (String[])new String[]{repOption});
            out.println(new WebResult("ERROR", message));
            return;
        }
        catch (KettleException ke) {
            ExecutionException ee;
            if (ke.getCause() instanceof ExecutionException && (ee = (ExecutionException)ke.getCause()).getCause() instanceof KettleAuthenticationException) {
                response.setStatus(401);
                String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.Authentication", (String[])new String[]{this.getContextPath()});
                out.println(new WebResult("ERROR", message));
                return;
            }
            response.setStatus(500);
            String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)ke)});
            out.println(new WebResult("ERROR", message));
            return;
        }
        String encoding = System.getProperty("KETTLE_DEFAULT_SERVLET_ENCODING", null);
        if (encoding != null && !Utils.isEmpty((CharSequence)encoding.trim())) {
            response.setCharacterEncoding(encoding);
            response.setContentType("text/html; charset=" + encoding);
        }
        try {
            jobMeta = this.loadJob(repository, jobOption);
        }
        catch (KettleException ke) {
            response.setStatus(404);
            out.println(new WebResult("ERROR", ke.getMessage()));
            return;
        }
        String[] parameters = jobMeta.listParameters();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameter = (String)parameterNames.nextElement();
            String[] values = request.getParameterValues(parameter);
            if (Const.indexOfString((String)parameter, (String[])knownOptions) >= 0) continue;
            if (Const.indexOfString((String)parameter, (String[])parameters) < 0) {
                jobMeta.setVariable(parameter, values[0]);
                continue;
            }
            try {
                jobMeta.setParameterValue(parameter, values[0]);
            }
            catch (UnknownParamException upe) {
                response.setStatus(500);
                String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.UnexpectedError", (String[])new String[]{Const.CR + Const.getStackTracker((Throwable)upe)});
                out.println(new WebResult("ERROR", message));
            }
        }
        JobExecutionConfiguration jobExecutionConfiguration = new JobExecutionConfiguration();
        LogLevel logLevel = LogLevel.getLogLevelForCode((String)levelOption);
        jobExecutionConfiguration.setLogLevel(logLevel);
        JobConfiguration jobConfiguration = new JobConfiguration(jobMeta, jobExecutionConfiguration);
        String carteObjectId = UUID.randomUUID().toString();
        SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.CARTE, null);
        servletLoggingObject.setContainerObjectId(carteObjectId);
        servletLoggingObject.setLogLevel(logLevel);
        Job job = new Job(repository, jobMeta, (LoggingObjectInterface)servletLoggingObject);
        job.setRepository(repository);
        job.setSocketRepository(this.getSocketRepository());
        this.getJobMap().addJob(jobMeta.getName(), carteObjectId, job, jobConfiguration);
        job.setContainerObjectId(carteObjectId);
        if (repository != null) {
            final Repository finalRepository = repository;
            job.addJobListener(new JobAdapter(){

                @Override
                public void jobFinished(Job job) {
                    finalRepository.disconnect();
                }
            });
        }
        try {
            this.runJob(job);
            WebResult webResult = new WebResult("OK", "Job started", carteObjectId);
            out.println(webResult.getXML());
            out.flush();
        }
        catch (Exception executionException) {
            response.setStatus(500);
            String logging = KettleLogStore.getAppender().getBuffer(job.getLogChannelId(), false).toString();
            String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.WhileExecutingJob", (String[])new String[]{jobOption, logging});
            out.println(new WebResult("ERROR", message));
            return;
        }
        response.setStatus(200);
    }

    private JobMeta loadJob(Repository repository, String job) throws KettleException {
        String name;
        String directoryPath;
        if (repository == null) {
            JobMeta jobMeta = new JobMeta(job, repository);
            return jobMeta;
        }
        int lastSlash = job.lastIndexOf("/");
        if (lastSlash < 0) {
            directoryPath = "/";
            name = job;
        } else {
            directoryPath = job.substring(0, lastSlash);
            name = job.substring(lastSlash + 1);
        }
        RepositoryDirectoryInterface directory = repository.loadRepositoryDirectoryTree().findDirectory(directoryPath);
        if (directory == null) {
            String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.DirectoryPathNotFoundInRepository", (String[])new String[]{directoryPath});
            throw new KettleException(message);
        }
        ObjectId jobID = repository.getJobId(name, directory);
        if (jobID == null) {
            String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.JobNotFoundInDirectory", (String[])new String[]{name, directoryPath});
            throw new KettleException(message);
        }
        JobMeta jobMeta = repository.loadJob(jobID, null);
        return jobMeta;
    }

    @VisibleForTesting
    Repository openRepository(String repositoryName, String user, String pass) throws KettleException {
        if (Utils.isEmpty((CharSequence)repositoryName)) {
            return null;
        }
        RepositoriesMeta repositoriesMeta = new RepositoriesMeta();
        repositoriesMeta.readData();
        RepositoryMeta repositoryMeta = repositoriesMeta.findRepository(repositoryName);
        if (repositoryMeta == null) {
            String message = BaseMessages.getString(PKG, (String)"ExecuteJobServlet.Error.UnableToFindRepository", (String[])new String[]{repositoryName});
            throw new KettleRepositoryNotFoundException(message);
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        Repository repository = (Repository)registry.loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
        repository.init(repositoryMeta);
        repository.connect(user, pass);
        return repository;
    }

    public String toString() {
        return "Start job";
    }

    @Override
    public String getService() {
        return "/kettle/executeJob (" + this.toString() + ")";
    }

    protected void runJob(Job job) {
        job.start();
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

