/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.SlaveServerDetection;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.TransformationMap;

public class BaseHttpServlet
extends HttpServlet {
    protected static final long serialVersionUID = -1348342810327662788L;
    protected TransformationMap transformationMap;
    protected JobMap jobMap;
    protected SocketRepository socketRepository;
    protected List<SlaveServerDetection> detections;
    private boolean jettyMode = false;
    protected LogChannelInterface log = new LogChannel((Object)"Servlet");

    public String convertContextPath(String contextPath) {
        if (this.jettyMode) {
            return contextPath;
        }
        return contextPath.substring(contextPath.lastIndexOf("/") + 1);
    }

    public BaseHttpServlet() {
    }

    public BaseHttpServlet(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
        this.jettyMode = true;
    }

    public BaseHttpServlet(JobMap jobMap) {
        this.jobMap = jobMap;
        this.jettyMode = true;
    }

    public BaseHttpServlet(TransformationMap transformationMap, JobMap jobMap) {
        this.transformationMap = transformationMap;
        this.jobMap = jobMap;
        this.jettyMode = true;
    }

    public BaseHttpServlet(TransformationMap transformationMap, SocketRepository socketRepository) {
        this.transformationMap = transformationMap;
        this.socketRepository = socketRepository;
        this.jettyMode = true;
    }

    public BaseHttpServlet(JobMap jobMap, SocketRepository socketRepository) {
        this.jobMap = jobMap;
        this.socketRepository = socketRepository;
        this.jettyMode = true;
    }

    public BaseHttpServlet(List<SlaveServerDetection> detections) {
        this(detections, true);
    }

    public BaseHttpServlet(List<SlaveServerDetection> detections, boolean isJetty) {
        this.detections = detections;
        this.jettyMode = isJetty;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public TransformationMap getTransformationMap() {
        if (this.transformationMap == null) {
            return CarteSingleton.getInstance().getTransformationMap();
        }
        return this.transformationMap;
    }

    public JobMap getJobMap() {
        if (this.jobMap == null) {
            return CarteSingleton.getInstance().getJobMap();
        }
        return this.jobMap;
    }

    public SocketRepository getSocketRepository() {
        if (this.socketRepository == null) {
            return CarteSingleton.getInstance().getSocketRepository();
        }
        return this.socketRepository;
    }

    public List<SlaveServerDetection> getDetections() {
        return this.detections;
    }

    public boolean isJettyMode() {
        return this.jettyMode;
    }

    public void setJettyMode(boolean jettyMode) {
        this.jettyMode = jettyMode;
    }

    public void logMinimal(String s) {
        this.log.logMinimal(s);
    }

    public void logBasic(String s) {
        this.log.logBasic(s);
    }

    public void logError(String s) {
        this.log.logError(s);
    }

    public void logError(String s, Throwable e) {
        this.log.logError(s, e);
    }

    public void logBasic(String s, Object ... arguments) {
        this.log.logBasic(s, arguments);
    }

    public void logDetailed(String s, Object ... arguments) {
        this.log.logDetailed(s, arguments);
    }

    public void logError(String s, Object ... arguments) {
        this.log.logError(s, arguments);
    }

    public void logDetailed(String s) {
        this.log.logDetailed(s);
    }

    public void logDebug(String s) {
        this.log.logDebug(s);
    }

    public void logRowlevel(String s) {
        this.log.logRowlevel(s);
    }

    public void setup(TransformationMap transformationMap, JobMap jobMap, SocketRepository socketRepository, List<SlaveServerDetection> detections) {
        this.transformationMap = transformationMap;
        this.jobMap = jobMap;
        this.socketRepository = socketRepository;
        this.detections = detections;
    }
}

