/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.webserviceavailable;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.webserviceavailable.WebServiceAvailableData;
import org.pentaho.di.trans.steps.webserviceavailable.WebServiceAvailableMeta;

public class WebServiceAvailable
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = WebServiceAvailableMeta.class;
    private WebServiceAvailableMeta meta;
    private WebServiceAvailableData data;

    public WebServiceAvailable(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block24: {
            this.meta = (WebServiceAvailableMeta)smi;
            this.data = (WebServiceAvailableData)sdi;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                this.data.previousRowMeta = this.getInputRowMeta().clone();
                this.data.NrPrevFields = this.data.previousRowMeta.size();
                this.data.outputRowMeta = this.data.previousRowMeta;
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                if (Utils.isEmpty((CharSequence)this.meta.getURLField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.FilenameFieldMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.FilenameFieldMissing", (String[])new String[0]));
                }
                this.data.indexOfURL = this.data.previousRowMeta.indexOfValue(this.meta.getURLField());
                if (this.data.indexOfURL < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getURLField() + "]");
                    throw new KettleException(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Exception.CouldnotFindField", (String[])new String[]{this.meta.getURLField()}));
                }
            }
            try {
                String url = this.data.previousRowMeta.getString(r, this.data.indexOfURL);
                if (Utils.isEmpty((CharSequence)url)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.URLEmpty", (String[])new String[0]));
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Log.CheckingURL", (String[])new String[]{url}));
                }
                boolean WebServiceAvailable2 = false;
                InputStream in = null;
                try {
                    URLConnection conn = new URL(url).openConnection();
                    conn.setConnectTimeout(this.data.connectTimeOut);
                    conn.setReadTimeout(this.data.readTimeOut);
                    in = conn.getInputStream();
                    WebServiceAvailable2 = true;
                }
                catch (Exception e) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.ServiceNotReached", (String[])new String[]{url, e.toString()}));
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                this.putRow(this.data.outputRowMeta, RowDataUtil.addValueData((Object[])r, (int)this.data.NrPrevFields, (Object)WebServiceAvailable2));
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"FileExists.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block24;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "WebServiceAvailable001");
            }
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WebServiceAvailableMeta)smi;
        this.data = (WebServiceAvailableData)sdi;
        if (super.init(smi, sdi)) {
            if (Utils.isEmpty((CharSequence)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"WebServiceAvailable.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            this.data.connectTimeOut = Const.toInt((String)this.environmentSubstitute(this.meta.getConnectTimeOut()), (int)0);
            this.data.readTimeOut = Const.toInt((String)this.environmentSubstitute(this.meta.getReadTimeOut()), (int)0);
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (WebServiceAvailableMeta)smi;
        this.data = (WebServiceAvailableData)sdi;
        super.dispose(smi, sdi);
    }
}

