/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.univariatestats;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaNumber;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStats;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsData;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaFunction;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class UnivariateStatsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private UnivariateStatsMetaFunction[] m_stats;

    public UnivariateStatsMetaFunction[] getInputFieldMetaFunctions() {
        return this.m_stats;
    }

    public int getNumFieldsToProcess() {
        return this.m_stats.length;
    }

    public void setInputFieldMetaFunctions(UnivariateStatsMetaFunction[] mf) {
        this.m_stats = mf;
    }

    public void allocate(int nrStats) {
        this.m_stats = new UnivariateStatsMetaFunction[nrStats];
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        int nrStats = XMLHandler.countNodes((Node)stepnode, (String)"univariate_stats");
        this.allocate(nrStats);
        for (int i = 0; i < nrStats; ++i) {
            Node statnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"univariate_stats", (int)i);
            this.m_stats[i] = new UnivariateStatsMetaFunction(statnode);
        }
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder(300);
        if (this.m_stats != null) {
            for (int i = 0; i < this.m_stats.length; ++i) {
                retval.append("       ").append(this.m_stats[i].getXML()).append(Const.CR);
            }
        }
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            UnivariateStatsMeta m = (UnivariateStatsMeta)obj;
            return this.getXML().equals(m.getXML());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_stats);
    }

    @Override
    public Object clone() {
        UnivariateStatsMeta retval = (UnivariateStatsMeta)super.clone();
        if (this.m_stats != null) {
            retval.allocate(this.m_stats.length);
            for (int i = 0; i < this.m_stats.length; ++i) {
                retval.getInputFieldMetaFunctions()[i] = (UnivariateStatsMetaFunction)this.m_stats[i].clone();
            }
        } else {
            retval.allocate(0);
        }
        return retval;
    }

    @Override
    public void setDefault() {
        this.m_stats = new UnivariateStatsMetaFunction[0];
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        int nrStats = rep.countNrStepAttributes(id_step, "source_field_name");
        this.allocate(nrStats);
        for (int i = 0; i < nrStats; ++i) {
            this.m_stats[i] = new UnivariateStatsMetaFunction(rep, id_step, i);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        for (int i = 0; i < this.m_stats.length; ++i) {
            this.m_stats[i].saveRep(rep, metaStore, id_transformation, id_step, i);
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        row.clear();
        for (int i = 0; i < this.m_stats.length; ++i) {
            UnivariateStatsMetaFunction fn = this.m_stats[i];
            ValueMetaInterface[] vmis = this.getValueMetas(fn, origin);
            for (int j = 0; j < vmis.length; ++j) {
                row.addValueMeta(vmis[j]);
            }
        }
    }

    private ValueMetaInterface[] getValueMetas(UnivariateStatsMetaFunction fn, String origin) {
        ValueMetaInterface[] v = new ValueMetaInterface[fn.numberOfMetricsRequested()];
        int index = 0;
        if (fn.getCalcN()) {
            v[index] = new ValueMetaNumber(fn.getSourceFieldName() + "(N)");
            v[index].setOrigin(origin);
            ++index;
        }
        if (fn.getCalcMean()) {
            v[index] = new ValueMetaNumber(fn.getSourceFieldName() + "(mean)");
            v[index].setOrigin(origin);
            ++index;
        }
        if (fn.getCalcStdDev()) {
            v[index] = new ValueMetaNumber(fn.getSourceFieldName() + "(stdDev)");
            v[index].setOrigin(origin);
            ++index;
        }
        if (fn.getCalcMin()) {
            v[index] = new ValueMetaNumber(fn.getSourceFieldName() + "(min)");
            v[index].setOrigin(origin);
            ++index;
        }
        if (fn.getCalcMax()) {
            v[index] = new ValueMetaNumber(fn.getSourceFieldName() + "(max)");
            v[index].setOrigin(origin);
            ++index;
        }
        if (fn.getCalcMedian()) {
            v[index] = new ValueMetaNumber(fn.getSourceFieldName() + "(median)");
            v[index].setOrigin(origin);
            ++index;
        }
        if (fn.getCalcPercentile() >= 0.0) {
            double percent = fn.getCalcPercentile();
            NumberFormat pF = NumberFormat.getInstance();
            pF.setMaximumFractionDigits(2);
            String res = pF.format(percent * 100.0);
            v[index] = new ValueMetaNumber(fn.getSourceFieldName() + "(" + res + "th percentile)");
            v[index].setOrigin(origin);
            ++index;
        }
        return v;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transmeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new UnivariateStats(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new UnivariateStatsData();
    }
}

