/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableinput;

import java.sql.SQLException;
import java.util.concurrent.locks.ReentrantLock;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputData;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class TableInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = TableInputMeta.class;
    private final ReentrantLock dbLock = new ReentrantLock();
    private TableInputMeta meta;
    private TableInputData data;

    public TableInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private RowMetaAndData readStartDate() throws KettleException {
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"TableInput.Log.ReadingFromStep", (String[])new String[]{this.data.infoStream.getStepname()}));
        }
        RowMeta parametersMeta = new RowMeta();
        Object[] parametersData = new Object[]{};
        RowSet rowSet = this.findInputRowSet(this.data.infoStream.getStepname());
        if (rowSet != null) {
            Object[] rowData = this.getRowFrom(rowSet);
            while (rowData != null) {
                parametersData = RowDataUtil.addRowData((Object[])parametersData, (int)parametersMeta.size(), (Object[])rowData);
                parametersMeta.addRowMeta(rowSet.getRowMeta());
                rowData = this.getRowFrom(rowSet);
            }
            if (parametersMeta.size() == 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"TableInput.Exception.NoParametersFound", (String[])new String[]{this.data.infoStream.getStepname()}));
            }
        } else {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TableInput.Exception.NoRowSetFound", (String[])new String[]{this.data.infoStream.getStepname()}));
        }
        RowMetaAndData parameters = new RowMetaAndData((RowMetaInterface)parametersMeta, parametersData);
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.dbLock.lock();
        try {
            block33: {
                block29: {
                    boolean done;
                    block32: {
                        block30: {
                            Object[] nextRow;
                            boolean success;
                            block31: {
                                if (this.first) {
                                    RowMeta parametersMeta;
                                    Object[] parameters;
                                    this.first = false;
                                    if (this.data.infoStream.getStepMeta() != null) {
                                        if (this.meta.isExecuteEachInputRow()) {
                                            if (this.log.isDetailed()) {
                                                this.logDetailed(BaseMessages.getString(PKG, (String)"TableInput.Log.ReadingSingleRow", (String[])new String[]{this.data.infoStream.getStepname()}));
                                            }
                                            this.data.rowSet = this.findInputRowSet(this.data.infoStream.getStepname());
                                            if (this.data.rowSet == null) {
                                                throw new KettleException(BaseMessages.getString(PKG, (String)"TableInput.Exception.NoRowSetFound", (String[])new String[]{this.data.infoStream.getStepname()}));
                                            }
                                            parameters = this.getRowFrom(this.data.rowSet);
                                            parametersMeta = this.data.rowSet.getRowMeta();
                                        } else {
                                            if (this.log.isDetailed()) {
                                                this.logDetailed(BaseMessages.getString(PKG, (String)"TableInput.Log.ReadingQueryParameters", (String[])new String[]{this.data.infoStream.getStepname()}));
                                            }
                                            RowMetaAndData rmad = this.readStartDate();
                                            parameters = rmad.getData();
                                            parametersMeta = rmad.getRowMeta();
                                        }
                                        if (parameters != null && this.log.isDetailed()) {
                                            this.logDetailed(BaseMessages.getString(PKG, (String)"TableInput.Log.QueryParametersFound", (String[])new String[]{parametersMeta.getString(parameters)}));
                                        }
                                    } else {
                                        parameters = new Object[]{};
                                        parametersMeta = new RowMeta();
                                    }
                                    if (this.meta.isExecuteEachInputRow() && (parameters == null || parametersMeta.size() == 0)) {
                                        this.setOutputDone();
                                        boolean rmad = false;
                                        return rmad;
                                    }
                                    success = this.doQuery((RowMetaInterface)parametersMeta, parameters);
                                    if (!success) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                } else if (this.data.thisrow != null) {
                                    try {
                                        this.data.nextrow = this.data.db.getRow(this.data.rs, this.meta.isLazyConversionActive());
                                    }
                                    catch (KettleDatabaseException e) {
                                        if (!(e.getCause() instanceof SQLException)) throw e;
                                        if (!this.isStopped()) throw e;
                                        this.logDebug(e.getMessage());
                                        boolean parametersMeta = false;
                                        this.dbLock.unlock();
                                        return parametersMeta;
                                    }
                                    if (this.data.nextrow != null) {
                                        this.incrementLinesInput();
                                    }
                                }
                                if (this.data.thisrow != null) break block29;
                                done = false;
                                if (!this.meta.isExecuteEachInputRow()) break block30;
                                nextRow = this.getRowFrom(this.data.rowSet);
                                if (nextRow != null) break block31;
                                done = true;
                                break block32;
                            }
                            this.closePreviousQuery();
                            success = this.doQuery(this.data.rowSet.getRowMeta(), nextRow);
                            if (!success) {
                                boolean bl = false;
                                return bl;
                            }
                            if (this.data.thisrow != null) {
                                this.putRow(this.data.rowMeta, this.data.thisrow);
                                this.data.thisrow = this.data.nextrow;
                                if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
                                    this.logBasic(BaseMessages.getString(PKG, (String)"TableInput.Log.LineNumber", (String[])new String[]{String.valueOf(this.getLinesInput())}));
                                }
                            }
                            break block32;
                        }
                        done = true;
                    }
                    if (done) {
                        this.setOutputDone();
                        boolean bl = false;
                        return bl;
                    }
                    break block33;
                }
                this.putRow(this.data.rowMeta, this.data.thisrow);
                this.data.thisrow = this.data.nextrow;
                if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"TableInput.Log.LineNumber", (String[])new String[]{String.valueOf(this.getLinesInput())}));
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.dbLock.unlock();
        }
    }

    private void closePreviousQuery() throws KettleDatabaseException {
        if (this.data.db != null) {
            this.data.db.closeQuery(this.data.rs);
        }
    }

    private boolean doQuery(RowMetaInterface parametersMeta, Object[] parameters) throws KettleDatabaseException {
        boolean success = true;
        String sql = null;
        sql = this.meta.isVariableReplacementActive() ? this.environmentSubstitute(this.meta.getSQL()) : this.meta.getSQL();
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"TableInput.Log.SqlQuery", (String[])new String[]{sql}));
        }
        this.data.rs = parametersMeta.isEmpty() ? this.data.db.openQuery(sql, null, null, 1000, this.meta.isLazyConversionActive()) : this.data.db.openQuery(sql, parametersMeta, parameters, 1000, this.meta.isLazyConversionActive());
        if (this.data.rs == null) {
            this.logError(BaseMessages.getString(PKG, (String)"TableInput.Log.CanNotOpenQuery", (String[])new String[]{sql}));
            this.setErrors(1L);
            this.stopAll();
            success = false;
        } else {
            this.data.rowMeta = this.data.db.getReturnRowMeta();
            if (this.data.rowMeta != null) {
                for (ValueMetaInterface valueMeta : this.data.rowMeta.getValueMetaList()) {
                    valueMeta.setOrigin(this.getStepname());
                }
            }
            this.data.thisrow = this.data.db.getRow(this.data.rs);
            if (this.data.thisrow != null) {
                this.incrementLinesInput();
                this.data.nextrow = this.data.db.getRow(this.data.rs);
                if (this.data.nextrow != null) {
                    this.incrementLinesInput();
                }
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.dbLock.lock();
        try {
            if (this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"TableInput.Log.FinishedReadingQuery", (String[])new String[0]));
            }
            try {
                this.closePreviousQuery();
            }
            catch (KettleException e) {
                this.logError(BaseMessages.getString(PKG, (String)"TableInput.Log.ErrorClosingQuery", (String[])new String[]{e.toString()}));
                this.setErrors(1L);
                this.stopAll();
            }
            finally {
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
            }
            super.dispose(smi, sdi);
        }
        finally {
            this.dbLock.unlock();
        }
    }

    @Override
    public void stopRunning(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        if (this.isStopped() || sdi.isDisposed()) {
            return;
        }
        this.dbLock.lock();
        try {
            this.meta = (TableInputMeta)smi;
            this.data = (TableInputData)sdi;
            this.setStopped(true);
            if (this.data.db != null && this.data.db.getConnection() != null && !this.data.isCanceled) {
                this.data.db.cancelQuery();
                this.data.isCanceled = true;
            }
        }
        finally {
            this.dbLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.dbLock.lock();
        this.meta = (TableInputMeta)smi;
        this.data = (TableInputData)sdi;
        if (!super.init(smi, sdi)) return false;
        boolean passed = true;
        if (Utils.isEmpty((CharSequence)this.meta.getSQL())) {
            this.logError(BaseMessages.getString(PKG, (String)"TableInput.Exception.SQLIsNeeded", (String[])new String[0]));
            passed = false;
        }
        if (this.meta.getDatabaseMeta() == null) {
            this.logError(BaseMessages.getString(PKG, (String)"TableInput.Exception.DatabaseConnectionsIsNeeded", (String[])new String[0]));
            passed = false;
        }
        if (!passed) {
            boolean bl = false;
            this.dbLock.unlock();
            return bl;
        }
        {
            catch (Throwable throwable) {
                throw throwable;
            }
            this.data.infoStream = this.meta.getStepIOMeta().getInfoStreams().get(0);
            if (this.meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"TableInput.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            this.data.db.setQueryLimit(Const.toInt((String)this.environmentSubstitute(this.meta.getRowLimit()), (int)0));
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.meta.getDatabaseMeta().isRequiringTransactionsOnQueries()) {
                    this.data.db.setCommit(100);
                }
                if (!this.log.isDetailed()) return true;
                this.logDetailed(BaseMessages.getString(PKG, (String)"TableInput.Log.ConnectedToDatabase", (String[])new String[0]));
                return true;
            }
            catch (KettleException e) {}
            {
                this.logError(BaseMessages.getString(PKG, (String)"TableInput.Log.ErrorOccurred", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
    }

    public boolean isWaitingForData() {
        return true;
    }
}

