/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.normaliser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.normaliser.NormaliserData;
import org.pentaho.di.trans.steps.normaliser.NormaliserMeta;

public class Normaliser
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = NormaliserMeta.class;
    private NormaliserMeta meta;
    private NormaliserData data;

    public Normaliser(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        List<Integer> normFieldList;
        int i;
        this.meta = (NormaliserMeta)smi;
        this.data = (NormaliserData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.inputRowMeta = this.getInputRowMeta();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            int normFieldsLength = this.meta.getNormaliserFields().length;
            this.data.typeToFieldIndex = new HashMap<String, List<Integer>>();
            this.data.type_occ = new ArrayList<String>();
            this.data.maxlen = 0;
            for (i = 0; i < normFieldsLength; ++i) {
                int dataFieldNr;
                String typeValue = this.meta.getNormaliserFields()[i].getValue();
                if (!this.data.type_occ.contains(typeValue)) {
                    this.data.type_occ.add(typeValue);
                }
                if (typeValue.length() > this.data.maxlen) {
                    this.data.maxlen = typeValue.length();
                }
                if ((dataFieldNr = this.data.inputRowMeta.indexOfValue(this.meta.getNormaliserFields()[i].getName())) < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"Normaliser.Log.CouldNotFindFieldInRow", (String[])new String[]{this.meta.getNormaliserFields()[i].getName()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                normFieldList = this.data.typeToFieldIndex.get(typeValue);
                if (normFieldList == null) {
                    normFieldList = new ArrayList<Integer>();
                    this.data.typeToFieldIndex.put(typeValue, normFieldList);
                }
                normFieldList.add(dataFieldNr);
            }
            this.data.copy_fieldnrs = new ArrayList<Integer>();
            Set<String> normaliserFields = this.meta.getFieldNames();
            int irmSize = this.data.inputRowMeta.size();
            for (i = 0; i < irmSize; ++i) {
                ValueMetaInterface v = this.data.inputRowMeta.getValueMeta(Integer.valueOf(i).intValue());
                if (normaliserFields.contains(v.getName().toLowerCase())) continue;
                this.data.copy_fieldnrs.add(i);
            }
        }
        int typeOccSize = this.data.type_occ.size();
        int copyFldNrsSz = this.data.copy_fieldnrs.size();
        int rowMetaSz = this.data.outputRowMeta.size();
        for (int e = 0; e < typeOccSize; ++e) {
            String typeValue = this.data.type_occ.get(e);
            Object[] outputRowData = new Object[rowMetaSz];
            int outputIndex = 0;
            for (i = 0; i < copyFldNrsSz; ++i) {
                int nr = this.data.copy_fieldnrs.get(i);
                outputRowData[outputIndex++] = r[nr];
            }
            outputRowData[outputIndex++] = typeValue;
            normFieldList = this.data.typeToFieldIndex.get(typeValue);
            int normFieldListSz = normFieldList.size();
            for (i = 0; i < normFieldListSz; ++i) {
                Object value = r[normFieldList.get(i)];
                outputRowData[outputIndex++] = value;
            }
            this.putRow(this.data.outputRowMeta, outputRowData);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Normaliser.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (NormaliserMeta)smi;
        this.data = (NormaliserData)sdi;
        return super.init(smi, sdi);
    }
}

