/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import jakarta.mail.Header;
import jakarta.mail.Message;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.getpop.MailConnection;
import org.pentaho.di.job.entries.getpop.MailConnectionMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailinput.BatchFolderIterator;
import org.pentaho.di.trans.steps.mailinput.MailInputData;
import org.pentaho.di.trans.steps.mailinput.MailInputMeta;
import org.pentaho.di.trans.steps.mailinput.SearchEnabledFolderIterator;

public class MailInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MailInputMeta.class;
    private MailInputMeta meta;
    private MailInputData data;
    private MessageParser instance = new MessageParser();

    public MailInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        Object[] outputRowData = this.getOneRow();
        if (outputRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"MailInput.Log.OutputRow", (String[])new String[]{this.data.outputRowMeta.getString(outputRowData)})});
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.data.rowlimit > 0 && this.data.rownr >= (long)this.data.rowlimit) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public String[] getFolders(String realIMAPFolder) throws KettleException {
        this.data.folderenr = 0;
        this.data.messagesCount = 0;
        this.data.rownr = 0L;
        String[] folderslist = null;
        if (this.meta.isIncludeSubFolders()) {
            String[] folderslist0 = this.data.mailConn.returnAllFolders(realIMAPFolder);
            if (folderslist0 == null || folderslist0.length == 0) {
                String[] stringArray;
                if (this.data.mailConn.getProtocol() == 2) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
                }
                folderslist = stringArray;
            } else {
                folderslist = new String[folderslist0.length + 1];
                folderslist[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
                for (int i = 0; i < folderslist0.length; ++i) {
                    folderslist[i + 1] = folderslist0[i];
                }
            }
        } else {
            String[] stringArray;
            if (this.data.mailConn.getProtocol() == 2) {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = "";
            } else {
                String[] stringArray5 = new String[1];
                stringArray = stringArray5;
                stringArray5[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
            }
            folderslist = stringArray;
        }
        return folderslist;
    }

    private void applySearch(Date beginDate, Date endDate) {
        String realSearchSubject;
        String realSearchReceipient;
        String realSearchSender = this.environmentSubstitute(this.meta.getSenderSearchTerm());
        if (!Utils.isEmpty((CharSequence)realSearchSender)) {
            this.data.mailConn.setSenderTerm(realSearchSender, this.meta.isNotTermSenderSearch());
        }
        if (!Utils.isEmpty((CharSequence)(realSearchReceipient = this.environmentSubstitute(this.meta.getRecipientSearch())))) {
            this.data.mailConn.setReceipientTerm(realSearchReceipient);
        }
        if (!Utils.isEmpty((CharSequence)(realSearchSubject = this.environmentSubstitute(this.meta.getSubjectSearch())))) {
            this.data.mailConn.setSubjectTerm(realSearchSubject, this.meta.isNotTermSubjectSearch());
        }
        switch (this.meta.getConditionOnReceivedDate()) {
            case 1: {
                this.data.mailConn.setReceivedDateTermEQ(beginDate);
                break;
            }
            case 3: {
                this.data.mailConn.setReceivedDateTermGT(beginDate);
                break;
            }
            case 2: {
                this.data.mailConn.setReceivedDateTermLT(beginDate);
                break;
            }
            case 4: {
                this.data.mailConn.setReceivedDateTermBetween(beginDate, endDate);
                break;
            }
        }
        if (!this.data.usePOP) {
            switch (this.meta.getValueImapList()) {
                case 1: {
                    this.data.mailConn.setFlagTermNew();
                    break;
                }
                case 2: {
                    this.data.mailConn.setFlagTermOld();
                    break;
                }
                case 3: {
                    this.data.mailConn.setFlagTermRead();
                    break;
                }
                case 4: {
                    this.data.mailConn.setFlagTermUnread();
                    break;
                }
                case 5: {
                    this.data.mailConn.setFlagTermFlagged();
                    break;
                }
                case 6: {
                    this.data.mailConn.setFlagTermNotFlagged();
                    break;
                }
                case 7: {
                    this.data.mailConn.setFlagTermDraft();
                    break;
                }
                case 8: {
                    this.data.mailConn.setFlagTermNotDraft();
                    break;
                }
            }
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    private boolean isFolderExausted() {
        return this.data.folder == null || !this.data.folderIterator.hasNext();
    }

    private Object[] getOneRow() throws KettleException {
        while (this.isFolderExausted()) {
            if (this.openNextFolder()) continue;
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (this.meta.isDynamicFolder()) {
            System.arraycopy(this.data.readrow, 0, r, 0, this.data.readrow.length);
        }
        try {
            Message message = this.data.folderIterator.next();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FetchingMessage", (Object[])new Object[]{message.getMessageNumber()}));
            }
            try {
                this.instance.parseToArray(r, message);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (this.meta.isStopOnError()) {
                    throw new KettleException(msg, (Throwable)e);
                }
                this.logError(msg, e);
            }
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException("Error adding values to row!", (Throwable)e);
        }
        return r;
    }

    private boolean openNextFolder() {
        try {
            if (!this.meta.isDynamicFolder()) {
                if (this.data.folderenr >= this.data.folders.length) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
            } else {
                String foldername;
                if (this.first) {
                    this.first = false;
                    this.data.readrow = this.getRow();
                    if (this.data.readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    if (Utils.isEmpty((CharSequence)this.meta.getFolderField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderFieldMissing", (String[])new String[0]));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    this.data.indexOfFolderField = this.data.inputRowMeta.indexOfValue(this.meta.getFolderField());
                    if (this.data.indexOfFolderField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderUnreachable", (String[])new String[]{this.meta.getFolderField()}));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    foldername = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfFolderField);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FoldernameInStream", (String[])new String[]{this.meta.getFolderField(), foldername}));
                    }
                    this.data.folders = this.getFolders(foldername);
                }
                if (this.data.folderenr >= this.data.folders.length) {
                    this.data.readrow = this.getRow();
                    if (this.data.readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    foldername = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfFolderField);
                    this.data.folders = this.getFolders(foldername);
                }
            }
            this.data.start = this.parseIntWithSubstitute(this.meta.getStart());
            this.data.end = this.parseIntWithSubstitute(this.meta.getEnd());
            this.data.folder = this.data.folders[this.data.folderenr];
            ++this.data.folderenr;
            if (!this.data.usePOP && !Utils.isEmpty((CharSequence)this.data.folder)) {
                this.data.mailConn.openFolder(this.data.folder, false);
            } else {
                this.data.mailConn.openFolder(false);
            }
            if (this.meta.useBatch() || !Utils.isEmpty((CharSequence)this.environmentSubstitute(this.meta.getFirstMails())) && Integer.parseInt(this.environmentSubstitute(this.meta.getFirstMails())) > 0) {
                Integer batchSize = this.meta.useBatch() ? this.meta.getBatchSize() : Integer.parseInt(this.environmentSubstitute(this.meta.getFirstMails()));
                Integer start = this.meta.useBatch() ? this.data.start : 1;
                Integer end = this.meta.useBatch() ? this.data.end : batchSize;
                this.data.folderIterator = new BatchFolderIterator(this.data.mailConn.getFolder(), batchSize, start, end);
                if (this.data.mailConn.getSearchTerm() != null) {
                    this.data.folderIterator = new SearchEnabledFolderIterator(this.data.folderIterator, this.data.mailConn.getSearchTerm());
                }
            } else {
                this.data.mailConn.retrieveMessages();
                this.data.folderIterator = new ArrayIterator((Object)this.data.mailConn.getMessages());
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.MessagesInFolder", (Object[])new Object[]{this.data.folder, this.data.messagesCount}));
            }
        }
        catch (Exception e) {
            this.logError("Error opening folder " + this.data.folderenr + " " + this.data.folder + ": " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        if (!super.init(smi, sdi)) {
            return false;
        }
        if (!this.meta.isDynamicFolder()) {
            try {
                this.data.outputRowMeta = new RowMeta();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MailInput.ErrorInit", (String[])new String[]{e.toString()}));
                this.logError(Const.getStackTracker((Throwable)e));
                return false;
            }
        }
        this.data.usePOP = this.meta.getProtocol().equals("POP3");
        String realserver = this.environmentSubstitute(this.meta.getServerName());
        if (this.meta.getProtocol().equals(MailConnectionMeta.PROTOCOL_STRING_MBOX) && StringUtils.startsWith((String)realserver, (String)"file://")) {
            realserver = StringUtils.remove((String)realserver, (String)"file://");
        }
        String realusername = this.environmentSubstitute(this.meta.getUserName());
        String realpassword = Utils.resolvePassword((VariableSpace)this.variables, (String)this.meta.getPassword());
        int realport = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)-1);
        String realProxyUsername = this.environmentSubstitute(this.meta.getProxyUsername());
        if (!this.meta.isDynamicFolder()) {
            String reallimitrow = this.environmentSubstitute(this.meta.getRowLimit());
            int limit = Const.toInt((String)reallimitrow, (int)0);
            if (limit == 0) {
                limit = this.getReadFirst(this.meta.getProtocol());
            }
            this.data.rowlimit = limit;
        }
        Date beginDate = null;
        Date endDate = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            switch (this.meta.getConditionOnReceivedDate()) {
                case 1: 
                case 2: 
                case 3: {
                    String realBeginDate = this.environmentSubstitute(this.meta.getReceivedDate1());
                    if (Utils.isEmpty((CharSequence)realBeginDate)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    break;
                }
                case 4: {
                    String realBeginDate = this.environmentSubstitute(this.meta.getReceivedDate1());
                    if (Utils.isEmpty((CharSequence)realBeginDate)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    String realEndDate = this.environmentSubstitute(this.meta.getReceivedDate2());
                    if (Utils.isEmpty((CharSequence)realEndDate)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    endDate = df.parse(realEndDate);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.SettingSearchTerms", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            this.stopAll();
        }
        try {
            this.data.mailConn = new MailConnection(this.log, MailConnectionMeta.getProtocolFromString(this.meta.getProtocol(), 1), realserver, realport, realusername, realpassword, this.meta.isUseSSL(), this.meta.isUseProxy(), realProxyUsername);
            this.data.mailConn.connect();
            this.applySearch(beginDate, endDate);
            if (!this.meta.isDynamicFolder()) {
                String realIMAPFolder = this.environmentSubstitute(this.meta.getIMAPFolder());
                this.data.folders = this.getFolders(realIMAPFolder);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.OpeningConnection", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            this.stopAll();
        }
        this.data.nrFields = this.meta.getInputFields() != null ? this.meta.getInputFields().length : 0;
        return true;
    }

    private int getReadFirst(String protocol) {
        if (protocol.equals("POP3")) {
            return Const.toInt((String)this.meta.getFirstMails(), (int)0);
        }
        if (protocol.equals("IMAP")) {
            return Const.toInt((String)this.meta.getFirstIMAPMails(), (int)0);
        }
        return 0;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        if (this.data.mailConn != null) {
            try {
                this.data.mailConn.disconnect();
                this.data.mailConn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }

    private Integer parseIntWithSubstitute(String toParse) {
        if (!StringUtils.isEmpty((String)(toParse = this.environmentSubstitute(toParse)))) {
            try {
                return Integer.parseInt(toParse);
            }
            catch (NumberFormatException e) {
                this.log.logError(e.getLocalizedMessage());
            }
        }
        return null;
    }

    class MessageParser {
        MessageParser() {
        }

        Object[] parseToArray(Object[] r, Message message) throws Exception {
            for (int i = 0; i < ((MailInput)MailInput.this).data.nrFields; ++i) {
                int index = ((MailInput)MailInput.this).data.totalpreviousfields + i;
                try {
                    switch (MailInput.this.meta.getInputFields()[i].getColumn()) {
                        case 0: {
                            r[index] = new Long(message.getMessageNumber());
                            break;
                        }
                        case 1: {
                            r[index] = message.getSubject();
                            break;
                        }
                        case 2: {
                            r[index] = StringUtils.join((Object[])message.getFrom(), (String)";");
                            break;
                        }
                        case 3: {
                            r[index] = StringUtils.join((Object[])message.getReplyTo(), (String)";");
                            break;
                        }
                        case 4: {
                            r[index] = StringUtils.join((Object[])message.getAllRecipients(), (String)";");
                            break;
                        }
                        case 5: {
                            r[index] = message.getDescription();
                            break;
                        }
                        case 6: {
                            r[index] = ((MailInput)MailInput.this).data.mailConn.getMessageBody(message);
                            break;
                        }
                        case 7: {
                            Date receivedDate = message.getReceivedDate();
                            r[index] = receivedDate != null ? new Date(receivedDate.getTime()) : null;
                            break;
                        }
                        case 8: {
                            Date sentDate = message.getSentDate();
                            r[index] = sentDate != null ? new Date(sentDate.getTime()) : null;
                            break;
                        }
                        case 9: {
                            r[index] = message.getContentType();
                            break;
                        }
                        case 10: {
                            r[index] = ((MailInput)MailInput.this).data.mailConn.getFolderName();
                            break;
                        }
                        case 11: {
                            r[index] = new Long(message.getSize());
                            break;
                        }
                        case 15: {
                            r[index] = new Boolean(((MailInput)MailInput.this).data.mailConn.isMessageDraft(message));
                            break;
                        }
                        case 14: {
                            r[index] = new Boolean(((MailInput)MailInput.this).data.mailConn.isMessageFlagged(message));
                            break;
                        }
                        case 12: {
                            r[index] = new Boolean(((MailInput)MailInput.this).data.mailConn.isMessageNew(message));
                            break;
                        }
                        case 13: {
                            r[index] = new Boolean(((MailInput)MailInput.this).data.mailConn.isMessageRead(message));
                            break;
                        }
                        case 16: {
                            r[index] = new Boolean(((MailInput)MailInput.this).data.mailConn.isMessageDeleted(message));
                            break;
                        }
                        case 17: {
                            r[index] = new Long(((MailInput)MailInput.this).data.mailConn.getAttachedFilesCount(message, null));
                            break;
                        }
                        case 18: {
                            String name = MailInput.this.meta.getInputFields()[i].getName();
                            String[] arr = new String[]{name};
                            Enumeration en = message.getMatchingHeaders(arr);
                            if (en == null) {
                                r[index] = "";
                                break;
                            }
                            ArrayList<String> headers = new ArrayList<String>();
                            while (en.hasMoreElements()) {
                                Header next = (Header)Header.class.cast(en.nextElement());
                                headers.add(next.getValue());
                            }
                            r[index] = headers.isEmpty() ? "" : StringUtils.join(headers, (String)";");
                            break;
                        }
                        case 19: {
                            r[index] = ((MailInput)MailInput.this).data.mailConn.getMessageBodyContentType(message);
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    String errMsg = "Error adding value for field " + MailInput.this.meta.getInputFields()[i].getName();
                    throw new Exception(errMsg, e);
                }
            }
            return r;
        }
    }
}

