/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gettablenames;

import com.google.common.annotations.VisibleForTesting;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gettablenames.GetTableNamesData;
import org.pentaho.di.trans.steps.gettablenames.GetTableNamesMeta;

public class GetTableNames
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetTableNamesMeta.class;
    private GetTableNamesMeta meta;
    private GetTableNamesData data;

    public GetTableNames(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GetTableNamesMeta)smi;
        this.data = (GetTableNamesData)sdi;
        if (this.meta.isDynamicSchema()) {
            this.data.readrow = this.getRow();
            if (this.data.readrow == null) {
                this.setOutputDone();
                return false;
            }
        }
        if (this.first) {
            this.first = false;
            if (this.meta.isDynamicSchema()) {
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.data.totalpreviousfields = this.data.inputRowMeta.size();
                if (Utils.isEmpty((CharSequence)this.meta.getSchemaFieldName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Log.NoSchemaField", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"GetTableNames.Log.NoSchemaField", (String[])new String[0]));
                }
                if (this.data.indexOfSchemaField < 0) {
                    this.data.indexOfSchemaField = this.data.inputRowMeta.indexOfValue(this.meta.getSchemaFieldName());
                    if (this.data.indexOfSchemaField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getSchemaFieldName() + "]");
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GetTableNames.Exception.CouldnotFindField", (String[])new String[]{this.meta.getSchemaFieldName()}));
                    }
                }
            } else {
                this.data.outputRowMeta = new RowMeta();
            }
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
        }
        if (this.meta.isDynamicSchema()) {
            this.data.realSchemaName = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfSchemaField);
        }
        Object[] outputRow = this.buildEmptyRow();
        if (this.meta.isDynamicSchema()) {
            System.arraycopy(this.data.readrow, 0, outputRow, 0, this.data.readrow.length);
        }
        this.processIncludeCatalog(outputRow);
        this.processIncludeSchema(outputRow);
        this.processIncludeTable(outputRow);
        this.processIncludeView(outputRow);
        this.processIncludeProcedure(outputRow);
        this.processIncludeSynonym(outputRow);
        if (!this.meta.isDynamicSchema()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void processIncludeSynonym(Object[] outputRow) throws KettleDatabaseException, KettleStepException, KettleValueException {
        if (this.meta.isIncludeSynonym()) {
            String[] synonyms = this.data.db.getSynonyms(this.data.realSchemaName, this.meta.isAddSchemaInOut());
            String ObjectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Synonym", (String[])new String[0]);
            for (int i = 0; i < synonyms.length && !this.isStopped(); ++i) {
                Object[] outputRowSyn = (Object[])outputRow.clone();
                int outputIndex = this.data.totalpreviousfields;
                String synonym = synonyms[i];
                outputRowSyn[outputIndex++] = synonym;
                if (!Utils.isEmpty((CharSequence)this.data.realObjectTypeFieldName)) {
                    outputRowSyn[outputIndex++] = ObjectType;
                }
                if (!Utils.isEmpty((CharSequence)this.data.realIsSystemObjectFieldName)) {
                    outputRowSyn[outputIndex++] = this.data.db.isSystemTable(synonym);
                }
                if (!Utils.isEmpty((CharSequence)this.data.realSQLCreationFieldName)) {
                    outputRowSyn[outputIndex++] = null;
                }
                ++this.data.rownr;
                this.putRow(this.data.outputRowMeta, outputRowSyn);
                this.logInfo(outputRowSyn);
            }
        }
    }

    private void processIncludeProcedure(Object[] outputRow) throws KettleDatabaseException, KettleStepException, KettleValueException {
        if (this.meta.isIncludeProcedure()) {
            String[] procNames = this.data.db.getProcedures();
            String ObjectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Procedure", (String[])new String[0]);
            for (int i = 0; i < procNames.length && !this.isStopped(); ++i) {
                Object[] outputRowProc = (Object[])outputRow.clone();
                int outputIndex = this.data.totalpreviousfields;
                String procName = procNames[i];
                outputRowProc[outputIndex++] = procName;
                if (!Utils.isEmpty((CharSequence)this.data.realObjectTypeFieldName)) {
                    outputRowProc[outputIndex++] = ObjectType;
                }
                if (!Utils.isEmpty((CharSequence)this.data.realIsSystemObjectFieldName)) {
                    outputRowProc[outputIndex++] = this.data.db.isSystemTable(procName);
                }
                if (!Utils.isEmpty((CharSequence)this.data.realSQLCreationFieldName)) {
                    outputRowProc[outputIndex++] = null;
                }
                ++this.data.rownr;
                this.putRow(this.data.outputRowMeta, outputRowProc);
                this.logInfo(outputRowProc);
            }
        }
    }

    @VisibleForTesting
    void processIncludeView(Object[] outputRow) {
        if (this.meta.isIncludeView()) {
            try {
                String[] viewNames = this.data.db.getViews(this.data.realSchemaName, this.meta.isAddSchemaInOut());
                String[] viewNamesWithoutSchema = this.data.db.getViews(this.data.realSchemaName, false);
                String ObjectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.View", (String[])new String[0]);
                for (int i = 0; i < viewNames.length && !this.isStopped(); ++i) {
                    Object[] outputRowView = (Object[])outputRow.clone();
                    int outputIndex = this.data.totalpreviousfields;
                    String viewName = viewNames[i];
                    String viewNameWithoutSchema = viewNamesWithoutSchema[i];
                    outputRowView[outputIndex++] = viewName;
                    if (!Utils.isEmpty((CharSequence)this.data.realObjectTypeFieldName)) {
                        outputRowView[outputIndex++] = ObjectType;
                    }
                    if (!Utils.isEmpty((CharSequence)this.data.realIsSystemObjectFieldName)) {
                        outputRowView[outputIndex++] = this.data.db.isSystemTable(viewNameWithoutSchema);
                    }
                    if (!Utils.isEmpty((CharSequence)this.data.realSQLCreationFieldName)) {
                        outputRowView[outputIndex++] = null;
                    }
                    ++this.data.rownr;
                    this.putRow(this.data.outputRowMeta, outputRowView);
                    this.logInfo(outputRowView);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @VisibleForTesting
    void processIncludeTable(Object[] outputRow) throws KettleDatabaseException, KettleStepException, KettleValueException {
        if (this.meta.isIncludeTable()) {
            String[] tableNames = this.data.db.getTablenames(this.data.realSchemaName, this.meta.isAddSchemaInOut());
            String[] tableNamesWithoutSchema = this.data.db.getTablenames(this.data.realSchemaName, false);
            String ObjectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Table", (String[])new String[0]);
            for (int i = 0; i < tableNames.length && !this.isStopped(); ++i) {
                int IndexOfLastClosedBracket;
                Object[] outputRowTable = (Object[])outputRow.clone();
                int outputIndex = this.data.totalpreviousfields;
                String tableName = tableNames[i];
                String tableNameWithoutSchema = tableNamesWithoutSchema[i];
                outputRowTable[outputIndex++] = tableName;
                if (!Utils.isEmpty((CharSequence)this.data.realObjectTypeFieldName)) {
                    outputRowTable[outputIndex++] = ObjectType;
                }
                if (!Utils.isEmpty((CharSequence)this.data.realIsSystemObjectFieldName)) {
                    outputRowTable[outputIndex++] = this.data.db.isSystemTable(tableNameWithoutSchema);
                }
                String pk = null;
                String[] pkc = this.data.db.getPrimaryKeyColumnNames(tableNameWithoutSchema);
                if (pkc != null && pkc.length == 1) {
                    pk = pkc[0];
                }
                String sql = this.data.db.getCreateTableStatement(tableName, this.data.db.getTableFieldsMeta(this.data.realSchemaName, tableNameWithoutSchema), null, false, pk, true);
                if (pkc != null && pkc.length > 0 && (IndexOfLastClosedBracket = sql.lastIndexOf(")")) > -1) {
                    sql = sql.substring(0, IndexOfLastClosedBracket);
                    sql = sql + ", PRIMARY KEY (";
                    for (int k = 0; k < pkc.length; ++k) {
                        if (k > 0) {
                            sql = sql + ", ";
                        }
                        sql = sql + pkc[k];
                    }
                    sql = sql + ")" + Const.CR + ")" + Const.CR + ";";
                }
                if (!Utils.isEmpty((CharSequence)this.data.realSQLCreationFieldName)) {
                    outputRowTable[outputIndex++] = sql;
                }
                ++this.data.rownr;
                this.putRow(this.data.outputRowMeta, outputRowTable);
                this.logInfo(outputRowTable);
            }
        }
    }

    private void processIncludeSchema(Object[] outputRow) throws KettleDatabaseException, KettleStepException, KettleValueException {
        if (this.meta.isIncludeSchema()) {
            String ObjectType = BaseMessages.getString(PKG, (String)"GetTableNamesDialog.ObjectType.Schema", (String[])new String[0]);
            String[] schemaNames = new String[]{};
            schemaNames = !Utils.isEmpty((CharSequence)this.data.realSchemaName) ? new String[]{this.data.realSchemaName} : this.data.db.getSchemas();
            for (int i = 0; i < schemaNames.length && !this.isStopped(); ++i) {
                Object[] outputRowSchema = (Object[])outputRow.clone();
                int outputIndex = this.data.totalpreviousfields;
                String schemaName = schemaNames[i];
                outputRowSchema[outputIndex++] = schemaName;
                if (!Utils.isEmpty((CharSequence)this.data.realObjectTypeFieldName)) {
                    outputRowSchema[outputIndex++] = ObjectType;
                }
                if (!Utils.isEmpty((CharSequence)this.data.realIsSystemObjectFieldName)) {
                    outputRowSchema[outputIndex++] = this.data.db.isSystemTable(schemaName);
                }
                if (!Utils.isEmpty((CharSequence)this.data.realSQLCreationFieldName)) {
                    outputRowSchema[outputIndex++] = null;
                }
                ++this.data.rownr;
                this.putRow(this.data.outputRowMeta, outputRowSchema);
                this.logInfo(outputRowSchema);
            }
        }
    }

    private void processIncludeCatalog(Object[] outputRow) throws KettleDatabaseException, KettleStepException, KettleValueException {
        if (this.meta.isIncludeCatalog()) {
            String ObjectType = BaseMessages.getString(PKG, (String)"GetTableNames.ObjectType.Catalog", (String[])new String[0]);
            String[] catalogsNames = this.data.db.getCatalogs();
            for (int i = 0; i < catalogsNames.length && !this.isStopped(); ++i) {
                Object[] outputRowCatalog = (Object[])outputRow.clone();
                int outputIndex = this.data.totalpreviousfields;
                String catalogName = catalogsNames[i];
                outputRowCatalog[outputIndex++] = catalogName;
                if (!Utils.isEmpty((CharSequence)this.data.realObjectTypeFieldName)) {
                    outputRowCatalog[outputIndex++] = ObjectType;
                }
                if (!Utils.isEmpty((CharSequence)this.data.realIsSystemObjectFieldName)) {
                    outputRowCatalog[outputIndex++] = this.data.db.isSystemTable(catalogName);
                }
                if (!Utils.isEmpty((CharSequence)this.data.realSQLCreationFieldName)) {
                    outputRowCatalog[outputIndex++] = null;
                }
                ++this.data.rownr;
                this.putRow(this.data.outputRowMeta, outputRowCatalog);
                this.logInfo(outputRowCatalog);
            }
        }
    }

    private void logInfo(Object[] outputRow) throws KettleValueException {
        if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"GetTableNames.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"GetTableNames.Log.PutoutRow", (String[])new String[]{this.data.outputRowMeta.getString(outputRow)}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        block14: {
            this.meta = (GetTableNamesMeta)smi;
            this.data = (GetTableNamesData)sdi;
            if (super.init(smi, sdi)) {
                if (Utils.isEmpty((CharSequence)this.meta.getTablenameFieldName())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Error.TablenameFieldNameMissing", (String[])new String[0]));
                    return false;
                }
                String realSchemaName = this.environmentSubstitute(this.meta.getSchemaName());
                if (!Utils.isEmpty((CharSequence)realSchemaName)) {
                    this.data.realSchemaName = realSchemaName;
                }
                this.data.realTableNameFieldName = this.environmentSubstitute(this.meta.getTablenameFieldName());
                this.data.realObjectTypeFieldName = this.environmentSubstitute(this.meta.getObjectTypeFieldName());
                this.data.realIsSystemObjectFieldName = this.environmentSubstitute(this.meta.isSystemObjectFieldName());
                this.data.realSQLCreationFieldName = this.environmentSubstitute(this.meta.getSQLCreationFieldName());
                if (!(this.meta.isIncludeCatalog() || this.meta.isIncludeSchema() || this.meta.isIncludeTable() || this.meta.isIncludeView() || this.meta.isIncludeProcedure() || this.meta.isIncludeSynonym())) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Error.includeAtLeastOneType", (String[])new String[0]));
                    return false;
                }
                try {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
                }
                catch (Exception e) {
                    this.logError("Error initializing step: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
                this.data.db = new Database((LoggingObjectInterface)this, this.meta.getDatabase());
                this.data.db.shareVariablesWith((VariableSpace)this);
                try {
                    if (this.getTransMeta().isUsingUniqueConnections()) {
                        Trans e = this.getTrans();
                        synchronized (e) {
                            this.data.db.connect(this.getTrans().getTransactionId(), this.getPartitionID());
                        }
                    } else {
                        this.data.db.connect(this.getPartitionID());
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"GetTableNames.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    return true;
                }
                catch (KettleException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetTableNames.Log.DBException", (String[])new String[0]) + e.getMessage());
                    if (this.data.db == null) break block14;
                    this.data.db.disconnect();
                }
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetTableNamesMeta)smi;
        this.data = (GetTableNamesData)sdi;
        if (this.data.db != null) {
            this.data.db.disconnect();
            this.data.db = null;
        }
        super.dispose(smi, sdi);
    }
}

