/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.Metrics;
import org.pentaho.di.core.logging.MetricsInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepMetaDataCombi;

public class StepInitThread
implements Runnable {
    private static Class<?> PKG = Trans.class;
    public boolean ok;
    public boolean finished;
    public boolean doIt;
    private StepMetaDataCombi combi;
    private LogChannelInterface log;

    public StepInitThread(StepMetaDataCombi combi, LogChannelInterface log) {
        this.combi = combi;
        this.log = combi.step.getLogChannel();
        this.ok = false;
        this.finished = false;
        this.doIt = true;
    }

    public String toString() {
        return this.combi.stepname;
    }

    @Override
    public void run() {
        if (!this.doIt) {
            return;
        }
        try {
            this.combi.step.getLogChannel().snap((MetricsInterface)Metrics.METRIC_STEP_INIT_START, new long[0]);
            if (this.combi.step.init(this.combi.meta, this.combi.data)) {
                this.combi.data.setStatus(BaseStepData.StepExecutionStatus.STATUS_IDLE);
                this.ok = true;
            } else {
                this.combi.step.setErrors(1L);
                this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.ErrorInitializingStep", (String[])new String[]{this.combi.step.getStepname()}));
            }
        }
        catch (Throwable e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"Trans.Log.ErrorInitializingStep", (String[])new String[]{this.combi.step.getStepname()}));
            this.log.logError(Const.getStackTracker((Throwable)e));
        }
        finally {
            this.combi.step.getLogChannel().snap((MetricsInterface)Metrics.METRIC_STEP_INIT_STOP, new long[0]);
        }
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isOk() {
        return this.ok;
    }

    public StepMetaDataCombi getCombi() {
        return this.combi;
    }

    public void setCombi(StepMetaDataCombi combi) {
        this.combi = combi;
    }

    public boolean isDoIt() {
        return this.doIt;
    }

    public void setDoIt(boolean doIt) {
        this.doIt = doIt;
    }
}

