/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import java.util.List;
import java.util.Objects;
import org.pentaho.di.base.BaseHopMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

public class TransHopMeta
extends BaseHopMeta<StepMeta>
implements Comparable<TransHopMeta> {
    private static Class<?> PKG = Trans.class;
    public static final String XML_HOP_TAG = "hop";
    public static final String XML_FROM_TAG = "from";
    public static final String XML_TO_TAG = "to";

    public TransHopMeta(StepMeta from, StepMeta to, boolean en) {
        this.from = from;
        this.to = to;
        this.enabled = en;
    }

    public TransHopMeta(StepMeta from, StepMeta to) {
        this.from = from;
        this.to = to;
        this.enabled = true;
    }

    public TransHopMeta() {
        this(null, null, false);
    }

    public TransHopMeta(Node hopnode, List<StepMeta> steps) throws KettleXMLException {
        try {
            this.from = this.searchStep(steps, XMLHandler.getTagValue((Node)hopnode, (String)XML_FROM_TAG));
            this.to = this.searchStep(steps, XMLHandler.getTagValue((Node)hopnode, (String)XML_TO_TAG));
            String en = XMLHandler.getTagValue((Node)hopnode, (String)"enabled");
            this.enabled = en == null ? true : en.equalsIgnoreCase("Y");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TransHopMeta.Exception.UnableToLoadHopInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setFromStep(StepMeta from) {
        this.from = from;
    }

    public void setToStep(StepMeta to) {
        this.to = to;
    }

    public StepMeta getFromStep() {
        return (StepMeta)this.from;
    }

    public StepMeta getToStep() {
        return (StepMeta)this.to;
    }

    private StepMeta searchStep(List<StepMeta> steps, String name) {
        for (StepMeta stepMeta : steps) {
            if (!stepMeta.getName().equalsIgnoreCase(name)) continue;
            return stepMeta;
        }
        return null;
    }

    public boolean equals(Object obj) {
        TransHopMeta other = (TransHopMeta)obj;
        if (this.from == null || this.to == null) {
            return false;
        }
        return ((StepMeta)this.from).equals(other.getFromStep()) && ((StepMeta)this.to).equals(other.getToStep());
    }

    public int hashCode() {
        return Objects.hash(this.to, this.from);
    }

    @Override
    public int compareTo(TransHopMeta obj) {
        return this.toString().compareTo(obj.toString());
    }

    public void flip() {
        StepMeta dummy = (StepMeta)this.from;
        this.from = this.to;
        this.to = dummy;
    }

    public String toString() {
        String str_fr = this.from == null ? "(empty)" : ((StepMeta)this.from).getName();
        String str_to = this.to == null ? "(empty)" : ((StepMeta)this.to).getName();
        return str_fr + " --> " + str_to + " (" + (this.enabled ? "enabled" : "disabled") + ")";
    }

    public String getXML() {
        StringBuilder retval = new StringBuilder(200);
        if (this.from != null && this.to != null) {
            retval.append("    ").append(XMLHandler.openTag((String)XML_HOP_TAG)).append(Const.CR);
            retval.append("      ").append(XMLHandler.addTagValue((String)XML_FROM_TAG, (String)((StepMeta)this.from).getName()));
            retval.append("      ").append(XMLHandler.addTagValue((String)XML_TO_TAG, (String)((StepMeta)this.to).getName()));
            retval.append("      ").append(XMLHandler.addTagValue((String)"enabled", (boolean)this.enabled));
            retval.append("    ").append(XMLHandler.closeTag((String)XML_HOP_TAG)).append(Const.CR);
        }
        return retval.toString();
    }
}

