/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.List;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleDependencyException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBoolean;
import org.pentaho.di.core.row.value.ValueMetaInteger;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositoryClusterSchemaDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    public KettleDatabaseRepositoryClusterSchemaDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getClusterSchema(ObjectId id_cluster_schema) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_CLUSTER"), this.quote("ID_CLUSTER"), id_cluster_schema);
    }

    public synchronized ObjectId getClusterID(String name) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_CLUSTER"), this.quote("ID_CLUSTER"), this.quote("NAME"), name);
    }

    public ClusterSchema loadClusterSchema(ObjectId id_cluster_schema, List<SlaveServer> slaveServers) throws KettleException {
        ClusterSchema clusterSchema = new ClusterSchema();
        RowMetaAndData row = this.getClusterSchema(id_cluster_schema);
        clusterSchema.setObjectId(id_cluster_schema);
        clusterSchema.setName(row.getString("NAME", null));
        clusterSchema.setBasePort(row.getString("BASE_PORT", null));
        clusterSchema.setSocketsBufferSize(row.getString("SOCKETS_BUFFER_SIZE", null));
        clusterSchema.setSocketsFlushInterval(row.getString("SOCKETS_FLUSH_INTERVAL", null));
        clusterSchema.setSocketsCompressed(row.getBoolean("SOCKETS_COMPRESSED", true));
        clusterSchema.setDynamic(row.getBoolean("DYNAMIC_CLUSTER", true));
        ObjectId[] pids = this.repository.getClusterSlaveIDs(id_cluster_schema);
        for (int i = 0; i < pids.length; ++i) {
            SlaveServer slaveServer = this.repository.loadSlaveServer(pids[i], null);
            SlaveServer reference = SlaveServer.findSlaveServer(slaveServers, slaveServer.getName());
            if (reference != null) {
                clusterSchema.getSlaveServers().add(reference);
                continue;
            }
            clusterSchema.getSlaveServers().add(slaveServer);
        }
        return clusterSchema;
    }

    public void saveClusterSchema(ClusterSchema clusterSchema, String versionComment) throws KettleException {
        this.saveClusterSchema(clusterSchema, versionComment, null, false);
    }

    public void saveClusterSchema(ClusterSchema clusterSchema, String versionComment, ObjectId id_transformation, boolean isUsedByTransformation) throws KettleException {
        try {
            this.saveClusterSchema(clusterSchema, versionComment, id_transformation, isUsedByTransformation, false);
        }
        catch (KettleObjectExistsException e) {
            this.log.logBasic(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveClusterSchema(ClusterSchema clusterSchema, String versionComment, ObjectId id_transformation, boolean isUsedByTransformation, boolean overwrite) throws KettleException {
        ObjectId existingClusterSchemaId = this.getClusterID(clusterSchema.getName());
        if (existingClusterSchemaId != null) {
            clusterSchema.setObjectId(existingClusterSchemaId);
        }
        if (clusterSchema.getObjectId() == null) {
            clusterSchema.setObjectId(this.insertCluster(clusterSchema));
        } else if (existingClusterSchemaId != null && !clusterSchema.getObjectId().equals(existingClusterSchemaId)) {
            if (!overwrite) throw new KettleObjectExistsException("Failed to save object to repository. Object [" + clusterSchema.getName() + "] already exists.");
            this.repository.deleteClusterSchema(existingClusterSchemaId);
            this.updateCluster(clusterSchema);
        } else {
            this.updateCluster(clusterSchema);
        }
        this.repository.delClusterSlaves(clusterSchema.getObjectId());
        for (int i = 0; i < clusterSchema.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = clusterSchema.getSlaveServers().get(i);
            if (slaveServer.getObjectId() == null) {
                this.repository.save(slaveServer, versionComment, null, id_transformation, isUsedByTransformation, overwrite);
            }
            this.repository.insertClusterSlave(clusterSchema, slaveServer);
        }
        if (!isUsedByTransformation) return;
        this.repository.insertTransformationCluster(id_transformation, clusterSchema.getObjectId());
    }

    private synchronized ObjectId insertCluster(ClusterSchema clusterSchema) throws KettleException {
        if (this.getClusterID(clusterSchema.getName()) != null) {
            throw new KettleObjectExistsException("Failed to create object in repository. Object [" + clusterSchema.getName() + "] already exists.");
        }
        ObjectId id = this.repository.connectionDelegate.getNextClusterID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_CLUSTER"), (Object)id);
        table.addValue((ValueMetaInterface)new ValueMetaString("NAME"), (Object)clusterSchema.getName());
        table.addValue((ValueMetaInterface)new ValueMetaString("BASE_PORT"), (Object)clusterSchema.getBasePort());
        table.addValue((ValueMetaInterface)new ValueMetaString("SOCKETS_BUFFER_SIZE"), (Object)clusterSchema.getSocketsBufferSize());
        table.addValue((ValueMetaInterface)new ValueMetaString("SOCKETS_FLUSH_INTERVAL"), (Object)clusterSchema.getSocketsFlushInterval());
        table.addValue((ValueMetaInterface)new ValueMetaBoolean("SOCKETS_COMPRESSED"), (Object)clusterSchema.isSocketsCompressed());
        table.addValue((ValueMetaInterface)new ValueMetaBoolean("DYNAMIC_CLUSTER"), (Object)clusterSchema.isDynamic());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_CLUSTER");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized void updateCluster(ClusterSchema clusterSchema) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue((ValueMetaInterface)new ValueMetaInteger("ID_CLUSTER"), (Object)clusterSchema.getObjectId());
        table.addValue((ValueMetaInterface)new ValueMetaString("NAME"), (Object)clusterSchema.getName());
        table.addValue((ValueMetaInterface)new ValueMetaString("BASE_PORT"), (Object)clusterSchema.getBasePort());
        table.addValue((ValueMetaInterface)new ValueMetaString("SOCKETS_BUFFER_SIZE"), (Object)clusterSchema.getSocketsBufferSize());
        table.addValue((ValueMetaInterface)new ValueMetaString("SOCKETS_FLUSH_INTERVAL"), (Object)clusterSchema.getSocketsFlushInterval());
        table.addValue((ValueMetaInterface)new ValueMetaBoolean("SOCKETS_COMPRESSED"), (Object)clusterSchema.isSocketsCompressed());
        table.addValue((ValueMetaInterface)new ValueMetaBoolean("DYNAMIC_CLUSTER"), (Object)clusterSchema.isDynamic());
        this.repository.connectionDelegate.updateTableRow("R_CLUSTER", "ID_CLUSTER", table, clusterSchema.getObjectId());
    }

    public synchronized void delClusterSchema(ObjectId id_cluster) throws KettleException {
        String[] transList = this.repository.getTransformationsUsingCluster(id_cluster);
        if (transList.length != 0) {
            StringBuilder message = new StringBuilder();
            message.append("The cluster schema is used by the following transformations:").append(Const.CR);
            for (int i = 0; i < transList.length; ++i) {
                message.append("  ").append(transList[i]).append(Const.CR);
            }
            message.append(Const.CR);
            KettleDependencyException e = new KettleDependencyException(message.toString());
            throw new KettleDependencyException("This cluster schema is still in use by one or more transformations (" + transList.length + ") :", (Throwable)e);
        }
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_CLUSTER") + " WHERE " + this.quote("ID_CLUSTER") + " = ? ", id_cluster);
    }

    public synchronized void renameClusterSchema(ObjectId id_cluster, String new_name) throws KettleException {
    }
}

