/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.rule.ImportValidationFeedback;

public final class ExportFeedback {
    private static Class<?> PKG = ExportFeedback.class;
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private Date time = new Date();
    private Type type;
    private Status status;
    private String itemPath;
    private String itemName;
    private List<ImportValidationFeedback> result;
    private boolean isSimpleString;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getItemPath() {
        return this.itemPath;
    }

    public void setItemPath(String itemPath) {
        this.itemPath = itemPath;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public List<ImportValidationFeedback> getResult() {
        return this.result;
    }

    public void setResult(List<ImportValidationFeedback> result) {
        this.result = result;
    }

    public boolean isSimpleString() {
        return this.isSimpleString;
    }

    public void setSimpleString(boolean isSimpleString) {
        this.isSimpleString = isSimpleString;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.itemName == null ? 0 : this.itemName.hashCode());
        result = 31 * result + (this.itemPath == null ? 0 : this.itemPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExportFeedback other = (ExportFeedback)obj;
        if (this.itemName == null ? other.itemName != null : !this.itemName.equals(other.itemName)) {
            return false;
        }
        return !(this.itemPath == null ? other.itemPath != null : !this.itemPath.equals(other.itemPath));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String message = null;
        if (this.isSimpleString) {
            message = BaseMessages.getString(PKG, (String)"ExportFeedback.Message.Simple", (String[])new String[]{sdf.format(this.getTime()), this.getItemName()});
            sb.append(message);
            sb.append(Const.CR);
            return sb.toString();
        }
        message = BaseMessages.getString(PKG, (String)"ExportFeedback.Message.Main", (String[])new String[]{sdf.format(this.getTime()), this.getStatus().getStatus(), this.getItemName(), this.getItemPath()});
        sb.append(message);
        sb.append(Const.CR);
        if (this.getStatus().equals((Object)Status.REJECTED)) {
            List<ImportValidationFeedback> fList = this.getResult();
            for (ImportValidationFeedback res : fList) {
                message = BaseMessages.getString(PKG, (String)"ExportFeedback.Message.RuleViolated", (String[])new String[]{res.getComment()});
                sb.append(message);
                sb.append(Const.CR);
            }
        }
        return sb.toString();
    }

    static /* synthetic */ Class access$000() {
        return PKG;
    }

    public static enum Type {
        JOB(BaseMessages.getString((Class)ExportFeedback.access$000(), (String)"ExportFeedback.Type.Job", (String[])new String[0])),
        TRANSFORMATION(BaseMessages.getString((Class)ExportFeedback.access$000(), (String)"ExportFeedback.Type.Transformation", (String[])new String[0]));

        private String type;

        private Type(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static enum Status {
        REJECTED(BaseMessages.getString((Class)ExportFeedback.access$000(), (String)"ExportFeedback.Status.Rejected", (String[])new String[0])),
        EXPORTED(BaseMessages.getString((Class)ExportFeedback.access$000(), (String)"ExportFeedback.Status.Exported", (String[])new String[0]));

        private String status;

        private Status(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

