/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.util.FileBufferedOutputStream;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;

public class PdfServlet
extends BaseHttpServlet {
    private static final long serialVersionUID = 10200L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        List<JasperPrint> jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        Boolean isBuffered = Boolean.valueOf(request.getParameter("buffered"));
        if (isBuffered.booleanValue()) {
            FileBufferedOutputStream fbos = new FileBufferedOutputStream();
            JRPdfExporter exporter = new JRPdfExporter(DefaultJasperReportsContext.getInstance());
            exporter.setExporterInput(SimpleExporterInput.getInstance(jasperPrintList));
            exporter.setExporterOutput(new SimpleOutputStreamExporterOutput(fbos));
            try {
                exporter.exportReport();
                fbos.close();
                if (fbos.size() <= 0) return;
                response.setContentType("application/pdf");
                response.setContentLength(fbos.size());
                ServletOutputStream outputStream = response.getOutputStream();
                try {
                    fbos.writeData((OutputStream)outputStream);
                    fbos.dispose();
                    outputStream.flush();
                    return;
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (JRException e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                fbos.close();
                fbos.dispose();
            }
        }
        response.setContentType("application/pdf");
        JRPdfExporter exporter = new JRPdfExporter(DefaultJasperReportsContext.getInstance());
        exporter.setExporterInput(SimpleExporterInput.getInstance(jasperPrintList));
        ServletOutputStream outputStream = response.getOutputStream();
        exporter.setExporterOutput(new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
        try {
            exporter.exportReport();
            return;
        }
        catch (JRException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

