/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.j2ee.servlets;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.j2ee.servlets.BaseHttpServlet;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.util.RendererUtil;
import net.sf.jasperreports.repo.RepositoryUtil;

public class ImageServlet
extends BaseHttpServlet {
    private static final long serialVersionUID = 10200L;
    public static final String IMAGE_NAME_REQUEST_PARAMETER = "image";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] imageData = null;
        String imageMimeType = null;
        String imageName = request.getParameter(IMAGE_NAME_REQUEST_PARAMETER);
        if ("px".equals(imageName)) {
            try {
                imageData = RepositoryUtil.getInstance(this.getJasperReportsContext()).getBytesFromLocation("net/sf/jasperreports/engine/images/white-transparent-pixel.png");
                imageMimeType = ImageTypeEnum.PNG.getMimeType();
            }
            catch (JRException e) {
                throw new ServletException((Throwable)e);
            }
        }
        List<JasperPrint> jasperPrintList = BaseHttpServlet.getJasperPrintList(request);
        if (jasperPrintList == null) {
            throw new ServletException("No JasperPrint documents found on the HTTP session.");
        }
        JRPrintImage image = HtmlExporter.getImage(jasperPrintList, imageName);
        Renderable renderer = image.getRenderer();
        Dimension dimension = new Dimension(image.getWidth(), image.getHeight());
        Color backcolor = ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null;
        RendererUtil rendererUtil = RendererUtil.getInstance(this.getJasperReportsContext());
        try {
            imageData = this.process(renderer, dimension, backcolor);
        }
        catch (Exception e) {
            try {
                Renderable onErrorRenderer = rendererUtil.handleImageError(e, image.getOnErrorTypeValue());
                if (onErrorRenderer != null) {
                    imageData = this.process(onErrorRenderer, dimension, backcolor);
                }
            }
            catch (Exception ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        String string = imageMimeType = rendererUtil.isSvgData(imageData) ? "image/svg+xml" : JRTypeSniffer.getImageTypeValue(imageData).getMimeType();
        if (imageData != null && imageData.length > 0) {
            if (imageMimeType != null) {
                response.setHeader("Content-Type", imageMimeType);
            }
            response.setContentLength(imageData.length);
            ServletOutputStream outputStream = response.getOutputStream();
            outputStream.write(imageData, 0, imageData.length);
            outputStream.flush();
            outputStream.close();
        }
    }

    protected byte[] process(Renderable renderer, Dimension dimension, Color backcolor) throws JRException {
        RendererUtil rendererUtil = RendererUtil.getInstance(this.getJasperReportsContext());
        if (renderer instanceof ResourceRenderer) {
            renderer = rendererUtil.getNonLazyRenderable(((ResourceRenderer)renderer).getResourceLocation(), OnErrorTypeEnum.ERROR);
        }
        DataRenderable dataRenderer = rendererUtil.getDataRenderable(renderer, dimension, backcolor);
        return dataRenderer.getData(this.getJasperReportsContext());
    }
}

