/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.FileHtmlResourceHandler;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.MapHtmlResourceHandler;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;
import net.sf.jasperreports.web.util.WebHtmlResourceHandler;

public class ParametersHtmlExporterOutput
extends ParametersWriterExporterOutput
implements HtmlExporterOutput {
    private HtmlResourceHandler imageHandler;
    private HtmlResourceHandler fontHandler;
    private HtmlResourceHandler resourceHandler;

    public ParametersHtmlExporterOutput(JasperReportsContext jasperReportsContext, Map<JRExporterParameter, Object> parameters, JasperPrint jasperPrint) {
        super(jasperReportsContext, parameters, jasperPrint);
        Map imageNameToImageDataMap;
        OutputStream os;
        Writer writer;
        Boolean isOutputImagesToDirParameter = (Boolean)parameters.get(JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR);
        String imagesUri = (String)parameters.get(JRHtmlExporterParameter.IMAGES_URI);
        if (this.imageHandler == null) {
            if (isOutputImagesToDirParameter == null || isOutputImagesToDirParameter.booleanValue()) {
                String imagesDirName;
                File imagesDir = (File)parameters.get(JRHtmlExporterParameter.IMAGES_DIR);
                if (imagesDir == null && (imagesDirName = (String)parameters.get(JRHtmlExporterParameter.IMAGES_DIR_NAME)) != null) {
                    imagesDir = new File(imagesDirName);
                }
                if (imagesDir != null) {
                    this.imageHandler = new FileHtmlResourceHandler(imagesDir, imagesUri == null ? imagesDir.getName() + "/{0}" : imagesUri + "{0}");
                }
            }
            if (this.imageHandler == null && imagesUri != null) {
                this.imageHandler = new WebHtmlResourceHandler(imagesUri + "{0}");
            }
        }
        this.resourceHandler = (HtmlResourceHandler)parameters.get(JRHtmlExporterParameter.RESOURCE_HANDLER);
        StringBuffer sb = (StringBuffer)parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb == null && (writer = (Writer)parameters.get(JRExporterParameter.OUTPUT_WRITER)) == null && (os = (OutputStream)parameters.get(JRExporterParameter.OUTPUT_STREAM)) == null) {
            File resourcesDir;
            File destFile = (File)parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (destFile == null) {
                String fileName = (String)parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    destFile = new File(fileName);
                } else {
                    throw new JRRuntimeException("export.parameters.no.output.specified", (Object[])null);
                }
            }
            if (this.imageHandler == null && (isOutputImagesToDirParameter == null || isOutputImagesToDirParameter.booleanValue())) {
                File imagesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                this.imageHandler = new FileHtmlResourceHandler(imagesDir, imagesUri == null ? imagesDir.getName() + "/{0}" : imagesUri + "{0}");
            }
            if (this.fontHandler == null) {
                resourcesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                this.fontHandler = new FileHtmlResourceHandler(resourcesDir, resourcesDir.getName() + "/{0}");
            }
            if (this.resourceHandler == null) {
                resourcesDir = new File(destFile.getParent(), destFile.getName() + "_files");
                this.resourceHandler = new FileHtmlResourceHandler(resourcesDir, resourcesDir.getName() + "/{0}");
            }
        }
        if ((imageNameToImageDataMap = (Map)parameters.get(JRHtmlExporterParameter.IMAGES_MAP)) != null) {
            this.imageHandler = new MapHtmlResourceHandler(this.imageHandler, imageNameToImageDataMap);
        }
    }

    @Override
    public HtmlResourceHandler getImageHandler() {
        return this.imageHandler;
    }

    @Override
    public HtmlResourceHandler getFontHandler() {
        return this.fontHandler;
    }

    @Override
    public HtmlResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }
}

