/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.lang.reflect.Constructor;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.virtualization.ObjectSerializer;
import net.sf.jasperreports.engine.virtualization.ReferenceType;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;
import net.sf.jasperreports.engine.virtualization.VirtualizationSerializable;

public class SerializableSerializer<T extends VirtualizationSerializable>
implements ObjectSerializer<T> {
    public static final String EXCEPTION_MESSAGE_KEY_CLASS_INSTANCE_ERROR = "engine.virtualization.serializable.serializer.class.instance.error";
    public static final String EXCEPTION_MESSAGE_KEY_INITIALIZATION_FAILED = "engine.virtualization.serializable.serializer.initialization.failed";
    public static final String EXCEPTION_MESSAGE_KEY_UNEXPECTED_VALUE_TYPE = "engine.virtualization.serializable.serializer.unexpected.value.type";
    private static final Class<?>[] NO_ARGS_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];
    private final int typeValue;
    private final Class<T> type;
    private final Constructor<T> constructor;

    public SerializableSerializer(int typeValue, Class<T> type) {
        this.typeValue = typeValue;
        this.type = type;
        this.constructor = this.initConstructor();
    }

    private Constructor<T> initConstructor() {
        try {
            return this.type.getConstructor(NO_ARGS_TYPES);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INITIALIZATION_FAILED, new Object[]{this.type.getName()}, e);
        }
    }

    @Override
    public int typeValue() {
        return this.typeValue;
    }

    @Override
    public ReferenceType defaultReferenceType() {
        return ReferenceType.IDENTITY;
    }

    @Override
    public boolean defaultStoreReference() {
        return false;
    }

    @Override
    public void write(T value, VirtualizationOutput out) throws IOException {
        if (!this.type.isInstance(value)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNEXPECTED_VALUE_TYPE, value, value.getClass().getName(), this.type.getName());
        }
        value.writeVirtualized(out);
    }

    @Override
    public T read(VirtualizationInput in) throws IOException {
        VirtualizationSerializable object;
        try {
            object = (VirtualizationSerializable)this.constructor.newInstance(NO_ARGS);
        }
        catch (Exception e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_CLASS_INSTANCE_ERROR, new Object[]{this.type.getName()}, e);
        }
        object.readVirtualized(in);
        return (T)object;
    }
}

