/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.virtualization;

import java.io.IOException;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.util.LocalVirtualizationSerializer;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class LocalVirtualizationOutput
extends VirtualizationOutput {
    private final LocalVirtualizationSerializer virtualizationSerializer;

    public LocalVirtualizationOutput(OutputStream out, LocalVirtualizationSerializer serializer, JRVirtualizationContext virtualizationContext) throws IOException {
        super(out, virtualizationContext);
        this.virtualizationSerializer = serializer;
    }

    @Override
    protected void annotateClass(Class<?> clazz) throws IOException {
        super.annotateClass(clazz);
        int loaderIdx = this.virtualizationSerializer.getClassloaderIdx(clazz);
        this.writeShort(loaderIdx);
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        Class<?> clazz = desc.forClass();
        if (clazz == null) {
            throw new RuntimeException();
        }
        int classIdx = this.virtualizationSerializer.getClassDescriptorIdx(clazz);
        this.writeIntCompressed(classIdx);
    }
}

