/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.engine.Deduplicable;
import net.sf.jasperreports.engine.JRPropertiesMap;

public class ObjectUtils {
    public static HashCode hash() {
        return new HashCode();
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static boolean equalsIdentity(Object o1, Object o2) {
        return o1 == o2;
    }

    public static boolean identical(Object o1, Object o2) {
        if (o1 instanceof Deduplicable && o2 instanceof Deduplicable) {
            return ((Deduplicable)o1).isIdentical(o2);
        }
        return ObjectUtils.equals(o1, o2);
    }

    public static boolean identical(Object[] v1, Object[] v2) {
        if (v1 == null || v1.length == 0) {
            return v2 == null || v2.length == 0;
        }
        if (v2 == null || v1.length != v2.length) {
            return false;
        }
        for (int idx = 0; idx < v1.length; ++idx) {
            if (ObjectUtils.identical(v1[idx], v2[idx])) continue;
            return false;
        }
        return true;
    }

    public static boolean identical(List<?> l1, List<?> l2) {
        if (l1 == null || l1.isEmpty()) {
            return l2 == null || l2.isEmpty();
        }
        if (l2 == null || l1.size() != l2.size()) {
            return false;
        }
        Iterator<?> i1 = l1.iterator();
        Iterator<?> i2 = l2.iterator();
        while (i1.hasNext()) {
            Object o2;
            Object o1 = i1.next();
            if (ObjectUtils.identical(o1, o2 = i2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public static <T extends Enum<T>> boolean equals(Enum<T> o1, Enum<T> o2) {
        return o1 == o2;
    }

    public static boolean equals(boolean b1, boolean b2) {
        return b1 == b2;
    }

    public static boolean equals(int i1, int i2) {
        return i1 == i2;
    }

    public static boolean equals(float f1, float f2) {
        return Float.floatToIntBits(f1) == Float.floatToIntBits(f2);
    }

    public static boolean equals(JRPropertiesMap p1, JRPropertiesMap p2) {
        String[] names2;
        if (p1 == null || !p1.hasProperties()) {
            return p2 == null || !p2.hasProperties();
        }
        if (p2 == null || !p2.hasProperties()) {
            return false;
        }
        String[] names1 = p1.getPropertyNames();
        if (names1.length != (names2 = p2.getPropertyNames()).length) {
            return false;
        }
        for (int i = 0; i < names1.length; ++i) {
            String value2;
            String name1 = names1[i];
            String name2 = names2[i];
            if (!ObjectUtils.equals(name1, name2)) {
                return false;
            }
            String value1 = p1.getProperty(name1);
            if (ObjectUtils.equals(value1, value2 = p2.getProperty(name1))) continue;
            return false;
        }
        return true;
    }

    public static class HashCode {
        private final int coefficient = 29;
        private int hash = 47;

        protected void addToHash(int value) {
            this.hash = 29 * this.hash + value;
        }

        public void add(int value) {
            this.addToHash(value);
        }

        public void add(boolean value) {
            this.addToHash(Boolean.valueOf(value).hashCode());
        }

        public void add(Object value) {
            this.addToHash(value == null ? 0 : value.hashCode());
        }

        public void addIdentical(Object value) {
            if (value instanceof Deduplicable) {
                this.addToHash(((Deduplicable)value).getHashCode());
            } else {
                this.add(value);
            }
        }

        public void addIdentity(Object value) {
            this.addToHash(System.identityHashCode(value));
        }

        public void addIdentical(Object[] values) {
            if (values == null || values.length == 0) {
                this.addToHash(0);
            } else {
                this.addToHash(values.length);
                for (Object object : values) {
                    this.addIdentical(object);
                }
            }
        }

        public void addIdentical(List<?> values) {
            if (values == null || values.isEmpty()) {
                this.addToHash(0);
            } else {
                this.addToHash(values.size());
                for (Object object : values) {
                    this.addIdentical(object);
                }
            }
        }

        public void add(JRPropertiesMap properties) {
            if (properties == null || !properties.hasProperties()) {
                this.addToHash(0);
            } else {
                String[] names;
                for (String prop : names = properties.getPropertyNames()) {
                    this.add(prop);
                    this.add(properties.getProperty(prop));
                }
            }
        }

        public int getHashCode() {
            return this.hash;
        }
    }
}

