/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;

public final class JRReportUtils {
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_SUBDATASET_NOT_FOUND = "util.report.subdataset.not.found";

    public static JRDataset findSubdataset(JRDatasetRun datasetRun, JRReport report) {
        return JRReportUtils.findSubdataset(datasetRun.getDatasetName(), report);
    }

    public static JRDataset findSubdataset(String datasetName, JRReport report) {
        JRDataset[] datasets = report.getDatasets();
        JRDataset reportDataset = null;
        if (datasets != null) {
            for (int i = 0; i < datasets.length; ++i) {
                if (!datasetName.equals(datasets[i].getName())) continue;
                reportDataset = datasets[i];
                break;
            }
        }
        if (reportDataset == null) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_REPORT_SUBDATASET_NOT_FOUND, datasetName, report.getName());
        }
        return reportDataset;
    }

    public static JRDataset findSubdataset(JRDatasetRun datasetRun, JasperReport report) {
        return JRReportUtils.findSubdataset(datasetRun, (JRReport)report);
    }

    private JRReportUtils() {
    }
}

