/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.util.MD5Digest;

public final class DigestUtils {
    public static final String EXCEPTION_MESSAGE_KEY_MD5_NOT_AVAILABLE = "util.digest.md5.not.available";
    private static final DigestUtils INSTANCE = new DigestUtils();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static DigestUtils instance() {
        return INSTANCE;
    }

    private DigestUtils() {
    }

    public MD5Digest md5(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] digestBytes = digest.digest(text.getBytes(StandardCharsets.UTF_8));
            long low = (long)(digestBytes[0] & 0xFF) << 56 | (long)(digestBytes[1] & 0xFF) << 48 | (long)(digestBytes[2] & 0xFF) << 40 | (long)(digestBytes[3] & 0xFF) << 32 | (long)(digestBytes[4] & 0xFF) << 24 | (long)(digestBytes[5] & 0xFF) << 16 | (long)(digestBytes[6] & 0xFF) << 8 | (long)(digestBytes[7] & 0xFF) << 0;
            long high = (long)(digestBytes[8] & 0xFF) << 56 | (long)(digestBytes[9] & 0xFF) << 48 | (long)(digestBytes[10] & 0xFF) << 40 | (long)(digestBytes[11] & 0xFF) << 32 | (long)(digestBytes[12] & 0xFF) << 24 | (long)(digestBytes[13] & 0xFF) << 16 | (long)(digestBytes[14] & 0xFF) << 8 | (long)(digestBytes[15] & 0xFF) << 0;
            return new MD5Digest(low, high);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MD5_NOT_AVAILABLE, null, e);
        }
    }

    public String sha256(String text) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] digestBytes = digest.digest(text.getBytes(StandardCharsets.UTF_8));
            char[] digestChars = new char[digestBytes.length * 2];
            for (int i = 0; i < digestBytes.length; ++i) {
                digestChars[2 * i] = HEX_CHARS[(digestBytes[i] & 0xF0) >>> 4];
                digestChars[2 * i + 1] = HEX_CHARS[digestBytes[i] & 0xF];
            }
            return new String(digestChars);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MD5_NOT_AVAILABLE, null, e);
        }
    }

    public UUID deriveUUID(UUID base, String text) {
        MD5Digest textMD5 = this.md5(text);
        long md5Low = textMD5.getLow();
        long md5High = textMD5.getHigh();
        return this.deriveUUID(base, md5Low, md5High);
    }

    public UUID deriveUUID(UUID base, long maskLow, long maskHigh) {
        long baseMostSig = base.getMostSignificantBits();
        long baseLeastSig = base.getLeastSignificantBits();
        return new UUID(baseMostSig ^ maskLow & 0xFFFFFFFFFFFF0FFFL, baseLeastSig ^ maskHigh & 0x3FFFFFFFFFFFFFFFL);
    }
}

