/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRCommonText;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.fill.JRMeasuredText;
import net.sf.jasperreports.engine.fill.JRTextMeasurer;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.SimpleMeasuredText;
import net.sf.jasperreports.engine.util.TextUtils;

public class NaiveTextMeasurer
implements JRTextMeasurer {
    private final JRCommonText text;

    public NaiveTextMeasurer(JRCommonText text) {
        this.text = text;
    }

    @Override
    public JRMeasuredText measure(JRStyledText styledText, int remainingTextStart, int availableStretchHeight, boolean indentFirstLine, boolean canOverflow) {
        int textHeight;
        int textWidth;
        SimpleMeasuredText simpleMeasuredText = new SimpleMeasuredText();
        simpleMeasuredText.setTextOffset(styledText.length());
        JRLineBox box = this.text.getLineBox();
        switch (this.text.getRotationValue()) {
            case LEFT: 
            case RIGHT: {
                textWidth = this.text.getHeight() - box.getTopPadding() - box.getBottomPadding();
                textHeight = this.text.getWidth() - box.getLeftPadding() - box.getRightPadding();
                break;
            }
            default: {
                textWidth = this.text.getWidth() - box.getLeftPadding() - box.getRightPadding();
                textHeight = this.text.getHeight() - box.getTopPadding() - box.getBottomPadding();
            }
        }
        simpleMeasuredText.setTextWidth(textWidth);
        simpleMeasuredText.setTextHeight(textHeight);
        boolean leftToRight = TextUtils.isLeftToRight(styledText.getText().toCharArray());
        simpleMeasuredText.setLeftToRight(leftToRight);
        return simpleMeasuredText;
    }
}

