/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRAbstractExtendedIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRExtendedIncrementer;
import net.sf.jasperreports.engine.fill.JRLongAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRLongCountIncrementer;
import net.sf.jasperreports.engine.fill.JRLongDistinctCountIncrementer;
import net.sf.jasperreports.engine.fill.JRLongStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRLongSumIncrementer;
import net.sf.jasperreports.engine.fill.JRLongVarianceIncrementer;
import net.sf.jasperreports.engine.type.CalculationEnum;

public final class JRLongIncrementerFactory
extends JRAbstractExtendedIncrementerFactory {
    protected static final Long ZERO = 0L;
    private static JRLongIncrementerFactory mainInstance = new JRLongIncrementerFactory();

    private JRLongIncrementerFactory() {
    }

    public static JRLongIncrementerFactory getInstance() {
        return mainInstance;
    }

    @Override
    public JRExtendedIncrementer getExtendedIncrementer(CalculationEnum calculation) {
        JRExtendedIncrementer incrementer = null;
        switch (calculation) {
            case COUNT: {
                incrementer = JRLongCountIncrementer.getInstance();
                break;
            }
            case SUM: {
                incrementer = JRLongSumIncrementer.getInstance();
                break;
            }
            case AVERAGE: {
                incrementer = JRLongAverageIncrementer.getInstance();
                break;
            }
            case LOWEST: 
            case HIGHEST: {
                incrementer = JRComparableIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
                break;
            }
            case STANDARD_DEVIATION: {
                incrementer = JRLongStandardDeviationIncrementer.getInstance();
                break;
            }
            case VARIANCE: {
                incrementer = JRLongVarianceIncrementer.getInstance();
                break;
            }
            case DISTINCT_COUNT: {
                incrementer = JRLongDistinctCountIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getExtendedIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

