/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.ooxml.BaseFontHelper;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class PptxRunHelper
extends BaseHelper {
    private final BaseFontHelper pptxFontHelper;

    public PptxRunHelper(JasperReportsContext jasperReportsContext, Writer writer, BaseFontHelper pptxFontHelper) {
        super(jasperReportsContext, writer);
        this.pptxFontHelper = pptxFontHelper;
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, String invalidCharReplacement) {
        if (text != null) {
            StringTokenizer tkzer = new StringTokenizer(text, "\n", true);
            while (tkzer.hasMoreTokens()) {
                String token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    this.write("<a:br/>");
                    continue;
                }
                this.write("      <a:r>\n");
                this.exportProps("a:rPr", this.getAttributes(style), attributes, locale);
                this.write("<a:t>");
                this.write(JRStringUtil.xmlEncode(token, invalidCharReplacement));
                this.write("</a:t>\n");
                this.write("      </a:r>\n");
            }
        }
    }

    public void export(JRStyle style, Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale, String invalidCharReplacement, String fieldType, String uuid) {
        if (text != null) {
            StringTokenizer tkzer = new StringTokenizer(text, "\n", true);
            while (tkzer.hasMoreTokens()) {
                String token = tkzer.nextToken();
                if ("\n".equals(token)) {
                    this.write("<a:br/>");
                    continue;
                }
                this.write("      <a:fld id=\"{" + uuid + "}\" type=\"" + fieldType + "\">\n");
                this.exportProps("a:rPr", this.getAttributes(style), attributes, locale);
                this.write("<a:t>#</a:t>\n");
                this.write("      </a:fld>\n");
            }
        }
    }

    public void exportProps(JRPrintText text, Locale locale) {
        HashMap<AttributedCharacterIterator.Attribute, Object> textAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(textAttributes, text);
        textAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == null || text.getModeValue() == ModeEnum.OPAQUE) {
            textAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        this.exportProps("a:defRPr", new HashMap<AttributedCharacterIterator.Attribute, Object>(), textAttributes, locale);
    }

    private void exportProps(String tag, Map<AttributedCharacterIterator.Attribute, Object> parentAttrs, Map<AttributedCharacterIterator.Attribute, Object> attrs, Locale locale) {
        float fontSize;
        this.write("       <" + tag + "\n");
        if (locale != null && "a:rPr".equals(tag)) {
            this.write(" lang=\"" + locale.getLanguage() + "\"\n");
        }
        Object value = attrs.get(TextAttribute.SIZE);
        Object oldValue = parentAttrs.get(TextAttribute.SIZE);
        if (value != null && !value.equals(oldValue)) {
            fontSize = ((Float)value).floatValue();
            fontSize = fontSize == 0.0f ? 0.5f : fontSize;
            this.write(" sz=\"" + (int)(100.0f * fontSize) + "\"");
        } else {
            fontSize = ((Float)oldValue).floatValue();
            this.write(" sz=\"" + (int)(100.0f * fontSize) + "\"");
        }
        Object valueWeight = attrs.get(TextAttribute.WEIGHT);
        Object oldValueWeight = parentAttrs.get(TextAttribute.WEIGHT);
        if (valueWeight != null && !valueWeight.equals(oldValueWeight)) {
            this.write(" b=\"" + (valueWeight.equals(TextAttribute.WEIGHT_BOLD) ? 1 : 0) + "\"");
        }
        Object valuePosture = attrs.get(TextAttribute.POSTURE);
        Object oldValuePosture = parentAttrs.get(TextAttribute.POSTURE);
        if (valuePosture != null && !valuePosture.equals(oldValuePosture)) {
            this.write(" i=\"" + (valuePosture.equals(TextAttribute.POSTURE_OBLIQUE) ? 1 : 0) + "\"");
        }
        value = attrs.get(TextAttribute.UNDERLINE);
        oldValue = parentAttrs.get(TextAttribute.UNDERLINE);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write(" u=\"" + (value == null ? "none" : "sng") + "\"");
        }
        value = attrs.get(TextAttribute.STRIKETHROUGH);
        oldValue = parentAttrs.get(TextAttribute.STRIKETHROUGH);
        if (value == null && oldValue != null || value != null && !value.equals(oldValue)) {
            this.write(" strike=\"" + (value == null ? "noStrike" : "sngStrike") + "\"");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(value = attrs.get(TextAttribute.SUPERSCRIPT))) {
            this.write(" baseline=\"30000\"");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(value)) {
            this.write(" baseline=\"-25000\"");
        }
        this.write(">\n");
        value = attrs.get(TextAttribute.FOREGROUND);
        oldValue = parentAttrs.get(TextAttribute.FOREGROUND);
        if (value != null && !value.equals(oldValue)) {
            this.write("<a:solidFill><a:srgbClr val=\"" + JRColorUtil.getColorHexa((Color)value) + "\"/></a:solidFill>\n");
        }
        value = attrs.get(TextAttribute.BACKGROUND);
        oldValue = parentAttrs.get(TextAttribute.BACKGROUND);
        String fontName = this.pptxFontHelper.resolveFontFamily(attrs, locale);
        this.write("        <a:latin typeface=\"" + fontName + "\"/>\n");
        this.write("        <a:ea typeface=\"" + fontName + "\"/>\n");
        this.write("        <a:cs typeface=\"" + fontName + "\"/>\n");
        this.write("</" + tag + ">\n");
    }

    private Map<AttributedCharacterIterator.Attribute, Object> getAttributes(JRStyle style) {
        JRBasePrintText text = new JRBasePrintText(null);
        text.setStyle(style);
        HashMap<AttributedCharacterIterator.Attribute, Object> styledTextAttributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(styledTextAttributes, text);
        styledTextAttributes.put(TextAttribute.FOREGROUND, text.getForecolor());
        if (text.getModeValue() == ModeEnum.OPAQUE) {
            styledTextAttributes.put(TextAttribute.BACKGROUND, text.getBackcolor());
        }
        return styledTextAttributes;
    }
}

