/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.base.JRBaseGenericPrintElement;
import net.sf.jasperreports.engine.export.FlashHtmlHandler;
import net.sf.jasperreports.engine.export.GenericElementHandler;
import net.sf.jasperreports.engine.export.GenericElementHandlerBundle;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;

public final class FlashPrintElement {
    public static final String FLASH_ELEMENT_NAME = "flash";
    public static final JRGenericElementType FLASH_ELEMENT_TYPE = new JRGenericElementType("http://jasperreports.sourceforge.net/jasperreports", "flash");
    public static final String PARAMETER_SWF_URL = "SWF_URL";
    public static final String PARAMETER_FLASH_VAR_PREFIX = "FLASH_VAR_";
    @Deprecated
    public static final String PROPERTY_IGNORE_SIZE = "net.sf.jasperreports.export.swf.ignore.size";
    public static final String PROPERTY_ALLOW_SCRIPT_ACCESS = "net.sf.jasperreports.export.flash.element.allow.script.access";
    private static final GenericElementHandlerBundle HANDLER_BUNDLE = new GenericElementHandlerBundle(){

        @Override
        public String getNamespace() {
            return "http://jasperreports.sourceforge.net/jasperreports";
        }

        @Override
        public GenericElementHandler getHandler(String elementName, String exporterKey) {
            if (FlashPrintElement.FLASH_ELEMENT_NAME.equals(elementName) && "net.sf.jasperreports.html".equals(exporterKey)) {
                return FlashHtmlHandler.getInstance();
            }
            return null;
        }
    };
    protected static final Pattern LINK_PATTERN = HyperlinkUtil.LINK_PATTERN;
    protected static final int LINK_PARAM_NAME_GROUP = 1;

    public static GenericElementHandlerBundle getHandlerBundle() {
        return HANDLER_BUNDLE;
    }

    public static JRGenericPrintElement makeFlashElement(JRPrintElement template, String swfUrl, Map<String, Object> flashVars, Map<String, Object> elementParameters) {
        Object value;
        String name;
        JRBaseGenericPrintElement flashEl = new JRBaseGenericPrintElement(template.getDefaultStyleProvider());
        flashEl.setUUID(template.getUUID());
        flashEl.setX(template.getX());
        flashEl.setY(template.getY());
        flashEl.setWidth(template.getWidth());
        flashEl.setHeight(template.getHeight());
        flashEl.setStyle(template.getStyle());
        flashEl.setMode(template.getOwnModeValue());
        flashEl.setBackcolor(template.getOwnBackcolor());
        flashEl.setForecolor(template.getOwnForecolor());
        flashEl.setOrigin(template.getOrigin());
        flashEl.setKey(template.getKey());
        flashEl.setGenericType(FLASH_ELEMENT_TYPE);
        flashEl.setParameterValue(PARAMETER_SWF_URL, swfUrl);
        for (Map.Entry<String, Object> entry : flashVars.entrySet()) {
            name = entry.getKey();
            value = entry.getValue();
            String paramName = PARAMETER_FLASH_VAR_PREFIX + name;
            flashEl.setParameterValue(paramName, value);
        }
        if (elementParameters != null && !elementParameters.isEmpty()) {
            for (Map.Entry<String, Object> entry : elementParameters.entrySet()) {
                name = entry.getKey();
                value = entry.getValue();
                flashEl.setParameterValue(name, value);
            }
        }
        return flashEl;
    }

    public static String makeLinkParameterName(JRPrintHyperlink hyperlink) {
        return HyperlinkUtil.makeLinkParameterName(hyperlink);
    }

    public static String makeLinkPlaceholder(JRPrintHyperlink hyperlink) {
        return HyperlinkUtil.makeLinkPlaceholder(hyperlink);
    }

    public static String makeLinkPlaceholder(String linkId) {
        return HyperlinkUtil.makeLinkPlaceholder(linkId);
    }

    public static String resolveLinks(String text, JRGenericPrintElement element, JRHyperlinkProducer linkProducer, boolean prepareForSerialization) {
        return HyperlinkUtil.resolveLinks(text, element, linkProducer, prepareForSerialization);
    }

    private FlashPrintElement() {
    }
}

