/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.RunLengthIterator;

public class RunLengthColumnValues
implements ColumnValues,
Serializable {
    private static final long serialVersionUID = 10200L;
    private int size;
    private ColumnValues values;
    private ColumnValues runLengths;

    public RunLengthColumnValues(int size, ColumnValues values, ColumnValues runLengths) {
        if (values.size() != runLengths.size()) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.values = values;
        this.runLengths = runLengths;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.size);
        out.writeUnshared(this.values);
        out.writeUnshared(this.runLengths);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.values = (ColumnValues)in.readUnshared();
        this.runLengths = (ColumnValues)in.readUnshared();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ColumnValuesIterator iterator() {
        ColumnValuesIterator valuesIterator = this.values.iterator();
        ColumnValuesIterator lengthsIterator = this.runLengths.iterator();
        return new RunLengthIterator(valuesIterator, lengthsIterator);
    }
}

