/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.jasperreports.data.cache.ColumnValues;
import net.sf.jasperreports.data.cache.ColumnValuesIterator;
import net.sf.jasperreports.data.cache.DataSnapshotException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.IndexedDataSource;

public class ColumnValuesDataSource
implements JRRewindableDataSource,
IndexedDataSource {
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_SNAPSHOT_FIELD_TYPE = "data.cache.invalid.snapshot.field.type";
    public static final String EXCEPTION_MESSAGE_KEY_NO_SUCH_SNAPSHOT_FIELD = "data.cache.no.such.snapshot.field";
    private int size;
    private int iteratorIndex;
    private Map<String, ColumnValuesIterator> iterators;

    public ColumnValuesDataSource(String[] fieldNames, int size, ColumnValues[] values) {
        if (fieldNames == null || values == null || fieldNames.length != values.length) {
            throw new IllegalArgumentException();
        }
        this.iterators = new LinkedHashMap<String, ColumnValuesIterator>();
        this.size = size;
        for (int i = 0; i < fieldNames.length; ++i) {
            if (size != values[i].size()) {
                throw new IllegalArgumentException();
            }
            this.iterators.put(fieldNames[i], values[i].iterator());
        }
        this.iteratorIndex = 0;
    }

    @Override
    public boolean next() throws JRException {
        if (this.iteratorIndex >= this.size) {
            return false;
        }
        ++this.iteratorIndex;
        for (ColumnValuesIterator iterator : this.iterators.values()) {
            iterator.next();
        }
        return true;
    }

    @Override
    public Object getFieldValue(JRField field) throws DataSnapshotException {
        ColumnValuesIterator iterator = this.iterators.get(field.getName());
        if (iterator == null) {
            throw new DataSnapshotException(EXCEPTION_MESSAGE_KEY_NO_SUCH_SNAPSHOT_FIELD, new Object[]{field.getName()});
        }
        Object value = iterator.get();
        if (value != null && !field.getValueClass().isInstance(value)) {
            throw new DataSnapshotException(EXCEPTION_MESSAGE_KEY_INVALID_SNAPSHOT_FIELD_TYPE, new Object[]{field.getName(), field.getValueClassName(), value.getClass().getName()});
        }
        return value;
    }

    @Override
    public void moveFirst() {
        this.iteratorIndex = 0;
        for (ColumnValuesIterator iterator : this.iterators.values()) {
            iterator.moveFirst();
        }
    }

    @Override
    public int getRecordIndex() {
        return this.iteratorIndex - 1;
    }
}

