/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.table.fill;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.components.subreport.fill.SubreportFillComponent;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Column;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.ColumnVisitor;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.fill.DatasetCloneObjectFactory;
import net.sf.jasperreports.components.table.fill.FillColumn;
import net.sf.jasperreports.components.table.fill.TableJasperReport;
import net.sf.jasperreports.components.table.fill.TableReport;
import net.sf.jasperreports.components.table.fill.TableReportBaseObjectFactory;
import net.sf.jasperreports.components.table.fill.TableReportCompileData;
import net.sf.jasperreports.components.table.fill.TableReportDataset;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRReportCompileData;
import net.sf.jasperreports.engine.fill.BuiltinExpressionEvaluatorFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.util.JRReportUtils;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.export.type.AccessibilityTagEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FillTable
extends SubreportFillComponent {
    private static final Log log = LogFactory.getLog(FillTable.class);
    protected static final String FILL_CACHE_KEY_TABLE_INSTANCE_COUNTER = FillTable.class.getName() + "#instanceCounter";
    protected static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_REPORT_DATA_TYPE = "components.table.unsupported.report.data.type";
    private final TableComponent table;
    private Map<List<FillColumn>, SubreportFillComponent.ComponentFillSubreportFactory> fillSubreportFactories;
    private boolean filling;
    private List<FillColumn> fillColumns;

    public FillTable(TableComponent table, JRFillObjectFactory factory) {
        super(table, factory);
        this.table = table;
        this.fillSubreportFactories = new HashMap<List<FillColumn>, SubreportFillComponent.ComponentFillSubreportFactory>();
    }

    public FillTable(FillTable table, JRFillCloneFactory factory) {
        super(table, factory);
        this.table = table.table;
        this.fillSubreportFactories = table.fillSubreportFactories;
    }

    private TableReport getBaseReport() {
        return ((TableJasperReport)this.fillSubreport.getJasperReport()).getBaseReport();
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        if (this.filling) {
            log.warn((Object)"Table fill did not complete, canceling previous table subreport");
            this.fillSubreport.cancelSubreportFill();
        }
        this.filling = false;
        this.evaluateColumns(evaluation);
        if (!this.fillColumns.isEmpty()) {
            this.createFillSubreport();
            this.setTableInstanceCounter();
            this.fillSubreport.evaluateSubreport(evaluation);
        }
    }

    protected void setTableInstanceCounter() {
        JRFillContext fillerContext = this.fillContext.getFiller().getFillContext();
        AtomicInteger counter = (AtomicInteger)fillerContext.getFillCache(FILL_CACHE_KEY_TABLE_INSTANCE_COUNTER);
        if (counter == null) {
            counter = new AtomicInteger();
            fillerContext.setFillCache(FILL_CACHE_KEY_TABLE_INSTANCE_COUNTER, counter);
        }
        int instanceIndex = counter.getAndIncrement();
        if (log.isDebugEnabled()) {
            log.debug((Object)("table instance index is " + instanceIndex));
        }
        this.getBaseReport().setTableInstanceIndex(instanceIndex);
    }

    protected boolean toPrintColumn(BaseColumn column, byte evaluation) throws JRException {
        Boolean printWhenVal;
        JRExpression printWhenExpression = column.getPrintWhenExpression();
        boolean toPrint = printWhenExpression == null ? true : ((printWhenVal = (Boolean)this.evaluateExpression(printWhenExpression, evaluation)) == null ? false : printWhenVal);
        return toPrint;
    }

    protected JRPropertiesMap evaluateProperties(BaseColumn column, byte evaluation) throws JRException {
        JRPropertiesMap staticProperties = column.hasProperties() ? column.getPropertiesMap().cloneProperties() : null;
        JRPropertiesMap mergedProperties = null;
        JRPropertyExpression[] propExprs = column.getPropertyExpressions();
        if (propExprs == null || propExprs.length == 0) {
            mergedProperties = staticProperties;
        } else {
            JRPropertiesMap dynamicProperties = new JRPropertiesMap();
            for (int i = 0; i < propExprs.length; ++i) {
                JRPropertyExpression prop = propExprs[i];
                String value = (String)this.evaluateExpression(prop.getValueExpression(), evaluation);
                dynamicProperties.setProperty(prop.getName(), value);
            }
            mergedProperties = dynamicProperties.cloneProperties();
            mergedProperties.setBaseProperties(staticProperties);
        }
        return mergedProperties;
    }

    protected void evaluateColumns(byte evaluation) {
        FillColumnEvaluator columnEvaluator = new FillColumnEvaluator(evaluation);
        List<BaseColumn> columns = this.table.getColumns();
        this.fillColumns = new ArrayList<FillColumn>(columns.size());
        this.fillWidth = 0;
        for (BaseColumn column : columns) {
            FillColumn fillColumn = column.visitColumn(columnEvaluator);
            if (fillColumn == null) continue;
            this.fillColumns.add(fillColumn);
            this.fillWidth += fillColumn.getWidth();
        }
    }

    @Override
    public SubreportFillComponent.ComponentFillSubreportFactory getFillSubreportFactory() {
        return this.fillSubreportFactories.get(this.fillColumns);
    }

    @Override
    public void setFillSubreportFactory(SubreportFillComponent.ComponentFillSubreportFactory subreportFactory) {
        this.fillSubreportFactories.put(this.fillColumns, subreportFactory);
    }

    @Override
    public boolean isEmpty() {
        return this.fillColumns.isEmpty();
    }

    @Override
    public JasperReport getJasperReport(BuiltinExpressionEvaluatorFactory builtinEvaluatorFactory) throws JRException {
        JasperReport parentReport = this.fillContext.getFiller().getJasperReport();
        JasperReport containingReport = this.containingReport(parentReport);
        JRDataset reportSubdataset = JRReportUtils.findSubdataset(this.table.getDatasetRun(), (JRReport)containingReport);
        String tableReportName = JRAbstractCompiler.getUnitName(containingReport, reportSubdataset);
        JRDataset tableSubdataset = DatasetCloneObjectFactory.cloneDataset(reportSubdataset);
        TableReportDataset reportDataset = new TableReportDataset(tableSubdataset, tableReportName);
        TableReport tableReport = new TableReport(this.fillContext, this.table, reportDataset, this.fillColumns, builtinEvaluatorFactory);
        if (log.isDebugEnabled()) {
            String tableReportXml = new JRXmlWriter(this.fillContext.getFiller().getJasperReportsContext()).write(tableReport, "UTF-8");
            log.debug((Object)("Generated table report:\n" + tableReportXml));
        }
        JRReportCompileData tableReportCompileData = this.createTableReportCompileData(containingReport, reportSubdataset);
        return new TableJasperReport(parentReport, tableReport, (Serializable)tableReportCompileData, (JRBaseObjectFactory)new TableReportBaseObjectFactory(reportDataset), "");
    }

    protected JasperReport containingReport(JasperReport parentReport) {
        JasperReport containingReport = parentReport;
        while (containingReport instanceof TableJasperReport) {
            containingReport = ((TableJasperReport)containingReport).getParentReport();
        }
        return containingReport;
    }

    protected JRReportCompileData createTableReportCompileData(JasperReport parentReport, JRDataset reportSubdataset) throws JRException {
        Serializable reportCompileDataObj = parentReport.getCompileData();
        if (!(reportCompileDataObj instanceof JRReportCompileData)) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_REPORT_DATA_TYPE, reportCompileDataObj.getClass().getName());
        }
        JRReportCompileData reportCompileData = (JRReportCompileData)reportCompileDataObj;
        Serializable datasetCompileData = reportCompileData.getDatasetCompileData(reportSubdataset);
        TableReportCompileData tableReportCompileData = new TableReportCompileData(parentReport);
        tableReportCompileData.setMainDatasetCompileData(datasetCompileData);
        JRDataset[] datasets = parentReport.getDatasets();
        if (datasets != null) {
            for (JRDataset dataset : datasets) {
                Serializable compileData = reportCompileData.getDatasetCompileData(dataset);
                tableReportCompileData.setDatasetCompileData(dataset, compileData);
            }
        }
        tableReportCompileData.copyCrosstabCompileData(reportCompileData);
        return tableReportCompileData;
    }

    @Override
    public JRPrintElement fill() {
        JRPrintElement printFrame = super.fill();
        if (this.getBaseReport().isInteractiveTable()) {
            printFrame.getPropertiesMap().setProperty("net.sf.jasperreports.export.headertoolbar.tableUUID", this.fillContext.getComponentElement().getUUID().toString());
        }
        if (this.getBaseReport().isAccessibleTable()) {
            printFrame.getPropertiesMap().setProperty("net.sf.jasperreports.export.pdf.tag.table", "full");
            printFrame.getPropertiesMap().setProperty("net.sf.jasperreports.export.accessibility.tag", AccessibilityTagEnum.TABLE.getName());
        }
        this.fillContext.getFiller().getPropertiesUtil().transferProperties(this.fillContext.getComponentElement(), (JRPropertiesHolder)printFrame, "net.sf.jasperreports.print.transfer.");
        return printFrame;
    }

    protected class FillColumnEvaluator
    implements ColumnVisitor<FillColumn> {
        final byte evaluation;

        public FillColumnEvaluator(byte evaluation) {
            this.evaluation = evaluation;
        }

        @Override
        public FillColumn visitColumn(Column column) {
            try {
                boolean toPrint = FillTable.this.toPrintColumn(column, this.evaluation);
                if (toPrint) {
                    JRPropertiesMap properties = FillTable.this.evaluateProperties(column, this.evaluation);
                    return new FillColumn(column, properties);
                }
                return null;
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }

        @Override
        public FillColumn visitColumnGroup(ColumnGroup columnGroup) {
            try {
                FillColumn fillColumn;
                boolean toPrint = FillTable.this.toPrintColumn(columnGroup, this.evaluation);
                if (toPrint) {
                    List<BaseColumn> columns = columnGroup.getColumns();
                    ArrayList<FillColumn> subColumns = new ArrayList<FillColumn>(columns.size());
                    int printWidth = 0;
                    for (BaseColumn column : columns) {
                        FillColumn fillSubColumn = column.visitColumn(this);
                        if (fillSubColumn == null) continue;
                        printWidth += fillSubColumn.getWidth();
                        subColumns.add(fillSubColumn);
                    }
                    if (subColumns.isEmpty()) {
                        fillColumn = null;
                    } else {
                        JRPropertiesMap properties = FillTable.this.evaluateProperties(columnGroup, this.evaluation);
                        fillColumn = new FillColumn(columnGroup, printWidth, subColumns, properties);
                    }
                } else {
                    fillColumn = null;
                }
                return fillColumn;
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
    }
}

