/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class StandardItem
implements Item,
JRChangeEventsSupport,
Serializable {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ITEM_PROPERTIES = "itemProperties";
    private transient JRPropertyChangeSupport eventSupport;
    private List<ItemProperty> properties = new ArrayList<ItemProperty>();

    public StandardItem() {
    }

    public StandardItem(List<ItemProperty> properties) {
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        StandardItem standardItem = this;
        synchronized (standardItem) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    @Override
    public Object clone() {
        StandardItem clone = null;
        try {
            clone = (StandardItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.properties = JRCloneUtils.cloneList(this.properties);
        return clone;
    }

    @Override
    public List<ItemProperty> getProperties() {
        return this.properties;
    }

    public void addItemProperty(ItemProperty property) {
        this.properties.add(property);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_ITEM_PROPERTIES, property, this.properties.size() - 1);
    }

    public void removeItemProperty(ItemProperty property) {
        int idx = this.properties.indexOf(property);
        if (idx >= 0) {
            this.properties.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_ITEM_PROPERTIES, property, idx);
        }
    }
}

