/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import net.sf.jasperreports.components.list.BaseFillList;
import net.sf.jasperreports.components.list.FillListContents;
import net.sf.jasperreports.components.list.ListComponent;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VerticalFillList
extends BaseFillList {
    private static final Log log = LogFactory.getLog(VerticalFillList.class);
    private final FillListContents listContents;

    public VerticalFillList(ListComponent component, JRFillObjectFactory factory) throws JRException {
        super(component, factory);
        JRFillObjectFactory datasetFactory = new JRFillObjectFactory(factory, this.createDatasetExpressionEvaluator());
        this.listContents = new FillListContents(component.getContents(), datasetFactory);
    }

    protected VerticalFillList(VerticalFillList list, JRFillCloneFactory factory) {
        super(list, factory);
        this.listContents = new FillListContents(list.listContents, factory);
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        this.createPrintFrame();
        try {
            boolean hadData = false;
            boolean overflow = false;
            if (this.filling) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Continuing list after overflow");
                }
                hadData = true;
                overflow = this.fillContents(availableHeight);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Starting list rendering");
                }
                if (this.fillStarted) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"List reprinted, rewinding data source");
                    }
                    this.datasetRun.rewind();
                }
                this.datasetRun.start();
                this.fillStarted = true;
            }
            while (!overflow && this.datasetRun.next()) {
                hadData = true;
                this.listContents.evaluateContents();
                overflow = this.fillContents(availableHeight);
            }
            if (overflow) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"List has overflowed");
                }
                this.filling = true;
                return FillPrepareResult.printStretch(availableHeight, overflow);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"List has completed rendering");
            }
            this.filling = false;
            this.datasetRun.end();
            this.datasetRun.copyReturnValues();
            if (!hadData) {
                return FillPrepareResult.NO_PRINT_NO_OVERFLOW;
            }
            return FillPrepareResult.printStretch(this.printFrame.getHeight(), false);
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected boolean fillContents(int availableHeight) throws JRException {
        boolean overflow;
        int contentsAvailableHeight = availableHeight - this.printFrame.getHeight();
        if (contentsAvailableHeight < this.listContents.getHeight()) {
            overflow = true;
        } else {
            this.listContents.prepare(contentsAvailableHeight);
            this.listContents.finalizeElementPositions();
            this.listContents.fillElements(new BaseFillList.AppendingPrintElementContainer(this.printFrame));
            overflow = this.listContents.willOverflow();
        }
        return overflow;
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new VerticalFillList(this, factory);
    }

    @Override
    public void rewind() {
        if (this.fillStarted) {
            try {
                this.listContents.rewind();
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
        }
        super.rewind();
    }
}

