/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.htmlcleaner.BaseToken;
import org.htmlcleaner.ChildBreaks;
import org.htmlcleaner.CleanTimeValues;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.CleanerTransformations;
import org.htmlcleaner.CommentNode;
import org.htmlcleaner.ContentNode;
import org.htmlcleaner.EndTagToken;
import org.htmlcleaner.Html4TagProvider;
import org.htmlcleaner.Html5TagProvider;
import org.htmlcleaner.HtmlCleanerException;
import org.htmlcleaner.HtmlTokenizer;
import org.htmlcleaner.ITagInfoProvider;
import org.htmlcleaner.NestingState;
import org.htmlcleaner.OpenTags;
import org.htmlcleaner.ProxyTagNode;
import org.htmlcleaner.SimpleXmlSerializer;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.TagPos;
import org.htmlcleaner.Utils;
import org.htmlcleaner.audit.ErrorType;
import org.htmlcleaner.conditional.ITagNodeCondition;

public class HtmlCleaner {
    private static final String MARKER_ATTRIBUTE = "htmlcleaner_marker";
    public static int HTML_4 = 4;
    public static int HTML_5 = 5;
    private CleanerProperties properties;
    private CleanerTransformations transformations;

    public HtmlCleaner() {
        this(null, null);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider) {
        this(tagInfoProvider, null);
    }

    public HtmlCleaner(CleanerProperties properties) {
        this(null, properties);
    }

    public HtmlCleaner(ITagInfoProvider tagInfoProvider, CleanerProperties properties) {
        CleanerProperties cleanerProperties = this.properties = properties == null ? new CleanerProperties() : properties;
        if (tagInfoProvider == null && this.properties.getTagInfoProvider() == null) {
            if (this.properties.getHtmlVersion() == HTML_4) {
                this.properties.setTagInfoProvider(Html4TagProvider.INSTANCE);
            } else {
                this.properties.setTagInfoProvider(Html5TagProvider.INSTANCE);
            }
        } else if (tagInfoProvider != null) {
            this.properties.setTagInfoProvider(tagInfoProvider == null ? Html4TagProvider.INSTANCE : tagInfoProvider);
        }
    }

    public TagNode clean(String htmlContent) {
        try {
            return this.clean(new StringReader(htmlContent), new CleanTimeValues());
        }
        catch (IOException e) {
            throw new HtmlCleanerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TagNode clean(File file, String charset) throws IOException {
        FileInputStream in = new FileInputStream(file);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)in, charset);
            TagNode tagNode = this.clean(reader, new CleanTimeValues());
            return tagNode;
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    public TagNode clean(File file) throws IOException {
        return this.clean(file, this.properties.getCharset());
    }

    @Deprecated
    public TagNode clean(URL url, String charset) throws IOException {
        CharSequence content = Utils.readUrl(url, charset);
        StringReader reader = new StringReader(content.toString());
        return this.clean(reader, new CleanTimeValues());
    }

    @Deprecated
    public TagNode clean(URL url) throws IOException {
        return this.clean(url, this.properties.getCharset());
    }

    public TagNode clean(InputStream in, String charset) throws IOException {
        return this.clean(new InputStreamReader(in, charset), new CleanTimeValues());
    }

    public TagNode clean(InputStream in) throws IOException {
        return this.clean(in, this.properties.getCharset());
    }

    public TagNode clean(Reader reader) throws IOException {
        return this.clean(reader, new CleanTimeValues());
    }

    protected TagNode clean(Reader reader, CleanTimeValues cleanTimeValues) throws IOException {
        this.pushNesting(cleanTimeValues);
        cleanTimeValues._headOpened = false;
        cleanTimeValues._bodyOpened = false;
        cleanTimeValues._headTags.clear();
        cleanTimeValues.allTags.clear();
        cleanTimeValues.pruneTagSet = new HashSet<ITagNodeCondition>(this.properties.getPruneTagSet());
        cleanTimeValues.allowTagSet = new HashSet<ITagNodeCondition>(this.properties.getAllowTagSet());
        this.transformations = this.properties.getCleanerTransformations();
        cleanTimeValues.pruneNodeSet.clear();
        cleanTimeValues.htmlNode = this.newTagNode("html");
        cleanTimeValues.bodyNode = this.newTagNode("body");
        cleanTimeValues.headNode = this.newTagNode("head");
        cleanTimeValues.rootNode = null;
        cleanTimeValues.htmlNode.addChild(cleanTimeValues.headNode);
        cleanTimeValues.htmlNode.addChild(cleanTimeValues.bodyNode);
        HtmlTokenizer htmlTokenizer = new HtmlTokenizer(this, reader, cleanTimeValues);
        htmlTokenizer.start();
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        List<BaseToken> nodeList = htmlTokenizer.getTokenList();
        this.closeAll(nodeList, cleanTimeValues);
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        this.createDocumentNodes(nodeList, cleanTimeValues);
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        this.calculateRootNode(cleanTimeValues, htmlTokenizer.getNamespacePrefixes());
        if (Thread.currentThread().isInterrupted()) {
            this.handleInterruption();
            return null;
        }
        while (this.markNodesToPrune(nodeList, cleanTimeValues, 0)) {
            if (!Thread.currentThread().isInterrupted()) continue;
            this.handleInterruption();
            return null;
        }
        if (cleanTimeValues.pruneNodeSet != null && !cleanTimeValues.pruneNodeSet.isEmpty()) {
            Iterator<TagNode> iterator = cleanTimeValues.pruneNodeSet.iterator();
            while (iterator.hasNext()) {
                if (Thread.currentThread().isInterrupted()) {
                    this.handleInterruption();
                    return null;
                }
                TagNode tagNode = iterator.next();
                TagNode parent = tagNode.getParent();
                if (parent == null) continue;
                parent.removeChild(tagNode);
            }
        }
        cleanTimeValues.rootNode.setDocType(htmlTokenizer.getDocType());
        this.popNesting(cleanTimeValues);
        return cleanTimeValues.rootNode;
    }

    private boolean markNodesToPrune(List nodeList, CleanTimeValues cleanTimeValues, int depth) {
        if (depth > this.properties.getMaxDepth()) {
            return false;
        }
        boolean nodesPruned = false;
        for (Object next : nodeList) {
            if (!(next instanceof TagNode) || cleanTimeValues.pruneNodeSet.contains(next)) continue;
            TagNode node = (TagNode)next;
            if (this.addIfNeededToPruneSet(node, cleanTimeValues)) {
                nodesPruned = true;
                continue;
            }
            if (node.isEmpty()) continue;
            nodesPruned |= this.markNodesToPrune(node.getAllChildren(), cleanTimeValues, depth + 1);
        }
        return nodesPruned;
    }

    private void calculateRootNode(CleanTimeValues cleanTimeValues, Set<String> namespacePrefixes) {
        cleanTimeValues.rootNode = cleanTimeValues.htmlNode;
        if (this.properties.isOmitHtmlEnvelope()) {
            List<? extends BaseToken> bodyChildren = cleanTimeValues.bodyNode.getAllChildren();
            cleanTimeValues.rootNode = new TagNode(null);
            if (bodyChildren != null) {
                for (Object object : bodyChildren) {
                    cleanTimeValues.rootNode.addChild(object);
                }
            }
        }
        Map<String, String> atts = cleanTimeValues.rootNode.getAttributes();
        if (cleanTimeValues.rootNode.hasAttribute("xmlns")) {
            cleanTimeValues.rootNode.addNamespaceDeclaration("", cleanTimeValues.rootNode.getAttributeByName("xmlns"));
        }
        if (this.properties.isNamespacesAware() && namespacePrefixes != null) {
            Iterator<Object> iterator = namespacePrefixes.iterator();
            while (iterator.hasNext()) {
                String xmlnsAtt;
                if (Thread.currentThread().isInterrupted()) {
                    this.handleInterruption();
                    return;
                }
                String string = (String)iterator.next();
                if (cleanTimeValues.namespaceMap.containsKey(string) || atts.containsKey(xmlnsAtt = "xmlns:" + string) || string.equals("xml") || string.equals("")) continue;
                if (string.equals("svg")) {
                    cleanTimeValues.rootNode.addAttribute(xmlnsAtt, "http://www.w3.org/2000/svg");
                    continue;
                }
                if (string.equals("xlink")) {
                    cleanTimeValues.rootNode.addAttribute(xmlnsAtt, "http://www.w3.org/1999/xlink");
                    continue;
                }
                cleanTimeValues.rootNode.addAttribute(xmlnsAtt, string);
            }
        }
    }

    private void addAttributesToTag(TagNode tag, Map<String, String> attributes) {
        if (attributes != null) {
            Map<String, String> tagAttributes = tag.getAttributes();
            for (Map.Entry<String, String> currEntry : attributes.entrySet()) {
                String attName = currEntry.getKey();
                if (tagAttributes.containsKey(attName)) continue;
                String attValue = currEntry.getValue();
                tag.addAttribute(attName, attValue);
            }
        }
    }

    private boolean isFatalTagSatisfied(TagInfo tag, CleanTimeValues cleanTimeValues) {
        boolean fatal = true;
        if (tag != null) {
            if (tag.getFatalTags().isEmpty()) {
                return true;
            }
            fatal = false;
            for (String fatalTagName : tag.getFatalTags()) {
                if (!this.getOpenTags(cleanTimeValues).tagExists(fatalTagName, cleanTimeValues)) continue;
                fatal = true;
            }
        }
        return fatal;
    }

    private boolean mustAddRequiredParent(TagInfo tag, CleanTimeValues cleanTimeValues) {
        if (tag == null) {
            return false;
        }
        if (tag.getRequiredParentTags().isEmpty()) {
            return false;
        }
        int fatalTagPosition = -1;
        for (String string : tag.getFatalTags()) {
            TagPos tagPos;
            if (string == null || (tagPos = this.getOpenTags(cleanTimeValues).findTag(string, cleanTimeValues)) == null) continue;
            fatalTagPosition = tagPos.position;
        }
        boolean requiredTagMissing = true;
        for (String requiredTag : tag.getRequiredParentTags()) {
            TagPos currTagPos;
            if (requiredTag == null || (currTagPos = this.getOpenTags(cleanTimeValues).findTag(requiredTag, cleanTimeValues)) == null) continue;
            requiredTagMissing = currTagPos.position <= fatalTagPosition;
        }
        if (!requiredTagMissing) {
            return false;
        }
        ListIterator<TagPos> listIterator = this.getOpenTags((CleanTimeValues)cleanTimeValues).list.listIterator(this.getOpenTags((CleanTimeValues)cleanTimeValues).list.size());
        while (listIterator.hasPrevious()) {
            TagPos currTagPos = listIterator.previous();
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return currTagPos.position <= fatalTagPosition;
            }
            if (!tag.isHigher(currTagPos.name)) continue;
            return currTagPos.position <= fatalTagPosition;
        }
        return true;
    }

    private TagNode newTagNode(String tagName) {
        TagNode tagNode = new TagNode(tagName);
        return tagNode;
    }

    private TagNode createTagNode(TagNode startTagToken) {
        startTagToken.setFormed();
        return startTagToken;
    }

    private boolean isAllowedInLastOpenTag(BaseToken token, CleanTimeValues cleanTimeValues) {
        TagPos last = this.getOpenTags(cleanTimeValues).getLastTagPos();
        if (last != null && last.info != null) {
            return last.info.allowsItem(token);
        }
        return true;
    }

    private void saveToLastOpenTag(List nodeList, Object tokenToAdd, CleanTimeValues cleanTimeValues) {
        TagNode startTagToken;
        TagPos last = this.getOpenTags(cleanTimeValues).getLastTagPos();
        TagPos rubbishPos = this.getOpenTags(cleanTimeValues).findTagToPlaceRubbish();
        if (rubbishPos != null && (startTagToken = (TagNode)nodeList.get(rubbishPos.position)) != null) {
            startTagToken.addItemForMoving(tokenToAdd);
            return;
        }
    }

    private boolean isStartToken(Object o) {
        return o instanceof TagNode && !((TagNode)o).isFormed();
    }

    private boolean isAllowedAsForeignMarkup(String tagname, CleanTimeValues cleanTimeValues) {
        if (!this.properties.isNamespacesAware()) {
            return false;
        }
        if (tagname == null) {
            return false;
        }
        if (tagname.contains(":")) {
            return true;
        }
        if (cleanTimeValues.namespace == null || cleanTimeValues.namespace.size() == 0) {
            return false;
        }
        String ns = cleanTimeValues.namespace.peek();
        if (ns == null) {
            return false;
        }
        return !ns.equals("http://www.w3.org/1999/xhtml");
    }

    private void handleEndTagToken(BaseToken token, ListIterator<BaseToken> nodeIterator, List nodeList, CleanTimeValues cleanTimeValues) {
        EndTagToken endTagToken = (EndTagToken)token;
        String tagName = endTagToken.name;
        TagInfo tag = this.getTagInfo(tagName, cleanTimeValues);
        if (tag != null) {
            tagName = tag.getName();
        }
        if (tag == null && this.properties.isOmitUnknownTags() && !this.isAllowedAsForeignMarkup(tagName, cleanTimeValues) || tag != null && tag.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
            nodeIterator.set(null);
        } else if (tag != null && !tag.allowsBody()) {
            nodeIterator.set(null);
        } else {
            TagPos matchingPosition = this.getOpenTags(cleanTimeValues).findTag(tagName, cleanTimeValues);
            if (matchingPosition != null) {
                List<TagNode> closed = this.closeSnippet(nodeList, matchingPosition, endTagToken, cleanTimeValues);
                if (closed.size() > 0) {
                    TagInfo startTagInfo;
                    TagNode startingTag = closed.get(0);
                    if (startingTag.hasAttribute("xmlns")) {
                        cleanTimeValues.namespace.pop();
                    }
                    if ((startTagInfo = this.getTagInfo(startingTag.getName(), cleanTimeValues)) != null && startTagInfo.getAssumedNamespace() != null && !cleanTimeValues.namespace.isEmpty() && startTagInfo.getAssumedNamespace().equals(cleanTimeValues.namespace.lastElement()) && !startingTag.hasAttribute("xmlns")) {
                        cleanTimeValues.namespace.pop();
                    }
                }
                nodeIterator.set(null);
                for (int i = closed.size() - 1; i >= 0; --i) {
                    TagNode closedTag = closed.get(i);
                    if (i <= 0 || tag == null || !tag.isContinueAfter(closedTag.getName())) continue;
                    TagNode cloned = closedTag.makeCopy();
                    cloned.setAutoGenerated(true);
                    nodeIterator.add(cloned);
                    nodeIterator.previous();
                }
                if (!this.getChildBreaks(cleanTimeValues).isEmpty()) {
                    while (matchingPosition.position < this.getChildBreaks(cleanTimeValues).getLastBreakingTagPosition()) {
                        this.getChildBreaks(cleanTimeValues).pop();
                    }
                }
                while (!this.getChildBreaks(cleanTimeValues).isEmpty() && tagName.equals(this.getChildBreaks(cleanTimeValues).getLastBreakingTag()) && matchingPosition.position == this.getChildBreaks(cleanTimeValues).getLastBreakingTagPosition()) {
                    if (nodeList.get(this.getChildBreaks((CleanTimeValues)cleanTimeValues).closedByChildBreak.peek().position) != null) {
                        int position = this.getChildBreaks((CleanTimeValues)cleanTimeValues).pop().position;
                        Object toReopen = nodeList.get(position);
                        if (toReopen instanceof TagNode) {
                            this.reopenBrokenNode(nodeIterator, (TagNode)toReopen, cleanTimeValues);
                            continue;
                        }
                        if (!(toReopen instanceof List)) continue;
                        List<TagNode> tagNodes = (List<TagNode>)toReopen;
                        tagNodes = this.flattenNestedList(tagNodes);
                        for (TagNode n : tagNodes) {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            nodeIterator.add(n);
                            this.makeTree(nodeList, nodeList.listIterator(nodeList.size() - 1), cleanTimeValues);
                        }
                        nodeList.set(position, null);
                        continue;
                    }
                    this.getChildBreaks(cleanTimeValues).pop();
                }
            }
        }
    }

    private void handleStartTagToken(BaseToken token, ListIterator<BaseToken> nodeIterator, List nodeList, CleanTimeValues cleanTimeValues) {
        TagNode startTagToken = (TagNode)token;
        String tagName = startTagToken.getName();
        TagInfo tag = this.getTagInfo(tagName, cleanTimeValues);
        TagPos lastTagPos = this.getOpenTags(cleanTimeValues).isEmpty() ? null : this.getOpenTags(cleanTimeValues).getLastTagPos();
        TagInfo lastTagInfo = lastTagPos == null ? null : this.getTagInfo(lastTagPos.name, cleanTimeValues);
        cleanTimeValues.allTags.add(tagName);
        if (tag != null && tag.getAssumedNamespace() != null && !startTagToken.hasAttribute("xmlns")) {
            cleanTimeValues.namespace.push(tag.getAssumedNamespace());
        }
        for (String attribute : startTagToken.getAttributes().keySet()) {
            if (attribute.toLowerCase().indexOf("xmlns:") == -1) continue;
            String prefix = attribute.toLowerCase().split("xmlns:")[1];
            String ns = startTagToken.getAttributeByName(attribute);
            startTagToken.addNamespaceDeclaration(prefix.toLowerCase(), ns);
            cleanTimeValues.namespaceMap.put(prefix.toLowerCase(), ns);
        }
        if (startTagToken.hasAttribute("xmlns")) {
            String ns = startTagToken.getAttributeByName("xmlns");
            if (ns.equals("https://www.w3.org/1999/xhtml") || ns.equals("http://w3.org/1999/xhtml")) {
                ns = "http://www.w3.org/1999/xhtml";
                Map<String, String> attributes = startTagToken.getAttributes();
                attributes.put("xmlns", "http://www.w3.org/1999/xhtml");
                startTagToken.setAttributes(attributes);
            }
            if ("html".equals(tagName) && ns.equals("http://www.w3.org/TR/REC-html40")) {
                startTagToken.removeAttribute("xmlns");
            } else if (ns.trim().isEmpty()) {
                startTagToken.removeAttribute("xmlns");
            } else {
                cleanTimeValues.namespace.push(ns);
                startTagToken.addNamespaceDeclaration("", ns);
                cleanTimeValues.namespaceMap.put("", ns);
            }
            if (!this.properties.isNamespacesAware()) {
                startTagToken.removeAttribute("xmlns");
            }
        }
        if (this.isAllowedAsForeignMarkup(tagName, cleanTimeValues)) {
            startTagToken.setForeignMarkup(true);
        } else {
            startTagToken.setForeignMarkup(false);
        }
        tagName = startTagToken.getName();
        if ("html".equals(tagName)) {
            this.addAttributesToTag(cleanTimeValues.htmlNode, startTagToken.getAttributes());
            nodeIterator.set(null);
            return;
        }
        if ("body".equals(tagName)) {
            cleanTimeValues._bodyOpened = true;
            this.addAttributesToTag(cleanTimeValues.bodyNode, startTagToken.getAttributes());
            nodeIterator.set(null);
            return;
        }
        if ("head".equals(tagName)) {
            cleanTimeValues._headOpened = true;
            this.addAttributesToTag(cleanTimeValues.headNode, startTagToken.getAttributes());
            nodeIterator.set(null);
            return;
        }
        if (tag == null && this.properties.isOmitUnknownTags() && !this.isAllowedAsForeignMarkup(tagName, cleanTimeValues)) {
            nodeIterator.set(null);
            this.properties.fireUglyHtml(true, startTagToken, ErrorType.Unknown);
            return;
        }
        if (tag != null && tag.isDeprecated() && this.properties.isOmitDeprecatedTags()) {
            nodeIterator.set(null);
            this.properties.fireUglyHtml(true, startTagToken, ErrorType.Deprecated);
            return;
        }
        if (tag == null && lastTagInfo != null && !lastTagInfo.allowsAnything() && !lastTagInfo.allowsItem(startTagToken)) {
            this.closeSnippet(nodeList, lastTagPos, startTagToken, cleanTimeValues);
            nodeIterator.previous();
            return;
        }
        if (tag != null && tag.hasPermittedTags() && this.getOpenTags(cleanTimeValues).someAlreadyOpen(tag.getPermittedTags())) {
            nodeIterator.set(null);
            return;
        }
        if (tag != null && tag.isUnique() && this.getOpenTags(cleanTimeValues).tagEncountered(tagName)) {
            nodeIterator.set(null);
            this.properties.fireHtmlError(true, startTagToken, ErrorType.UniqueTagDuplicated);
            return;
        }
        if (!this.isFatalTagSatisfied(tag, cleanTimeValues)) {
            nodeIterator.set(null);
            this.properties.fireHtmlError(true, startTagToken, ErrorType.FatalTagMissing);
            return;
        }
        if (this.mustAddRequiredParent(tag, cleanTimeValues)) {
            String requiredParent = tag.getRequiredParentTags().iterator().next();
            TagNode requiredParentStartToken = this.newTagNode(requiredParent);
            if (this.isAllowedInLastOpenTag(requiredParentStartToken, cleanTimeValues)) {
                requiredParentStartToken.setAutoGenerated(true);
                nodeIterator.previous();
                nodeIterator.add(requiredParentStartToken);
                nodeIterator.previous();
                this.properties.fireHtmlError(true, startTagToken, ErrorType.RequiredParentMissing);
            } else {
                this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
                nodeIterator.set(null);
            }
            return;
        }
        if (tag != null && lastTagPos != null && tag.isMustCloseTag(lastTagInfo)) {
            this.getChildBreaks(cleanTimeValues).addBreak(lastTagPos, new TagPos(nodeIterator.previousIndex(), tag.getName(), this.getTagInfo(tagName, cleanTimeValues), cleanTimeValues));
            boolean certainty = !startTagToken.hasAttribute("id");
            this.properties.fireHtmlError(certainty, (TagNode)nodeList.get(lastTagPos.position), ErrorType.UnpermittedChild);
            List<TagNode> closed = this.closeSnippet(nodeList, lastTagPos, startTagToken, cleanTimeValues);
            int closedCount = closed.size();
            if (tag.hasCopyTags() && closedCount > 0) {
                ListIterator<TagNode> closedIt = closed.listIterator(closedCount);
                ArrayList<TagNode> toBeCopied = new ArrayList<TagNode>();
                while (closedIt.hasPrevious()) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.handleInterruption();
                        return;
                    }
                    TagNode currStartToken = closedIt.previous();
                    if (!tag.isCopy(currStartToken.getName())) break;
                    toBeCopied.add(0, currStartToken);
                }
                if (toBeCopied.size() > 0) {
                    Iterator copyIt = toBeCopied.iterator();
                    while (copyIt.hasNext()) {
                        if (Thread.currentThread().isInterrupted()) {
                            this.handleInterruption();
                            return;
                        }
                        TagNode currStartToken = (TagNode)copyIt.next();
                        if (!HtmlCleaner.isCopiedTokenEqualToNextThreeCopiedTokens(currStartToken, nodeIterator)) {
                            nodeIterator.add(currStartToken.makeCopy());
                            continue;
                        }
                        copyIt.remove();
                    }
                    for (int i = 0; i < toBeCopied.size(); ++i) {
                        nodeIterator.previous();
                    }
                }
            }
            nodeIterator.previous();
            return;
        }
        if (!this.isAllowedInLastOpenTag(token, cleanTimeValues)) {
            TagPos last = this.getOpenTags(cleanTimeValues).getLastTagPos();
            if (last != null && last.info != null && last.info.getPreferredChildTag() != null) {
                TagNode interveningTagStartToken = this.newTagNode(last.info.getPreferredChildTag());
                if (this.isAllowedInLastOpenTag(interveningTagStartToken, cleanTimeValues) && this.getTagInfo(last.info.getPreferredChildTag(), cleanTimeValues) != null && this.getTagInfo(last.info.getPreferredChildTag(), cleanTimeValues).allowsItem(token)) {
                    interveningTagStartToken.setAutoGenerated(true);
                    nodeIterator.previous();
                    nodeIterator.add(interveningTagStartToken);
                    nodeIterator.previous();
                    this.properties.fireHtmlError(true, startTagToken, ErrorType.RequiredParentMissing);
                } else {
                    this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
                    nodeIterator.set(null);
                }
            } else {
                this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
                nodeIterator.set(null);
            }
            return;
        }
        if (tag != null && !tag.allowsBody()) {
            TagNode newTagNode = this.createTagNode(startTagToken);
            this.addPossibleHeadCandidate(tag, newTagNode, cleanTimeValues);
            nodeIterator.set(newTagNode);
            return;
        }
        this.getOpenTags(cleanTimeValues).addTag(tagName, this.getTagInfo(tagName, cleanTimeValues), nodeIterator.previousIndex(), cleanTimeValues);
    }

    void makeTree(List nodeList, ListIterator<BaseToken> nodeIterator, CleanTimeValues cleanTimeValues) {
        while (nodeIterator.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return;
            }
            BaseToken token = nodeIterator.next();
            if (token instanceof EndTagToken) {
                this.handleEndTagToken(token, nodeIterator, nodeList, cleanTimeValues);
                continue;
            }
            if (this.isStartToken(token)) {
                this.handleStartTagToken(token, nodeIterator, nodeList, cleanTimeValues);
                continue;
            }
            if (cleanTimeValues._headOpened && !cleanTimeValues._bodyOpened && this.properties.isKeepWhitespaceAndCommentsInHead()) {
                BaseToken lastTok;
                ContentNode contentNode;
                if (token instanceof CommentNode) {
                    if (this.getOpenTags(cleanTimeValues).getLastTagPos() == null) {
                        cleanTimeValues._headTags.add(new ProxyTagNode((CommentNode)token, cleanTimeValues.bodyNode));
                    }
                } else if (token instanceof ContentNode && (contentNode = (ContentNode)token).isBlank() && (lastTok = (BaseToken)nodeList.get(nodeList.size() - 1)) == token) {
                    cleanTimeValues._headTags.add(new ProxyTagNode(contentNode, cleanTimeValues.bodyNode));
                }
            }
            if (this.isAllowedInLastOpenTag(token, cleanTimeValues)) continue;
            this.saveToLastOpenTag(nodeList, token, cleanTimeValues);
            nodeIterator.set(null);
        }
    }

    private static boolean isCopiedTokenEqualToNextThreeCopiedTokens(TagNode copiedStartToken, ListIterator<BaseToken> nodeIterator) {
        int steps = 0;
        int matches = 0;
        while (nodeIterator.hasNext() && steps < 3) {
            BaseToken nextToken = nodeIterator.next();
            ++steps;
            if (!(nextToken instanceof TagNode) || !((TagNode)nextToken).isCopy() || !HtmlCleaner.areCopiedTokensEqual((TagNode)nextToken, copiedStartToken)) break;
            ++matches;
        }
        for (int i = 0; i < steps; ++i) {
            nodeIterator.previous();
        }
        return matches == 3;
    }

    private List<TagNode> flattenNestedList(List list) {
        ArrayList<TagNode> flattenedNodeList = new ArrayList<TagNode>();
        for (Object item : list) {
            if (item instanceof TagNode) {
                flattenedNodeList.add((TagNode)item);
                continue;
            }
            if (!(item instanceof List)) continue;
            flattenedNodeList.addAll((List)item);
        }
        return flattenedNodeList;
    }

    private static boolean areCopiedTokensEqual(TagNode token1, TagNode token2) {
        return token1.name.equals(token2.name) && token1.getAttributes().equals(token2.getAttributes());
    }

    private void reopenBrokenNode(ListIterator<BaseToken> nodeIterator, TagNode toReopen, CleanTimeValues cleanTimeValues) {
        TagNode closedByPrecedence = toReopen;
        TagNode copy = closedByPrecedence.makeCopy();
        copy.setAutoGenerated(true);
        copy.removeAttribute("id");
        nodeIterator.add(copy);
        this.getOpenTags(cleanTimeValues).addTag(closedByPrecedence.getName(), this.getTagInfo(closedByPrecedence.getName(), cleanTimeValues), nodeIterator.previousIndex(), cleanTimeValues);
    }

    protected boolean isRemovingNodeReasonablySafe(TagNode startTagToken) {
        return !startTagToken.hasAttribute("id") && !startTagToken.hasAttribute("name") && !startTagToken.hasAttribute("class");
    }

    private void createDocumentNodes(List listNodes, CleanTimeValues cleanTimeValues) {
        for (Object child : listNodes) {
            if (child == null) continue;
            boolean toAdd = true;
            if (child instanceof TagNode) {
                TagNode node = (TagNode)child;
                TagInfo tag = this.getTagInfo(node.getName(), cleanTimeValues);
                this.addPossibleHeadCandidate(tag, node, cleanTimeValues);
            } else if (child instanceof ContentNode) {
                boolean bl = toAdd = !"".equals(child.toString());
            }
            if (!toAdd) continue;
            cleanTimeValues.bodyNode.addChild(child);
        }
        Iterator headIterator = cleanTimeValues._headTags.iterator();
        while (headIterator.hasNext()) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return;
            }
            TagNode headCandidateNode = (TagNode)headIterator.next();
            boolean toMove = true;
            for (TagNode parent = headCandidateNode.getParent(); parent != null; parent = parent.getParent()) {
                if (!cleanTimeValues._headTags.contains(parent)) continue;
                toMove = false;
                break;
            }
            if (!toMove) continue;
            headCandidateNode.removeFromTree();
            cleanTimeValues.headNode.addChild(headCandidateNode);
        }
    }

    private List<TagNode> closeSnippet(List nodeList, TagPos tagPos, Object toNode, CleanTimeValues cleanTimeValues) {
        TagNode startTagToken;
        TagInfo tagInfo;
        ArrayList<TagNode> closed = new ArrayList<TagNode>();
        ListIterator<Object> it = nodeList.listIterator(tagPos.position);
        TagNode tagNode = null;
        boolean assumedNS = false;
        Object item = it.next();
        if (this.isStartToken(item) && (tagInfo = this.getTagInfo((startTagToken = (TagNode)item).getName(), cleanTimeValues)) != null && tagInfo.getAssumedNamespace() != null) {
            assumedNS = true;
        }
        boolean isListEnd = false;
        while (toNode == null && !isListEnd || toNode != null && item != toNode) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return closed;
            }
            if (this.isStartToken(item)) {
                TagNode startTagToken2 = (TagNode)item;
                closed.add(startTagToken2);
                List<? extends BaseToken> itemsToMove = startTagToken2.getItemsToMove();
                if (itemsToMove != null) {
                    this.pushNesting(cleanTimeValues);
                    this.makeTree(itemsToMove, itemsToMove.listIterator(0), cleanTimeValues);
                    this.closeAll(itemsToMove, cleanTimeValues);
                    startTagToken2.setItemsToMove(null);
                    this.popNesting(cleanTimeValues);
                }
                TagNode newTagNode = this.createTagNode(startTagToken2);
                TagInfo tag = this.getTagInfo(newTagNode.getName(), cleanTimeValues);
                this.addPossibleHeadCandidate(tag, newTagNode, cleanTimeValues);
                if (tagNode != null) {
                    tagNode.addChildren(itemsToMove);
                    tagNode.addChild(newTagNode);
                    it.set(null);
                } else if (itemsToMove != null) {
                    itemsToMove.add(newTagNode);
                    it.set(itemsToMove);
                } else {
                    it.set(newTagNode);
                }
                this.getOpenTags(cleanTimeValues).removeTag(newTagNode.getName());
                tagNode = newTagNode;
            } else if (tagNode != null) {
                it.set(null);
                if (item != null) {
                    tagNode.addChild(item);
                }
            }
            if (it.hasNext()) {
                item = it.next();
                continue;
            }
            isListEnd = true;
        }
        if (assumedNS && !cleanTimeValues.namespace.isEmpty()) {
            cleanTimeValues.namespace.pop();
        }
        return closed;
    }

    private void closeAll(List nodeList, CleanTimeValues cleanTimeValues) {
        TagPos firstTagPos = this.getOpenTags(cleanTimeValues).findFirstTagPos();
        for (TagPos pos : this.getOpenTags((CleanTimeValues)cleanTimeValues).list) {
            if (Thread.currentThread().isInterrupted()) {
                this.handleInterruption();
                return;
            }
            this.properties.fireHtmlError(true, (TagNode)nodeList.get(pos.position), ErrorType.UnclosedTag);
        }
        if (firstTagPos != null) {
            this.closeSnippet(nodeList, firstTagPos, null, cleanTimeValues);
        }
    }

    private void addPossibleHeadCandidate(TagInfo tagInfo, TagNode tagNode, CleanTimeValues cleanTimeValues) {
        if (tagInfo != null && tagNode != null && (tagInfo.isHeadTag() || tagInfo.isHeadAndBodyTag() && cleanTimeValues._headOpened && !cleanTimeValues._bodyOpened)) {
            cleanTimeValues._headTags.add(tagNode);
        }
    }

    public CleanerProperties getProperties() {
        return this.properties;
    }

    protected Set<ITagNodeCondition> getPruneTagSet(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.pruneTagSet;
    }

    protected Set<ITagNodeCondition> getAllowTagSet(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.allowTagSet;
    }

    protected void addPruneNode(TagNode node, CleanTimeValues cleanTimeValues) {
        node.setPruned(true);
        cleanTimeValues.pruneNodeSet.add(node);
    }

    public TagInfo getTagInfo(String tagName, CleanTimeValues cleanTimeValues) {
        String ns;
        TagInfo tag = null;
        tag = this.getTagInfoProvider().getTagInfo(tagName);
        if (tag != null && tag.getAssumedNamespace() != null && cleanTimeValues.namespace != null && cleanTimeValues.namespace.size() > 0 && (ns = cleanTimeValues.namespace.peek()) == tag.getAssumedNamespace()) {
            return tag;
        }
        if (!this.isAllowedAsForeignMarkup(tagName, cleanTimeValues)) {
            return this.getTagInfoProvider().getTagInfo(tagName);
        }
        return null;
    }

    private boolean addIfNeededToPruneSet(TagNode tagNode, CleanTimeValues cleanTimeValues) {
        if (cleanTimeValues.pruneTagSet != null) {
            for (ITagNodeCondition condition : cleanTimeValues.pruneTagSet) {
                if (!condition.satisfy(tagNode)) continue;
                this.addPruneNode(tagNode, cleanTimeValues);
                this.properties.fireConditionModification(condition, tagNode);
                return true;
            }
        }
        if (cleanTimeValues.allowTagSet != null && !cleanTimeValues.allowTagSet.isEmpty()) {
            for (ITagNodeCondition condition : cleanTimeValues.allowTagSet) {
                if (!condition.satisfy(tagNode)) continue;
                return false;
            }
            if (!tagNode.isAutoGenerated()) {
                this.properties.fireUserDefinedModification(true, tagNode, ErrorType.NotAllowedTag);
            }
            this.addPruneNode(tagNode, cleanTimeValues);
            return true;
        }
        return false;
    }

    protected Set<String> getAllTags(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.allTags;
    }

    public ITagInfoProvider getTagInfoProvider() {
        return this.properties.getTagInfoProvider();
    }

    public CleanerTransformations getTransformations() {
        return this.transformations;
    }

    public String getInnerHtml(TagNode node) {
        if (node != null) {
            String content = new SimpleXmlSerializer(this.properties).getAsString(node);
            int index1 = content.indexOf("<" + node.getName());
            index1 = content.indexOf(62, index1 + 1);
            int index2 = content.lastIndexOf(60);
            return index1 >= 0 && index1 <= index2 ? content.substring(index1 + 1, index2) : null;
        }
        throw new HtmlCleanerException("Cannot return inner html of the null node!");
    }

    public void setInnerHtml(TagNode node, String content) {
        if (node != null) {
            String nodeName = node.getName();
            StringBuilder html = new StringBuilder();
            html.append("<").append(nodeName).append(" htmlcleaner_marker=''>").append(content).append("</").append(nodeName).append(">");
            for (TagNode parent = node.getParent(); parent != null; parent = parent.getParent()) {
                String parentName = parent.getName();
                html.insert(0, "<" + parentName + ">");
                html.append("</").append(parentName).append(">");
            }
            TagNode innerRootNode = this.clean(html.toString());
            TagNode cleanedNode = innerRootNode.findElementHavingAttribute(MARKER_ATTRIBUTE, true);
            if (cleanedNode != null) {
                node.setChildren(cleanedNode.getAllChildren());
            }
        }
    }

    public void initCleanerTransformations(Map transInfos) {
        this.transformations = new CleanerTransformations(transInfos);
    }

    private OpenTags getOpenTags(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.peek().getOpenTags();
    }

    private ChildBreaks getChildBreaks(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.peek().getChildBreaks();
    }

    private NestingState pushNesting(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.push(new NestingState(new OpenTags(this), new ChildBreaks()));
    }

    private NestingState popNesting(CleanTimeValues cleanTimeValues) {
        return cleanTimeValues.nestingStates.pop();
    }

    protected void handleInterruption() {
    }
}

