/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NameRecord;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.WGL4Names;

public final class TTFSubsetter {
    private static final byte[] PAD_BUF = new byte[]{0, 0, 0};
    private final TrueTypeFont ttf;
    private final CmapSubtable unicodeCmap;
    private final SortedMap<Integer, Integer> uniToGID;
    private final List<String> keepTables;
    private final SortedSet<Integer> glyphIds;
    private String prefix;
    private boolean hasAddedCompoundReferences;

    public TTFSubsetter(TrueTypeFont ttf) throws IOException {
        this(ttf, null);
    }

    public TTFSubsetter(TrueTypeFont ttf, List<String> tables) throws IOException {
        this.ttf = ttf;
        this.keepTables = tables;
        this.uniToGID = new TreeMap<Integer, Integer>();
        this.glyphIds = new TreeSet<Integer>();
        this.unicodeCmap = this.getUnicodeCmap(ttf.getCmap());
        this.glyphIds.add(0);
    }

    private CmapSubtable getUnicodeCmap(CmapTable cmapTable) throws IOException {
        CmapSubtable cmap = cmapTable.getSubtable(0, 4);
        if (cmap == null) {
            cmap = cmapTable.getSubtable(0, 3);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 1);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 0);
        }
        if (cmap == null) {
            throw new IOException("The TrueType font does not contain a Unicode cmap");
        }
        return cmap;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void add(int unicode) {
        int gid = this.unicodeCmap.getGlyphId(unicode);
        if (gid != 0) {
            this.uniToGID.put(unicode, gid);
            this.glyphIds.add(gid);
        }
    }

    public void addAll(Set<Integer> unicodeSet) {
        for (int unicode : unicodeSet) {
            this.add(unicode);
        }
    }

    public Map<Integer, Integer> getGIDMap() throws IOException {
        this.addCompoundReferences();
        HashMap<Integer, Integer> newToOld = new HashMap<Integer, Integer>();
        int newGID = 0;
        Iterator i$ = this.glyphIds.iterator();
        while (i$.hasNext()) {
            int oldGID = (Integer)i$.next();
            newToOld.put(newGID, oldGID);
            ++newGID;
        }
        return newToOld;
    }

    private long writeFileHeader(DataOutputStream out, int nTables) throws IOException {
        out.writeInt(65536);
        out.writeShort(nTables);
        int mask = Integer.highestOneBit(nTables);
        int searchRange = mask * 16;
        out.writeShort(searchRange);
        int entrySelector = this.log2(mask);
        out.writeShort(entrySelector);
        int last = 16 * nTables - searchRange;
        out.writeShort(last);
        return 65536L + this.toUInt32(nTables, searchRange) + this.toUInt32(entrySelector, last);
    }

    private long writeTableHeader(DataOutputStream out, String tag, long offset, byte[] bytes) throws IOException {
        long checksum = 0L;
        int n = bytes.length;
        for (int nup = 0; nup < n; ++nup) {
            checksum += ((long)bytes[nup] & 0xFFL) << 24 - nup % 4 * 8;
        }
        byte[] tagbytes = tag.getBytes("US-ASCII");
        out.write(tagbytes, 0, 4);
        out.writeInt((int)(checksum &= 0xFFFFFFFFL));
        out.writeInt((int)offset);
        out.writeInt(bytes.length);
        return this.toUInt32(tagbytes) + checksum + checksum + offset + (long)bytes.length;
    }

    private void writeTableBody(OutputStream os, byte[] bytes) throws IOException {
        int n = bytes.length;
        os.write(bytes);
        if (n % 4 != 0) {
            os.write(PAD_BUF, 0, 4 - n % 4);
        }
    }

    private byte[] buildHeadTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        HeaderTable h = this.ttf.getHeader();
        this.writeFixed(out, h.getVersion());
        this.writeFixed(out, h.getFontRevision());
        this.writeUint32(out, 0L);
        this.writeUint32(out, h.getMagicNumber());
        this.writeUint16(out, h.getFlags());
        this.writeUint16(out, h.getUnitsPerEm());
        this.writeLongDateTime(out, h.getCreated());
        this.writeLongDateTime(out, h.getModified());
        this.writeSInt16(out, h.getXMin());
        this.writeSInt16(out, h.getYMin());
        this.writeSInt16(out, h.getXMax());
        this.writeSInt16(out, h.getYMax());
        this.writeUint16(out, h.getMacStyle());
        this.writeUint16(out, h.getLowestRecPPEM());
        this.writeSInt16(out, h.getFontDirectionHint());
        this.writeSInt16(out, (short)1);
        this.writeSInt16(out, h.getGlyphDataFormat());
        out.flush();
        return bos.toByteArray();
    }

    private byte[] buildHheaTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        HorizontalHeaderTable h = this.ttf.getHorizontalHeader();
        this.writeFixed(out, h.getVersion());
        this.writeSInt16(out, h.getAscender());
        this.writeSInt16(out, h.getDescender());
        this.writeSInt16(out, h.getLineGap());
        this.writeUint16(out, h.getAdvanceWidthMax());
        this.writeSInt16(out, h.getMinLeftSideBearing());
        this.writeSInt16(out, h.getMinRightSideBearing());
        this.writeSInt16(out, h.getXMaxExtent());
        this.writeSInt16(out, h.getCaretSlopeRise());
        this.writeSInt16(out, h.getCaretSlopeRun());
        this.writeSInt16(out, h.getReserved1());
        this.writeSInt16(out, h.getReserved2());
        this.writeSInt16(out, h.getReserved3());
        this.writeSInt16(out, h.getReserved4());
        this.writeSInt16(out, h.getReserved5());
        this.writeSInt16(out, h.getMetricDataFormat());
        this.writeUint16(out, this.glyphIds.subSet(0, h.getNumberOfHMetrics()).size());
        out.flush();
        return bos.toByteArray();
    }

    private boolean shouldCopyNameRecord(NameRecord nr) {
        return nr.getPlatformId() == 3 && nr.getPlatformEncodingId() == 1 && nr.getLanguageId() == 1033 && nr.getNameId() >= 0 && nr.getNameId() < 7;
    }

    private byte[] buildNameTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        NamingTable name = this.ttf.getNaming();
        if (name == null || this.keepTables != null && !this.keepTables.contains("name")) {
            return null;
        }
        List<NameRecord> nameRecords = name.getNameRecords();
        int numRecords = 0;
        for (NameRecord record : nameRecords) {
            if (!this.shouldCopyNameRecord(record)) continue;
            ++numRecords;
        }
        this.writeUint16(out, 0);
        this.writeUint16(out, numRecords);
        this.writeUint16(out, 6 + 12 * numRecords);
        if (numRecords == 0) {
            return null;
        }
        byte[][] names = new byte[numRecords][];
        int j = 0;
        for (NameRecord record : nameRecords) {
            if (!this.shouldCopyNameRecord(record)) continue;
            int platform = record.getPlatformId();
            int encoding = record.getPlatformEncodingId();
            String charset = "ISO-8859-1";
            if (platform == 3 && encoding == 1) {
                charset = "UTF-16BE";
            } else if (platform == 2) {
                if (encoding == 0) {
                    charset = "US-ASCII";
                } else if (encoding == 1) {
                    charset = "UTF16-BE";
                } else if (encoding == 2) {
                    charset = "ISO-8859-1";
                }
            }
            String value = record.getString();
            if (record.getNameId() == 6 && this.prefix != null) {
                value = this.prefix + value;
            }
            names[j] = value.getBytes(charset);
            ++j;
        }
        int offset = 0;
        j = 0;
        for (NameRecord nr : nameRecords) {
            if (!this.shouldCopyNameRecord(nr)) continue;
            this.writeUint16(out, nr.getPlatformId());
            this.writeUint16(out, nr.getPlatformEncodingId());
            this.writeUint16(out, nr.getLanguageId());
            this.writeUint16(out, nr.getNameId());
            this.writeUint16(out, names[j].length);
            this.writeUint16(out, offset);
            offset += names[j].length;
            ++j;
        }
        for (int i = 0; i < numRecords; ++i) {
            out.write(names[i]);
        }
        out.flush();
        return bos.toByteArray();
    }

    private byte[] buildMaxpTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        MaximumProfileTable p = this.ttf.getMaximumProfile();
        this.writeFixed(out, 1.0);
        this.writeUint16(out, this.glyphIds.size());
        this.writeUint16(out, p.getMaxPoints());
        this.writeUint16(out, p.getMaxContours());
        this.writeUint16(out, p.getMaxCompositePoints());
        this.writeUint16(out, p.getMaxCompositeContours());
        this.writeUint16(out, p.getMaxZones());
        this.writeUint16(out, p.getMaxTwilightPoints());
        this.writeUint16(out, p.getMaxStorage());
        this.writeUint16(out, p.getMaxFunctionDefs());
        this.writeUint16(out, p.getMaxInstructionDefs());
        this.writeUint16(out, p.getMaxStackElements());
        this.writeUint16(out, p.getMaxSizeOfInstructions());
        this.writeUint16(out, p.getMaxComponentElements());
        this.writeUint16(out, p.getMaxComponentDepth());
        out.flush();
        return bos.toByteArray();
    }

    private byte[] buildOS2Table() throws IOException {
        OS2WindowsMetricsTable os2 = this.ttf.getOS2Windows();
        if (os2 == null || this.keepTables != null && !this.keepTables.contains("OS/2")) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.writeUint16(out, os2.getVersion());
        this.writeSInt16(out, os2.getAverageCharWidth());
        this.writeUint16(out, os2.getWeightClass());
        this.writeUint16(out, os2.getWidthClass());
        this.writeSInt16(out, os2.getFsType());
        this.writeSInt16(out, os2.getSubscriptXSize());
        this.writeSInt16(out, os2.getSubscriptYSize());
        this.writeSInt16(out, os2.getSubscriptXOffset());
        this.writeSInt16(out, os2.getSubscriptYOffset());
        this.writeSInt16(out, os2.getSuperscriptXSize());
        this.writeSInt16(out, os2.getSuperscriptYSize());
        this.writeSInt16(out, os2.getSuperscriptXOffset());
        this.writeSInt16(out, os2.getSuperscriptYOffset());
        this.writeSInt16(out, os2.getStrikeoutSize());
        this.writeSInt16(out, os2.getStrikeoutPosition());
        this.writeUint8(out, os2.getFamilyClass());
        this.writeUint8(out, os2.getFamilySubClass());
        out.write(os2.getPanose());
        this.writeUint32(out, 0L);
        this.writeUint32(out, 0L);
        this.writeUint32(out, 0L);
        this.writeUint32(out, 0L);
        out.write(os2.getAchVendId().getBytes("US-ASCII"));
        Iterator<Map.Entry<Integer, Integer>> it = this.uniToGID.entrySet().iterator();
        it.next();
        Map.Entry<Integer, Integer> first = it.next();
        this.writeUint16(out, os2.getFsSelection());
        this.writeUint16(out, first.getKey());
        this.writeUint16(out, this.uniToGID.lastKey());
        this.writeUint16(out, os2.getTypoAscender());
        this.writeUint16(out, os2.getTypoDescender());
        this.writeUint16(out, os2.getTypoLineGap());
        this.writeUint16(out, os2.getWinAscent());
        this.writeUint16(out, os2.getWinDescent());
        out.flush();
        return bos.toByteArray();
    }

    private byte[] buildLocaTable(long[] newOffsets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        for (long offset : newOffsets) {
            this.writeUint32(out, offset);
        }
        out.flush();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCompoundReferences() throws IOException {
        TreeSet<Integer> glyphIdsToAdd;
        boolean hasNested;
        if (this.hasAddedCompoundReferences) {
            return;
        }
        this.hasAddedCompoundReferences = true;
        do {
            GlyphTable g = this.ttf.getGlyph();
            long[] offsets = this.ttf.getIndexToLocation().getOffsets();
            InputStream is = this.ttf.getOriginalData();
            glyphIdsToAdd = null;
            try {
                is.skip(g.getOffset());
                long lastOff = 0L;
                for (Integer glyphId : this.glyphIds) {
                    long offset = offsets[glyphId];
                    long len = offsets[glyphId + 1] - offset;
                    is.skip(offset - lastOff);
                    byte[] buf = new byte[(int)len];
                    is.read(buf);
                    if (buf.length >= 2 && buf[0] == -1 && buf[1] == -1) {
                        int flags;
                        int off = 10;
                        do {
                            int ogid;
                            flags = (buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF;
                            if (!this.glyphIds.contains(ogid = (buf[off += 2] & 0xFF) << 8 | buf[off + 1] & 0xFF)) {
                                if (glyphIdsToAdd == null) {
                                    glyphIdsToAdd = new TreeSet<Integer>();
                                }
                                glyphIdsToAdd.add(ogid);
                            }
                            off += 2;
                            off = (flags & 1) != 0 ? (off += 4) : (off += 2);
                            if ((flags & 0x80) != 0) {
                                off += 8;
                                continue;
                            }
                            if ((flags & 0x40) != 0) {
                                off += 4;
                                continue;
                            }
                            if ((flags & 8) == 0) continue;
                            off += 2;
                        } while ((flags & 0x20) != 0);
                    }
                    lastOff = offsets[glyphId + 1];
                }
            }
            finally {
                is.close();
            }
            if (glyphIdsToAdd == null) continue;
            this.glyphIds.addAll(glyphIdsToAdd);
        } while (hasNested = glyphIdsToAdd != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildGlyfTable(long[] newOffsets) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GlyphTable g = this.ttf.getGlyph();
        long[] offsets = this.ttf.getIndexToLocation().getOffsets();
        InputStream is = this.ttf.getOriginalData();
        try {
            is.skip(g.getOffset());
            long prevEnd = 0L;
            long newOffset = 0L;
            int newGid = 0;
            for (Integer gid : this.glyphIds) {
                long offset = offsets[gid];
                long length = offsets[gid + 1] - offset;
                newOffsets[newGid++] = newOffset;
                is.skip(offset - prevEnd);
                byte[] buf = new byte[(int)length];
                is.read(buf);
                if (buf.length >= 2 && buf[0] == -1 && buf[1] == -1) {
                    int flags;
                    int off = 10;
                    do {
                        int componentGid;
                        flags = (buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF;
                        if (!this.glyphIds.contains(componentGid = (buf[off += 2] & 0xFF) << 8 | buf[off + 1] & 0xFF)) {
                            this.glyphIds.add(componentGid);
                        }
                        int newComponentGid = this.getNewGlyphId(componentGid);
                        buf[off] = (byte)(newComponentGid >>> 8);
                        buf[off + 1] = (byte)newComponentGid;
                        off += 2;
                        off = (flags & 1) != 0 ? (off += 4) : (off += 2);
                        if ((flags & 0x80) != 0) {
                            off += 8;
                            continue;
                        }
                        if ((flags & 0x40) != 0) {
                            off += 4;
                            continue;
                        }
                        if ((flags & 8) == 0) continue;
                        off += 2;
                    } while ((flags & 0x20) != 0);
                    if ((flags & 0x100) == 256) {
                        int numInstr = (buf[off] & 0xFF) << 8 | buf[off + 1] & 0xFF;
                        off += 2;
                        off += numInstr;
                    }
                    bos.write(buf, 0, off);
                    newOffset += (long)off;
                } else if (buf.length > 0) {
                    bos.write(buf, 0, buf.length);
                    newOffset += (long)buf.length;
                }
                if (newOffset % 4L != 0L) {
                    int len = 4 - (int)(newOffset % 4L);
                    bos.write(PAD_BUF, 0, len);
                    newOffset += (long)len;
                }
                prevEnd = offset + length;
            }
            newOffsets[newGid++] = newOffset;
        }
        finally {
            is.close();
        }
        return bos.toByteArray();
    }

    private int getNewGlyphId(Integer oldGid) {
        return this.glyphIds.headSet(oldGid).size();
    }

    private byte[] buildCmapTable() throws IOException {
        int i;
        Map.Entry<Integer, Integer> lastChar;
        if (this.ttf.getCmap() == null || this.keepTables != null && !this.keepTables.contains("cmap")) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.writeUint16(out, 0);
        this.writeUint16(out, 1);
        this.writeUint16(out, 3);
        this.writeUint16(out, 1);
        this.writeUint32(out, 12L);
        Iterator<Map.Entry<Integer, Integer>> it = this.uniToGID.entrySet().iterator();
        it.next();
        Map.Entry<Integer, Integer> prevChar = lastChar = it.next();
        int lastGid = this.getNewGlyphId(lastChar.getValue());
        int[] startCode = new int[this.uniToGID.size()];
        int[] endCode = new int[this.uniToGID.size()];
        int[] idDelta = new int[this.uniToGID.size()];
        int segCount = 0;
        while (it.hasNext()) {
            Map.Entry<Integer, Integer> curChar2Gid = it.next();
            int curGid = this.getNewGlyphId(curChar2Gid.getValue());
            if (curChar2Gid.getKey() > 65535) {
                throw new UnsupportedOperationException("non-BMP Unicode character");
            }
            if (curChar2Gid.getKey() != prevChar.getKey() + 1 || curGid - lastGid != curChar2Gid.getKey() - lastChar.getKey()) {
                if (lastGid != 0) {
                    startCode[segCount] = lastChar.getKey();
                    endCode[segCount] = prevChar.getKey();
                    idDelta[segCount] = lastGid - lastChar.getKey();
                    ++segCount;
                } else if (!lastChar.getKey().equals(prevChar.getKey())) {
                    startCode[segCount] = lastChar.getKey() + 1;
                    endCode[segCount] = prevChar.getKey();
                    idDelta[segCount] = lastGid - lastChar.getKey();
                    ++segCount;
                }
                lastGid = curGid;
                lastChar = curChar2Gid;
            }
            prevChar = curChar2Gid;
        }
        startCode[segCount] = lastChar.getKey();
        endCode[segCount] = prevChar.getKey();
        idDelta[segCount] = lastGid - lastChar.getKey();
        startCode[++segCount] = 65535;
        endCode[segCount] = 65535;
        idDelta[segCount] = 1;
        int searchRange = 2 * (int)Math.pow(2.0, Math.floor(this.log2(++segCount)));
        this.writeUint16(out, 4);
        this.writeUint16(out, 16 + segCount * 4 * 2);
        this.writeUint16(out, 0);
        this.writeUint16(out, segCount * 2);
        this.writeUint16(out, searchRange);
        this.writeUint16(out, this.log2(searchRange / 2));
        this.writeUint16(out, 2 * segCount - searchRange);
        for (i = 0; i < segCount; ++i) {
            this.writeUint16(out, endCode[i]);
        }
        this.writeUint16(out, 0);
        for (i = 0; i < segCount; ++i) {
            this.writeUint16(out, startCode[i]);
        }
        for (i = 0; i < segCount; ++i) {
            this.writeUint16(out, idDelta[i]);
        }
        for (i = 0; i < segCount; ++i) {
            this.writeUint16(out, 0);
        }
        return bos.toByteArray();
    }

    private byte[] buildPostTable() throws IOException {
        PostScriptTable post = this.ttf.getPostScript();
        if (post == null || this.keepTables != null && !this.keepTables.contains("post")) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.writeFixed(out, 2.0);
        this.writeFixed(out, post.getItalicAngle());
        this.writeSInt16(out, post.getUnderlinePosition());
        this.writeSInt16(out, post.getUnderlineThickness());
        this.writeUint32(out, post.getIsFixedPitch());
        this.writeUint32(out, post.getMinMemType42());
        this.writeUint32(out, post.getMaxMemType42());
        this.writeUint32(out, post.getMinMemType1());
        this.writeUint32(out, post.getMaxMemType1());
        this.writeUint16(out, this.glyphIds.size());
        TreeMap<String, Integer> names = new TreeMap<String, Integer>();
        Iterator<Object> i$ = this.glyphIds.iterator();
        while (i$.hasNext()) {
            int gid = (Integer)i$.next();
            String name = post.getName(gid);
            Integer macId = WGL4Names.MAC_GLYPH_NAMES_INDICES.get(name);
            if (macId != null) {
                this.writeUint16(out, macId);
                continue;
            }
            Integer ordinal = (Integer)names.get(name);
            if (ordinal == null) {
                ordinal = names.size();
                names.put(name, ordinal);
            }
            this.writeUint16(out, 258 + ordinal);
        }
        for (String name : names.keySet()) {
            byte[] buf = name.getBytes(Charset.forName("US-ASCII"));
            this.writeUint8(out, buf.length);
            out.write(buf);
        }
        out.flush();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] buildHmtxTable() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HorizontalHeaderTable h = this.ttf.getHorizontalHeader();
        HorizontalMetricsTable hm = this.ttf.getHorizontalMetrics();
        byte[] buf = new byte[4];
        InputStream is = this.ttf.getOriginalData();
        try {
            is.skip(hm.getOffset());
            long lastOff = 0L;
            for (Integer glyphId : this.glyphIds) {
                int n;
                long nskip;
                long off = glyphId < h.getNumberOfHMetrics() ? (long)(glyphId * 4) : (long)(h.getNumberOfHMetrics() * 4 + (glyphId - h.getNumberOfHMetrics()) * 2);
                if (off != lastOff && (nskip = off - lastOff) != is.skip(nskip)) {
                    throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
                }
                int n2 = n = glyphId < h.getNumberOfHMetrics() ? 4 : 2;
                if (n != is.read(buf, 0, n)) {
                    throw new EOFException("Unexpected EOF exception parsing glyphId of hmtx table.");
                }
                bos.write(buf, 0, n);
                lastOff = off + (long)n;
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToStream(OutputStream os) throws IOException {
        this.addCompoundReferences();
        DataOutputStream out = new DataOutputStream(os);
        try {
            long[] newLoca = new long[this.glyphIds.size() + 1];
            byte[] head = this.buildHeadTable();
            byte[] hhea = this.buildHheaTable();
            byte[] maxp = this.buildMaxpTable();
            byte[] name = this.buildNameTable();
            byte[] os2 = this.buildOS2Table();
            byte[] glyf = this.buildGlyfTable(newLoca);
            byte[] loca = this.buildLocaTable(newLoca);
            byte[] cmap = this.buildCmapTable();
            byte[] hmtx = this.buildHmtxTable();
            byte[] post = this.buildPostTable();
            TreeMap<String, byte[]> tables = new TreeMap<String, byte[]>();
            if (os2 != null) {
                tables.put("OS/2", os2);
            }
            if (cmap != null) {
                tables.put("cmap", cmap);
            }
            if (glyf != null) {
                tables.put("glyf", glyf);
            }
            tables.put("head", head);
            tables.put("hhea", hhea);
            tables.put("hmtx", hmtx);
            if (loca != null) {
                tables.put("loca", loca);
            }
            tables.put("maxp", maxp);
            if (name != null) {
                tables.put("name", name);
            }
            if (post != null) {
                tables.put("post", post);
            }
            for (Map.Entry<String, TTFTable> entry : this.ttf.getTableMap().entrySet()) {
                String tag = entry.getKey();
                TTFTable table = entry.getValue();
                if (tables.containsKey(tag) || this.keepTables != null && !this.keepTables.contains(tag)) continue;
                tables.put(tag, this.ttf.getTableBytes(table));
            }
            long checksum = this.writeFileHeader(out, tables.size());
            long offset = 12L + 16L * (long)tables.size();
            for (Map.Entry entry : tables.entrySet()) {
                checksum += this.writeTableHeader(out, (String)entry.getKey(), offset, (byte[])entry.getValue());
                offset += (long)((((byte[])entry.getValue()).length + 3) / 4 * 4);
            }
            checksum = 2981146554L - (checksum & 0xFFFFFFFFL);
            head[8] = (byte)(checksum >>> 24);
            head[9] = (byte)(checksum >>> 16);
            head[10] = (byte)(checksum >>> 8);
            head[11] = (byte)checksum;
            for (byte[] bytes : tables.values()) {
                this.writeTableBody(out, bytes);
            }
        }
        finally {
            out.close();
        }
    }

    private void writeFixed(DataOutputStream out, double f) throws IOException {
        double ip = Math.floor(f);
        double fp = (f - ip) * 65536.0;
        out.writeShort((int)ip);
        out.writeShort((int)fp);
    }

    private void writeUint32(DataOutputStream out, long l) throws IOException {
        out.writeInt((int)l);
    }

    private void writeUint16(DataOutputStream out, int i) throws IOException {
        out.writeShort(i);
    }

    private void writeSInt16(DataOutputStream out, short i) throws IOException {
        out.writeShort(i);
    }

    private void writeUint8(DataOutputStream out, int i) throws IOException {
        out.writeByte(i);
    }

    private void writeLongDateTime(DataOutputStream out, Calendar calendar) throws IOException {
        GregorianCalendar cal = new GregorianCalendar(1904, 0, 1);
        long millisFor1904 = cal.getTimeInMillis();
        long secondsSince1904 = (calendar.getTimeInMillis() - millisFor1904) / 1000L;
        out.writeLong(secondsSince1904);
    }

    private long toUInt32(int high, int low) {
        return ((long)high & 0xFFFFL) << 16 | (long)low & 0xFFFFL;
    }

    private long toUInt32(byte[] bytes) {
        return ((long)bytes[0] & 0xFFL) << 24 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[2] & 0xFFL) << 8 | (long)bytes[3] & 0xFFL;
    }

    private int log2(int num) {
        return (int)Math.round(Math.log(num) / Math.log(2.0));
    }
}

