/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import org.duckdb.DuckDBConnection;

public class DuckDBDriver
implements Driver {
    public static final String DUCKDB_READONLY_PROPERTY = "duckdb.read_only";
    public static final String DUCKDB_USER_AGENT_PROPERTY = "custom_user_agent";
    public static final String JDBC_STREAM_RESULTS = "jdbc_stream_results";

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        if (!this.acceptsURL(string)) {
            return null;
        }
        boolean bl = false;
        String string2 = (String)(properties = properties == null ? new Properties() : (Properties)properties.clone()).remove(DUCKDB_READONLY_PROPERTY);
        if (string2 != null) {
            String string3 = string2.trim().toLowerCase();
            bl = string3.equals("1") || string3.equals("true") || string3.equals("yes");
        }
        properties.put("duckdb_api", "jdbc");
        return DuckDBConnection.newConnection(string, bl, properties);
    }

    @Override
    public boolean acceptsURL(String string) throws SQLException {
        return string.startsWith("jdbc:duckdb:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        DriverPropertyInfo[] driverPropertyInfoArray = new DriverPropertyInfo[]{};
        return driverPropertyInfoArray;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("no logger");
    }

    static {
        try {
            DriverManager.registerDriver(new DuckDBDriver());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }
}

