/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.io.IOException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.dbforms.taglib.TagSupportWithScriptHandler;
import org.dbforms.util.MessageResources;

public class MessageTag
extends TagSupportWithScriptHandler
implements TryCatchFinally {
    private String key = null;
    private String param = null;

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setParam(String newParam) {
        this.param = newParam;
    }

    public String getParam() {
        return this.param;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        if (this.getKey() != null) {
            Locale locale = MessageResources.getLocale((HttpServletRequest)this.pageContext.getRequest());
            String message = this.param == null || this.param.length() == 0 ? MessageResources.getMessage(this.getKey(), locale) : MessageResources.getMessage(this.getKey(), locale, this.splitString(this.param, ","));
            try {
                if (message != null) {
                    this.pageContext.getOut().write(message);
                } else {
                    this.pageContext.getOut().write(this.getKey());
                    if (this.param != null) {
                        this.pageContext.getOut().write("&nbsp;");
                        this.pageContext.getOut().write(this.param);
                    }
                }
            }
            catch (IOException ioe) {
                throw new JspException("IO Error: " + ioe.getMessage());
            }
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.key = null;
        this.param = null;
    }

    public int doStartTag() throws JspException {
        return 0;
    }

    private String[] splitString(String str, String delimeter) {
        StringTokenizer st = new StringTokenizer(str, delimeter);
        int i = 0;
        String[] result = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            result[i] = st.nextToken();
            ++i;
        }
        return result;
    }
}

