/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.taglib;

import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.TryCatchFinally;
import java.sql.Connection;
import org.dbforms.taglib.TagSupportWithScriptHandler;
import org.dbforms.util.SqlUtil;

public class DbGetConnection
extends TagSupportWithScriptHandler
implements TryCatchFinally {
    private transient Connection conn;
    private String dbConnectionName;

    public void setConn(Connection connection) {
        this.conn = connection;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setDbConnectionName(String name) {
        this.dbConnectionName = name;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public int doEndTag() throws JspException {
        try {
            SqlUtil.closeConnection(this.getConn());
            this.setConn(null);
            this.pageContext.removeAttribute(this.getId(), 1);
        }
        catch (Exception e) {
            throw new JspException("Connection error" + e.getMessage());
        }
        return 6;
    }

    @Override
    public void doFinally() {
        this.dbConnectionName = null;
    }

    public int doStartTag() throws JspException {
        try {
            this.setConn(this.getConfig().getConnection(this.dbConnectionName));
            this.pageContext.setAttribute(this.getId(), (Object)this.getConn(), 1);
        }
        catch (Exception e) {
            throw new JspException("Connection error" + e.getMessage());
        }
        return 1;
    }
}

