/*
 * Decompiled with CFR 0.152.
 */
package org.dbforms.config;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dbforms.config.DbFormsConfig;
import org.dbforms.config.DbFormsErrors;
import org.dbforms.event.DatabaseEventFactoryImpl;
import org.dbforms.event.NavEventFactoryImpl;
import org.dbforms.util.SingletonClassFactoryCreate;
import org.xml.sax.SAXException;

public class ConfigLoader {
    public static final String BASE_CLASS_TABLE = "org.dbforms.config.Table";
    public static final String BASE_CLASS_FIELD = "org.dbforms.config.Field";
    public static final String BASE_CLASS_QUERY = "org.dbforms.config.Query";
    public static final String BASE_CLASS_FOREIGNKEY = "org.dbforms.config.ForeignKey";
    public static final String BASE_CLASS_REFERENCE = "org.dbforms.config.Reference";
    public static final String DEFAULT_CONFIG = "/WEB-INF/dbforms-config.xml";
    public static final String DEFAULT_ERRORS = "/WEB-INF/dbforms-errors.xml";
    public static final String DEFAULT_VALIDATION = "/WEB-INF/validation.xml";
    public static final String DEFAULT_RULES = "/WEB-INF/validator-rules.xml";
    private static Log logCat = LogFactory.getLog(ConfigLoader.class);
    private String config = "/WEB-INF/dbforms-config.xml";
    private String errors = "/WEB-INF/dbforms-errors.xml";
    private String fieldClassName = "org.dbforms.config.Field";
    private String foreignKeyClassName = "org.dbforms.config.ForeignKey";
    private String queryClassName = "org.dbforms.config.Query";
    private String referenceClassName = "org.dbforms.config.Reference";
    private String tableClassName = "org.dbforms.config.Table";
    private String validation = "/WEB-INF/validation.xml";
    private String validator_rules = "/WEB-INF/validator-rules.xml";

    public void setConfig(String config) {
        this.config = config != null ? config : DEFAULT_CONFIG;
    }

    public String getConfig() {
        return this.config;
    }

    public void setErrors(String errors) {
        this.errors = errors != null ? errors : DEFAULT_ERRORS;
    }

    public String getErrors() {
        return this.errors;
    }

    public void setFieldClassName(String className) {
        this.fieldClassName = className != null ? className : BASE_CLASS_FIELD;
    }

    public void setForeignKeyClassName(String className) {
        this.foreignKeyClassName = className != null ? className : BASE_CLASS_FOREIGNKEY;
    }

    public void setQueryClassName(String className) {
        this.queryClassName = className != null ? className : BASE_CLASS_QUERY;
    }

    public void setReferenceClassName(String className) {
        this.referenceClassName = className != null ? className : BASE_CLASS_REFERENCE;
    }

    public void setTableClassName(String className) {
        this.tableClassName = className != null ? className : BASE_CLASS_TABLE;
    }

    public void setValidation(String validation) {
        this.validation = validation != null ? validation : DEFAULT_VALIDATION;
    }

    public String getValidation() {
        return this.validation;
    }

    public void setValidatorRules(String validator_rules) {
        this.validator_rules = validator_rules != null ? validator_rules : DEFAULT_RULES;
    }

    public String getValidatorRules() {
        return this.validator_rules;
    }

    public void loadConfig(InputStream input, DbFormsConfig dbFormsConfig) throws IOException, SAXException {
        Digester digester = this.initDigester(dbFormsConfig);
        digester.parse(input);
    }

    public void loadErrors(InputStream input, DbFormsErrors dbFormsErrors) throws IOException, SAXException {
        Digester digester = this.initErrorsDigester(dbFormsErrors);
        digester.parse(input);
    }

    protected Digester initDigester(DbFormsConfig dbFormsConfig) {
        Digester digester = new Digester();
        digester.setLogger(LogFactory.getLog(Digester.class));
        digester.push((Object)dbFormsConfig);
        digester.setNamespaceAware(true);
        digester.setValidating(false);
        digester.addCallMethod("dbforms-config/DOMFactoryClass", "setDOMFactoryClass", 0);
        digester.addCallMethod("dbforms-config/DefaultEscaperClass", "setDefaultEscaperClass", 0);
        digester.addObjectCreate("dbforms-config/table", this.tableClassName);
        digester.addSetProperties("dbforms-config/table");
        digester.addSetNext("dbforms-config/table", "addTable", BASE_CLASS_TABLE);
        digester.addObjectCreate("dbforms-config/table/field", this.fieldClassName);
        digester.addSetProperties("dbforms-config/table/field");
        digester.addSetNext("dbforms-config/table/field", "addField", BASE_CLASS_FIELD);
        digester.addObjectCreate("dbforms-config/table/calc", this.fieldClassName);
        digester.addSetProperties("dbforms-config/table/calc");
        digester.addSetNext("dbforms-config/table/calc", "addCalcField", BASE_CLASS_FIELD);
        digester.addObjectCreate("dbforms-config/table/foreign-key", this.foreignKeyClassName);
        digester.addSetProperties("dbforms-config/table/foreign-key");
        digester.addSetNext("dbforms-config/table/foreign-key", "addForeignKey", BASE_CLASS_FOREIGNKEY);
        digester.addObjectCreate("dbforms-config/table/foreign-key/reference", this.referenceClassName);
        digester.addSetProperties("dbforms-config/table/foreign-key/reference");
        digester.addSetNext("dbforms-config/table/foreign-key/reference", "addReference", BASE_CLASS_REFERENCE);
        digester.addObjectCreate("dbforms-config/table/granted-privileges", "org.dbforms.config.GrantedPrivileges");
        digester.addSetProperties("dbforms-config/table/granted-privileges");
        digester.addSetNext("dbforms-config/table/granted-privileges", "setGrantedPrivileges", "org.dbforms.config.GrantedPrivileges");
        digester.addObjectCreate("dbforms-config/table/interceptor", "org.dbforms.config.Interceptor");
        digester.addSetProperties("dbforms-config/table/interceptor");
        digester.addSetNext("dbforms-config/table/interceptor", "addInterceptor", "org.dbforms.config.Interceptor");
        digester.addCallMethod("dbforms-config/table/interceptor/param", "addParam", 2);
        digester.addCallParam("dbforms-config/table/interceptor/param", 0, "name");
        digester.addCallParam("dbforms-config/table/interceptor/param", 1, "value");
        digester.addObjectCreate("dbforms-config/table/events", "org.dbforms.config.TableEvents");
        digester.addSetNext("dbforms-config/table/events", "setTableEvents", "org.dbforms.config.TableEvents");
        digester.addObjectCreate("dbforms-config/table/events/event", "org.dbforms.config.EventInfo");
        digester.addSetProperties("dbforms-config/table/events/event");
        digester.addSetNext("dbforms-config/table/events/event", "addEventInfo", "org.dbforms.config.EventInfo");
        digester.addObjectCreate("dbforms-config/table/events/event/property", "org.dbforms.config.DbConnectionProperty");
        digester.addSetProperties("dbforms-config/table/events/event/property");
        digester.addSetNext("dbforms-config/table/events/event/property", "addProperty", "org.dbforms.config.DbConnectionProperty");
        digester.addObjectCreate("dbforms-config/query", this.queryClassName);
        digester.addSetProperties("dbforms-config/query");
        digester.addSetNext("dbforms-config/query", "addTable", BASE_CLASS_TABLE);
        digester.addObjectCreate("dbforms-config/query/field", this.fieldClassName);
        digester.addSetProperties("dbforms-config/query/field");
        digester.addSetNext("dbforms-config/query/field", "addField", BASE_CLASS_FIELD);
        digester.addObjectCreate("dbforms-config/query/calc", this.fieldClassName);
        digester.addSetProperties("dbforms-config/query/calc");
        digester.addSetNext("dbforms-config/query/calc", "addCalcField", BASE_CLASS_FIELD);
        digester.addObjectCreate("dbforms-config/query/search", this.fieldClassName);
        digester.addSetProperties("dbforms-config/query/search");
        digester.addSetNext("dbforms-config/query/search", "addSearchField", BASE_CLASS_FIELD);
        digester.addObjectCreate("dbforms-config/query/foreign-key", this.foreignKeyClassName);
        digester.addSetProperties("dbforms-config/query/foreign-key");
        digester.addSetNext("dbforms-config/query/foreign-key", "addForeignKey", BASE_CLASS_FOREIGNKEY);
        digester.addObjectCreate("dbforms-config/query/foreign-key/reference", this.referenceClassName);
        digester.addSetProperties("dbforms-config/query/foreign-key/reference");
        digester.addSetNext("dbforms-config/query/foreign-key/reference", "addReference", BASE_CLASS_REFERENCE);
        digester.addObjectCreate("dbforms-config/query/granted-privileges", "org.dbforms.config.GrantedPrivileges");
        digester.addSetProperties("dbforms-config/query/granted-privileges");
        digester.addSetNext("dbforms-config/query/granted-privileges", "setGrantedPrivileges", "org.dbforms.config.GrantedPrivileges");
        digester.addObjectCreate("dbforms-config/query/interceptor", "org.dbforms.config.Interceptor");
        digester.addSetProperties("dbforms-config/query/interceptor");
        digester.addSetNext("dbforms-config/query/interceptor", "addInterceptor", "org.dbforms.config.Interceptor");
        digester.addCallMethod("dbforms-config/query/interceptor/param", "addParam", 2);
        digester.addCallParam("dbforms-config/query/interceptor/param", 0, "name");
        digester.addCallParam("dbforms-config/query/interceptor/param", 1, "value");
        digester.addObjectCreate("dbforms-config/query/events", "org.dbforms.config.TableEvents");
        digester.addSetNext("dbforms-config/query/events", "setTableEvents", "org.dbforms.config.TableEvents");
        digester.addObjectCreate("dbforms-config/query/events/event", "org.dbforms.config.EventInfo");
        digester.addSetProperties("dbforms-config/query/events/event");
        digester.addSetNext("dbforms-config/query/events/event", "addEventInfo", "org.dbforms.config.EventInfo");
        digester.addObjectCreate("dbforms-config/query/events/event/property", "org.dbforms.config.DbConnectionProperty");
        digester.addSetProperties("dbforms-config/query/events/event/property");
        digester.addSetNext("dbforms-config/query/events/event/property", "addProperty", "org.dbforms.config.DbConnectionProperty");
        digester.addObjectCreate("dbforms-config/dbconnection", "org.dbforms.config.DbConnection");
        digester.addSetProperties("dbforms-config/dbconnection");
        digester.addSetNext("dbforms-config/dbconnection", "addDbConnection", "org.dbforms.config.DbConnection");
        digester.addObjectCreate("dbforms-config/dbconnection/property", "org.dbforms.config.DbConnectionProperty");
        digester.addSetProperties("dbforms-config/dbconnection/property");
        digester.addSetNext("dbforms-config/dbconnection/property", "addProperty", "org.dbforms.config.DbConnectionProperty");
        digester.addObjectCreate("dbforms-config/dbconnection/pool-property", "org.dbforms.config.DbConnectionProperty");
        digester.addSetProperties("dbforms-config/dbconnection/pool-property");
        digester.addSetNext("dbforms-config/dbconnection/pool-property", "addPoolProperty", "org.dbforms.config.DbConnectionProperty");
        digester.addObjectCreate("dbforms-config/interceptors/interceptor", "org.dbforms.config.Interceptor");
        digester.addSetProperties("dbforms-config/interceptors/interceptor");
        digester.addSetNext("dbforms-config/interceptors/interceptor", "addInterceptor", "org.dbforms.config.Interceptor");
        digester.addCallMethod("dbforms-config/interceptors/interceptor/param", "addParam", 2);
        digester.addCallParam("dbforms-config/interceptors/interceptor/param", 0, "name");
        digester.addCallParam("dbforms-config/interceptors/interceptor/param", 1, "value");
        digester.addFactoryCreate("dbforms-config/events/database-events", (ObjectCreationFactory)new SingletonClassFactoryCreate(DatabaseEventFactoryImpl.class.getName()));
        digester.addObjectCreate("dbforms-config/events/database-events/database-event", "org.dbforms.config.EventInfo");
        digester.addSetProperties("dbforms-config/events/database-events/database-event");
        digester.addSetNext("dbforms-config/events/database-events/database-event", "addEventInfo", "org.dbforms.config.EventInfo");
        digester.addFactoryCreate("dbforms-config/events/navigation-events", (ObjectCreationFactory)new SingletonClassFactoryCreate(NavEventFactoryImpl.class.getName()));
        digester.addObjectCreate("dbforms-config/events/navigation-events/navigation-event", "org.dbforms.config.EventInfo");
        digester.addSetProperties("dbforms-config/events/navigation-events/navigation-event");
        digester.addSetNext("dbforms-config/events/navigation-events/navigation-event", "addEventInfo", "org.dbforms.config.EventInfo");
        return digester;
    }

    protected Digester initErrorsDigester(DbFormsErrors dbFormsErrors) {
        logCat.info((Object)"initialize Errors Digester.");
        Digester digester = new Digester();
        digester.setLogger(LogFactory.getLog(Digester.class));
        digester.push((Object)dbFormsErrors);
        digester.setValidating(false);
        digester.addObjectCreate("dbforms-errors/error", "org.dbforms.config.Error");
        digester.addSetProperties("dbforms-errors/error");
        digester.addSetNext("dbforms-errors/error", "addError", "org.dbforms.config.Error");
        digester.addObjectCreate("dbforms-errors/error/message", "org.dbforms.config.Message");
        digester.addSetNext("dbforms-errors/error/message", "addMessage", "org.dbforms.config.Message");
        digester.addSetProperties("dbforms-errors/error/message");
        digester.addCallMethod("dbforms-errors/error/message", "setMessage", 0);
        return digester;
    }
}

