/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor.wizard;

import de.destatis.core.map.editor.wizard.AbstractStep;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class SelectResourceStorageStep
extends AbstractStep {
    private JRadioButton localResourceStorageRadioButton;
    private JRadioButton serverResourceStorageRadioButton;
    private boolean isSurvey;

    public SelectResourceStorageStep(boolean isSurvey) {
        super(new GridBagLayout());
        this.isSurvey = isSurvey;
        this.localResourceStorageRadioButton = new JRadioButton("<html>" + (this.isSurvey ? "Erhebungsbeschreibung" : "Metadatenbeschreibung") + " aus der Liste der lokal gespeicherten " + (this.isSurvey ? "Erhebungen" : "Metadatenbeschreibungen") + " ausw\u00e4hlen.</html>");
        this.localResourceStorageRadioButton.setVerticalTextPosition(1);
        this.localResourceStorageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectResourceStorageStep.this.fireStateChanged();
            }
        });
        this.localResourceStorageRadioButton.setSelected(true);
        this.serverResourceStorageRadioButton = new JRadioButton("<html>" + (this.isSurvey ? "Erhebungsbeschreibung aus der Liste der vom CORE.server bereit gestellten Erhebungen ausw\u00e4hlen und ggf. herunterladen." : "Manuelle Auswahl der DatML/RAW-Version und ggf. Herunterladen der entsprechenden Metadatenbeschreibung vom CORE.server.") + "</html>");
        this.serverResourceStorageRadioButton.setVerticalTextPosition(1);
        this.serverResourceStorageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectResourceStorageStep.this.fireStateChanged();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.localResourceStorageRadioButton);
        buttonGroup.add(this.serverResourceStorageRadioButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        this.add((Component)this.localResourceStorageRadioButton, gbc);
        ++gbc.gridy;
        this.add((Component)this.serverResourceStorageRadioButton, gbc);
    }

    public boolean isLocalResourceStorageSelected() {
        return this.localResourceStorageRadioButton.isSelected();
    }

    public boolean isServerResourceStorageSelected() {
        return this.serverResourceStorageRadioButton.isSelected();
    }

    @Override
    public String getTitle() {
        return "Ressourcen";
    }

    @Override
    public String getInfo() {
        return "W\u00e4hlen Sie bitte aus, welche Ressourcen zur Auswahl bereit gestellt werden sollen.";
    }

    @Override
    public boolean isComplete() {
        return this.localResourceStorageRadioButton.isSelected() || this.serverResourceStorageRadioButton.isSelected();
    }
}

