/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.map.editor;

import de.destatis.core.map.editor.PropertiesIfc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class PreviewDialog
extends JDialog {
    private static final String PROP_LAST_FILE = new String("editor.previewDialog.lastHtmlFile");
    private static final String PROP_WIDTH = new String("editor.previewDialog.width");
    private static final String PROP_HEIGHT = new String("editor.previewDialog.height");
    private static final String PROP_LEFT = new String("editor.previewDialog.left");
    private static final String PROP_TOP = new String("editor.previewDialog.top");
    private String html;
    private JEditorPane content;
    private JButton close;
    private JFileChooser fileChooser;
    private PropertiesIfc properties;

    public PreviewDialog(Frame parent, PropertiesIfc properties) {
        super(parent, "Tabellenvorschau", true);
        int top;
        int left;
        int height;
        int width;
        if (properties == null) {
            throw new IllegalArgumentException("properties ist erforderlich");
        }
        this.properties = properties;
        this.content = new JEditorPane(){

            @Override
            public void scrollRectToVisible(Rectangle aRect) {
            }
        };
        this.content.setEditable(false);
        this.content.setFocusable(false);
        this.content.setContentType("text/html");
        JScrollPane scrollPane = new JScrollPane(this.content);
        scrollPane.getViewport().setBackground(Color.white);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 1;
        panel.add((Component)scrollPane, gbc);
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        gbc.anchor = 10;
        gbc.fill = 2;
        gbc.insets.top = 10;
        gbc.insets.bottom = 10;
        panel.add(this.createButtonComponent(), gbc);
        this.getContentPane().add((Component)panel, "Center");
        this.getRootPane().setDefaultButton(this.close);
        try {
            width = Integer.parseInt(this.properties.getProperty(PROP_WIDTH, "800"));
        }
        catch (NumberFormatException e) {
            width = 800;
        }
        try {
            height = Integer.parseInt(this.properties.getProperty(PROP_HEIGHT, "400"));
        }
        catch (NumberFormatException e) {
            height = 400;
        }
        try {
            left = Integer.parseInt(this.properties.getProperty(PROP_LEFT, "0"));
        }
        catch (NumberFormatException e) {
            left = 0;
        }
        try {
            top = Integer.parseInt(this.properties.getProperty(PROP_TOP, "0"));
        }
        catch (NumberFormatException e) {
            top = 0;
        }
        this.setLocation(left, top);
        this.setSize(width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.isVisible()) {
            this.properties.setProperty(PROP_WIDTH, String.valueOf(this.getWidth()));
            this.properties.setProperty(PROP_HEIGHT, String.valueOf(this.getHeight()));
            this.properties.setProperty(PROP_LEFT, String.valueOf(this.getX()));
            this.properties.setProperty(PROP_TOP, String.valueOf(this.getY()));
            this.html = null;
            this.content.setText("");
        }
        super.setVisible(visible);
    }

    private Component createButtonComponent() {
        JButton save = new JButton("Speichern ...");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.save();
            }
        });
        this.close = new JButton("Schlie\u00dfen");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewDialog.this.close();
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets.left = 10;
        gbc.insets.right = 10;
        panel.add((Component)save, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 0;
        panel.add((Component)this.close, gbc);
        return panel;
    }

    public void setHtml(String html) {
        this.html = html;
        this.content.setText(this.html);
    }

    private void close() {
        this.setVisible(false);
    }

    private void save() {
        int rc;
        if (this.fileChooser == null) {
            File file;
            File directory;
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file != null && (file.isDirectory() || file.isFile() && file.getName().toLowerCase().endsWith(".html"));
                }

                @Override
                public String getDescription() {
                    return "HTML-Dateien (*.html)";
                }
            });
            String lastHtmlFilePath = this.properties.getProperty(PROP_LAST_FILE);
            if (lastHtmlFilePath != null && lastHtmlFilePath.trim().length() > 0 && (directory = (file = new File(lastHtmlFilePath)).getParentFile()) != null && directory.isDirectory()) {
                this.fileChooser.setCurrentDirectory(directory);
                this.fileChooser.revalidate();
            }
        }
        if ((rc = this.fileChooser.showSaveDialog(this)) == 0) {
            File selectedFile = this.fileChooser.getSelectedFile();
            String filePath = selectedFile.getAbsolutePath().replace('\\', '/');
            this.properties.setProperty(PROP_LAST_FILE, filePath);
            boolean shouldSave = true;
            if (selectedFile.exists()) {
                rc = JOptionPane.showConfirmDialog(this, "Die Datei \"" + selectedFile.getAbsolutePath() + "\" existiert bereits.\n" + "Soll die Datei \u00fcberschrieben werden?", "Achtung", 1, 2);
                boolean bl = shouldSave = rc == 0;
            }
            if (shouldSave) {
                try {
                    this.save(selectedFile);
                    JOptionPane.showMessageDialog(this, "Die Vorschau wurde erfolgreich gespeichert.", "Hinweis", 1);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this, "Beim Speichern ist ein Fehler aufgetreten:\n" + e.toString(), "Fehler", 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File file) throws IOException {
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fOut));
            writer.write(this.html);
            ((Writer)writer).close();
            fOut = null;
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

