/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.generator.generation;

import de.destatis.core.generator.generation.ConditionInfo;
import de.statspez.sdf.generator.meta.MetaCustomSDFBedingung;
import de.statspez.sdf.generator.meta.SDFElement;
import de.statspez.sdf.generator.meta.SDFElementVisitor;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegung;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaAuspraegungsgruppeComps;
import de.statspez.sdf.generator.meta.generated.MetaErhebungsbeschreibung;
import de.statspez.sdf.generator.meta.generated.MetaMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabegruppe;
import de.statspez.sdf.generator.meta.generated.MetaSDFAusgabesatz;
import de.statspez.sdf.generator.meta.generated.MetaSDFBedingung;
import de.statspez.sdf.generator.meta.generated.MetaSDFFeldReferenz;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmal;
import de.statspez.sdf.generator.meta.generated.MetaSDFMerkmalsgruppe;
import de.statspez.sdf.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.sdf.generator.util.SDFUtil;
import de.werum.sis.meta.ElementVisitorInterface;
import de.werum.sis.meta.MetaElementInterface;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public class CollectConditionInfoTraverser
implements SDFElementVisitor {
    private MetaSDFAusgabegruppe ausgabegruppe;
    private Map fieldConditions;
    protected Stack mmgrStack;

    public CollectConditionInfoTraverser(MetaSDFAusgabegruppe ausgabegruppe) {
        this.ausgabegruppe = ausgabegruppe;
        this.mmgrStack = new Stack();
    }

    public Map collectConditionInfo() {
        this.fieldConditions = new HashMap();
        this.ausgabegruppe.accept((ElementVisitorInterface)this);
        return this.fieldConditions;
    }

    public void visitAuspraegung(MetaAuspraegung arg0) {
    }

    public void visitAuspraegungsgruppe(MetaAuspraegungsgruppe arg0) {
    }

    public void visitAuspraegungsgruppeComps(MetaAuspraegungsgruppeComps arg0) {
    }

    public void visitErhebungsbeschreibung(MetaErhebungsbeschreibung arg0) {
    }

    public void visitMerkmal(MetaMerkmal arg0) {
    }

    public void visitSDFAusgabesatz(MetaSDFAusgabesatz arg0) {
    }

    public void visitSDFAusgabegruppe(MetaSDFAusgabegruppe ausgabegruppe) {
        Iterator conditions = ausgabegruppe.getSDFBedingungen();
        if (conditions != null) {
            while (conditions.hasNext()) {
                MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                String bezugsfeld = SDFUtil.getReferenceField((Iterator)condition.getBezugsfeld());
                ConditionInfo conditionInfo = new ConditionInfo(condition, (SDFElement)ausgabegruppe);
                this.fieldConditions.put(bezugsfeld, conditionInfo);
            }
        }
        this.visitElements(ausgabegruppe.getSDFFeldReferenzen());
    }

    public void visitSDFFeldReferenz(MetaSDFFeldReferenz feldReferenz) {
        if (feldReferenz.getArt() == 2) {
            MetaStatspezObjekt klasse = feldReferenz.getKlasse();
            klasse.accept((ElementVisitorInterface)this);
        }
    }

    public void visitSDFMerkmal(MetaSDFMerkmal arg0) {
    }

    public void visitSDFMerkmalsgruppe(MetaSDFMerkmalsgruppe merkmalsgruppe) {
        Iterator conditions = merkmalsgruppe.getSDFBedingungen();
        if (conditions != null) {
            while (conditions.hasNext()) {
                MetaCustomSDFBedingung condition = (MetaCustomSDFBedingung)conditions.next();
                String bezugsfeld = SDFUtil.getReferenceField((Iterator)condition.getBezugsfeld());
                String stackPath = this.getMmgrHierarchy();
                StringBuffer fieldPath = new StringBuffer(stackPath.length() + merkmalsgruppe.getName().length() + ".".length() + bezugsfeld.length());
                if (stackPath.length() > 0) {
                    fieldPath.append(stackPath);
                }
                fieldPath.append(merkmalsgruppe.getName());
                fieldPath.append(".");
                fieldPath.append(bezugsfeld);
                String fieldPathStr = fieldPath.toString();
                if (this.fieldConditions.containsKey(fieldPathStr)) continue;
                ConditionInfo conditionInfo = new ConditionInfo(condition, (SDFElement)merkmalsgruppe);
                this.fieldConditions.put(fieldPathStr, conditionInfo);
            }
        }
        this.mmgrStack.push(merkmalsgruppe);
        this.visitElements(merkmalsgruppe.getSDFFeldReferenzen());
        this.mmgrStack.pop();
    }

    public void visitSDFBedingung(MetaSDFBedingung arg0) {
    }

    protected String getMmgrHierarchy() {
        StringBuffer buffer = new StringBuffer();
        int len = this.mmgrStack.size();
        for (int i = 0; i < len; ++i) {
            buffer.append(((MetaSDFMerkmalsgruppe)this.mmgrStack.get(i)).getName());
            buffer.append(".");
        }
        return buffer.toString();
    }

    protected void visitElements(Iterator it) {
        while (it.hasNext()) {
            MetaElementInterface e = (MetaElementInterface)it.next();
            if (e == null) continue;
            e.accept((ElementVisitorInterface)this);
        }
    }
}

