/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect.transfer.https;

import de.destatis.core.connect.CheckDeliveryRequest;
import de.destatis.core.connect.InspectionLevel;
import de.destatis.core.connect.Request;
import de.destatis.core.connect.Response;
import de.destatis.core.connect.ResponseStatus;
import de.destatis.core.connect.ResponseToCheckDeliveryRequest;
import de.destatis.core.connect.document.DatMLResDocument;
import de.destatis.core.connect.document.DocumentSource;
import de.destatis.core.connect.document.ValidationException;
import de.destatis.core.connect.transfer.https.ConnectInputStreamBody;
import de.destatis.core.connect.transfer.https.HttpsRequestHandler;
import de.destatis.core.connect.util.ClientConfig;
import de.destatis.core.connect.util.ClientLogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.HttpResponse;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class HttpsCheckDeliveryRequestHandler
extends HttpsRequestHandler {
    private static final ClientLogger LOG = ClientLogger.getLogger(HttpsCheckDeliveryRequestHandler.class);

    public HttpsCheckDeliveryRequestHandler(Request request, ClientConfig config) {
        super(request, config);
    }

    @Override
    public String getActionValue() {
        return "check_delivery_connect";
    }

    @Override
    public void addParts(Map<String, ContentBody> partList) {
        InputStream bodyIn;
        LOG.debug("enter addParts()");
        boolean compression = false;
        CheckDeliveryRequest checkDeliveryReq = (CheckDeliveryRequest)this.getRequest();
        InspectionLevel inspectionLevel = checkDeliveryReq.getInspectionLevel();
        if (inspectionLevel != null) {
            String inspectionLevelConnect;
            if (InspectionLevel.SYNTAX.equals((Object)inspectionLevel)) {
                inspectionLevelConnect = "syntax";
            } else if (InspectionLevel.SEMANTICS.equals((Object)inspectionLevel)) {
                inspectionLevelConnect = "semantics";
            } else if (InspectionLevel.AUTHORIZATION.equals((Object)inspectionLevel)) {
                inspectionLevelConnect = "authorization";
            } else if (InspectionLevel.DATA.equals((Object)inspectionLevel)) {
                inspectionLevelConnect = "data";
            } else {
                throw new IllegalStateException("Unbekannte Pr\u00fcfstufe:" + (Object)((Object)inspectionLevel));
            }
            LOG.trace("inspection_level=" + inspectionLevelConnect);
            try {
                partList.put("inspection_level", (ContentBody)new StringBody(inspectionLevelConnect));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        DocumentSource docSource = checkDeliveryReq.getData().getDocumentSource();
        String fileName = checkDeliveryReq.getFileName() == null ? "connect-datmlraw.xml" : checkDeliveryReq.getFileName();
        long length = docSource.getLength();
        LOG.trace("Anzahl zu sendender Bytes: " + length);
        if (!this.getConfig().isCompressionNone()) {
            LOG.trace("Das DatML/RAW-Dokument wird komprimiert uebertragen");
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            BufferedInputStream in = null;
            try {
                DeflaterOutputStream zipStream;
                in = new BufferedInputStream(docSource.getInputStream());
                if (this.getConfig().isCompressionGZIP()) {
                    LOG.trace("GZIP-Komprimierung");
                    zipStream = new GZIPOutputStream(outStream);
                } else {
                    LOG.trace("ZIP-Komprimierung");
                    zipStream = new DeflaterOutputStream(outStream);
                }
                compression = true;
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)in).read(buffer)) > 0) {
                    zipStream.write(buffer, 0, len);
                }
                zipStream.close();
                try {
                    ((InputStream)in).close();
                    in = null;
                }
                catch (IOException e) {
                    LOG.error("Fehler beim Schliessen des InputStreams der DocumentSource.", e);
                }
                byte[] zippedBytes = outStream.toByteArray();
                length = zippedBytes.length;
                LOG.trace("Laenge der komprimierten Daten: " + length);
                bodyIn = new BufferedInputStream(new ByteArrayInputStream(zippedBytes));
            }
            catch (IOException exc) {
                LOG.error("Fehler beim Erstellen des Deflater-Streams:", exc);
                throw new RuntimeException(exc);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        LOG.trace("Keine komprimierte Uebertragung des DatML/RAW-Dokuments");
        bodyIn = docSource.getInputStream();
        LOG.trace("file=<DatML/RAW-Dokument>");
        String transferEncoding = null;
        if (compression) {
            if (this.getConfig().isCompressionZIP()) {
                LOG.trace("TransferEncoding auf deflate gesetzt");
                transferEncoding = "deflate";
            } else if (this.getConfig().isCompressionGZIP()) {
                LOG.trace("TransferEncoding auf gzip gesetzt");
                transferEncoding = "gzip";
            }
        }
        ConnectInputStreamBody filePart = new ConnectInputStreamBody(bodyIn, "text/xml; charset=" + docSource.getEncoding(), fileName, transferEncoding);
        partList.put("file", (ContentBody)filePart);
    }

    @Override
    public Response getResponse(HttpResponse httpResponse) {
        LOG.trace("enter getResponse()");
        ResponseToCheckDeliveryRequest response = null;
        ResponseStatus responseStatus = this.getResponseStatus(httpResponse);
        if (responseStatus.equals(ResponseStatus.OK)) {
            String responseBody = this.getResponseBody(httpResponse);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Anfrage wurde fehlerfrei verarbeitet");
                LOG.trace("Zurueckgelieferter Inhalt:");
                LOG.trace(responseBody);
            }
            DatMLResDocument document = null;
            if (responseBody != null && responseBody.length() > 0) {
                document = new DatMLResDocument();
                try {
                    document.setDocument(responseBody);
                }
                catch (ValidationException exc) {
                    LOG.error("Fehlerhaftes DatML/RES-Dokument geliefert bekommen", exc);
                    response = new ResponseToCheckDeliveryRequest(ResponseStatus.BAD_RESPONSE, exc.getMessage(), null);
                }
            } else {
                response = new ResponseToCheckDeliveryRequest(ResponseStatus.BAD_RESPONSE, "Antwort vom Server enth\u00e4lt keine Protokolldaten.", null);
            }
            if (response == null) {
                response = new ResponseToCheckDeliveryRequest(responseStatus, null, document);
            }
        } else {
            String errorMsg = this.getResponseBody(httpResponse);
            response = new ResponseToCheckDeliveryRequest(responseStatus, errorMsg, null);
        }
        return response;
    }
}

