/*
 * Decompiled with CFR 0.152.
 */
package de.destatis.core.connect;

import de.destatis.core.connect.IncompleteRequestException;
import de.destatis.core.connect.Request;
import de.destatis.core.connect.transfer.CoreCommunicationInterface;
import de.destatis.core.connect.util.Converter;
import de.destatis.core.resource.ResourceType;

public abstract class GetSurveyResourceRequest
extends Request {
    protected String statId;
    protected String collector;
    protected String referencePeriod;
    protected String currentResourceId;

    public GetSurveyResourceRequest(String statId, String collector, String year, String interpreter, String period, String currentResourceId) throws IllegalArgumentException {
        this(statId, collector, Converter.convertBzrToTimeId(year, interpreter, period), currentResourceId);
    }

    public GetSurveyResourceRequest(String statId, String collector, String referencePeriod, String currentResourceId) {
        this.statId = statId;
        this.collector = collector;
        this.referencePeriod = referencePeriod;
        this.currentResourceId = currentResourceId;
    }

    public String getStatId() {
        return this.statId;
    }

    public String getCollector() {
        return this.collector;
    }

    public String getReferencePeriod() {
        return this.referencePeriod;
    }

    public String getCurrentResourceId() {
        return this.currentResourceId;
    }

    @Override
    public void check() throws IncompleteRequestException {
        ResourceType resourceType = this.getResourceType();
        if (resourceType == null) {
            throw new IncompleteRequestException("Kein Ressourcetyp angegeben.");
        }
        CoreCommunicationInterface.checkStatisticID(this.statId);
        CoreCommunicationInterface.checkCollector(this.collector);
        CoreCommunicationInterface.checkReferencePeriod(this.referencePeriod);
        CoreCommunicationInterface.checkResourceID(this.currentResourceId);
    }

    public abstract ResourceType getResourceType();
}

