/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.DateUtils;
import de.superx.common.Field;
import de.superx.common.Maske;
import de.superx.common.SxResultRow;
import de.superx.common.SxUser;
import de.superx.servlet.SxPools;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class SxJasperDataSource
implements JRDataSource {
    private Maske maske;
    private String mandantenID;
    private int index = -1;
    private List headerCaptions;
    private Iterator it;
    private SxResultRow row;
    private SxUser user;
    private Locale desiredLocale;
    private static final String[] captionIds = new String[]{"REPORT_HEADING_INSTITUTION", "REPORT_HEADING_URL", "REPORT_LOGO_FILE", "REPORT_HEADING_ADRESS", "REPORT_EMAIL", "REPORT_DOCUMENTATION_URL"};

    SxJasperDataSource(String mandantenID, Locale desiredLocale, SxUser user, Maske maske) {
        this.mandantenID = mandantenID;
        this.desiredLocale = desiredLocale;
        this.user = user;
        this.maske = maske;
        this.headerCaptions = maske.getHeaderCaptionList(true);
        this.it = maske.getResult_el().getResultSet().iterator();
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.it.hasNext()) {
            this.row = (SxResultRow)this.it.next();
        }
        return this.it.hasNext() || this.index < this.maske.getResult_el().getResultSet().size();
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        String fieldName = field.getName();
        value = fieldName.equals("Berichtsname") ? this.maske.getName() : (fieldName.equalsIgnoreCase("Erlaeuterung") ? this.maske.getExplanation() : (fieldName.equalsIgnoreCase("Hinweis") ? this.maske.getHinweis() : (fieldName.equalsIgnoreCase("standdatum") ? this.maske.getStandString() : (fieldName.equalsIgnoreCase("user") ? this.user.getName() : (fieldName.startsWith("legende_") && fieldName.endsWith("_value") ? this.getLegendFieldValue(fieldName) : (fieldName.startsWith("legende_") && fieldName.endsWith("_label") ? this.getLegendFieldLabel(fieldName) : (this.isSxCaptionsField(fieldName) ? this.getSxCaption(fieldName) : this.getVal(fieldName))))))));
        if (value instanceof Short) {
            value = new Integer(((Short)value).intValue());
        }
        if (value instanceof BigDecimal) {
            value = new Double(((BigDecimal)value).doubleValue());
        }
        if (value instanceof Date) {
            value = DateUtils.format((java.sql.Date)value);
        }
        if (value instanceof java.sql.Date) {
            value = DateUtils.format((java.sql.Date)value);
        }
        return value;
    }

    private String getSxCaption(String fieldName) {
        return SxPools.get(this.mandantenID).getTranslationShort(fieldName, this.desiredLocale);
    }

    private boolean isSxCaptionsField(String fieldName) {
        boolean result = false;
        int i2 = 0;
        while (i2 < captionIds.length) {
            if (fieldName.equals(captionIds[i2])) {
                result = true;
                break;
            }
            ++i2;
        }
        return result;
    }

    private int getColNo(String fieldName) {
        int col = -1;
        int i2 = 0;
        while (i2 < this.headerCaptions.size()) {
            if (this.headerCaptions.get(i2).toString().equals(fieldName)) {
                col = i2;
                break;
            }
            ++i2;
        }
        return col;
    }

    private Object getVal(String fieldName) {
        Object result = null;
        int colno = this.getColNo(fieldName);
        if (colno <= -1) {
            throw new IllegalArgumentException("JasperReport-Feld " + fieldName + " wurde nicht im Ergebnis der Maske gefunden");
        }
        result = this.row.get(colno);
        if (result != null && result.equals("")) {
            result = null;
        }
        return result;
    }

    private String getLegendFieldValue(String fieldName) {
        String result = "";
        int pos = fieldName.indexOf("_value");
        Field f2 = this.maske.getField(fieldName.substring(8, pos));
        try {
            result = f2.getSelectedKeyValueCaption();
        }
        catch (ParseException e2) {
            e2.printStackTrace();
            throw new IllegalArgumentException("Ung\u00fcltiger wert f\u00fcr Feld " + f2.getName() + "(" + f2.getSelectedKey() + ")");
        }
        if (result == null) {
            System.out.println("Warnung: JasperReport-Legende-Wert " + fieldName.substring(7, pos) + " wurde nicht im Ergebnis der Maske gefunden");
        }
        return result;
    }

    private String getLegendFieldLabel(String fieldName) {
        String result = "";
        int pos = fieldName.indexOf("_label");
        Field f2 = this.maske.getField(fieldName.substring(8, pos));
        result = f2.getName();
        if (f2.getCaptionShort() != null && !f2.getCaptionShort().equals("")) {
            result = f2.getCaptionShort();
        }
        if (result == null) {
            System.out.println("Warnung: JasperReport-Legende-Label " + fieldName.substring(7, pos) + " wurde nicht im Ergebnis der Maske gefunden");
        }
        return result;
    }
}

