/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.TreeUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.Field;
import de.superx.common.SelectableItemNode;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FieldXmlEncoder {
    public static String toXml(Field f2, boolean isFullXMLRequired, int rownr) {
        StringBuffer result = new StringBuffer("<feld " + FieldXmlEncoder.dynamic(f2) + ">\n");
        result.append(FieldXmlEncoder.getBasics(f2));
        FieldXmlEncoder.appendSichtgruppe(f2, result);
        FieldXmlEncoder.appendRelation(f2, isFullXMLRequired, result);
        result.append("<rownr>" + rownr + "</rownr>\n");
        result.append("</feld>\n");
        return result.toString();
    }

    private static String dynamic(Field f2) {
        String result = " isDynamic=\"false\"";
        if (f2.isDynamic()) {
            result = " isDynamic=\"true\"";
        }
        return result;
    }

    public static String toXml(Field f2, String param) {
        if (param == null) {
            throw new IllegalArgumentException("Param null");
        }
        StringBuffer result = new StringBuffer();
        if (param.equalsIgnoreCase("!all")) {
            result.append(FieldXmlEncoder.toXml(f2, true, 0));
        } else {
            result.append("<feld " + FieldXmlEncoder.dynamic(f2) + ">\n<relation>");
            if (!f2.getSelectableItemsTree().containsItemWithId(param)) {
                throw new IllegalArgumentException("Im Feld " + f2.getName() + " (" + f2.getId() + ") gibt es kein Element " + param);
            }
            SelectableItemNode startnode = f2.getSelectableItemsTree().getById(param);
            Enumeration<TreeNode> en = startnode.children();
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                node.toXml(f2.getArt() == 9, result);
            }
            result.append("\n</relation>\n</feld>");
        }
        return result.toString();
    }

    private static void appendRelation(Field f2, boolean isFullXMLRequired, StringBuffer result) {
        result.append("  <relation>\n");
        if (isFullXMLRequired || f2.getArt() != 12 && (f2.getArt() != 1 || f2.getZeilenanzahl() <= 1 && !f2.isDynamic())) {
            int maxLevel = -1;
            if (f2.getSichtgruppe() != null && f2.getSichtgruppe().getSelectedSicht().getXmlMaxEntries() != null) {
                maxLevel = TreeUtils.getMaxLevel(f2.getSelectableItemsTree().getRoot(), f2.getSichtgruppe().getSelectedSicht().getXmlMaxEntries());
            }
            Enumeration<TreeNode> en = f2.getSelectableItemsTree().getRoot().preorderEnumeration();
            while (en.hasMoreElements()) {
                TreeNode anode = en.nextElement();
                SelectableItemNode node = (SelectableItemNode)anode;
                if (!FieldXmlEncoder.isNodeWanted(f2, node, maxLevel)) continue;
                node.toXml(f2.getArt() == 9, result);
            }
        } else {
            result.append("<!-- wegen dynamischen Nachladens der Eintr\u00e4ge per Ajax(dojo) werden Einzelitems nicht ausgegeben-->\n");
        }
        result.append("  </relation>\n");
        if (f2.getDefaultValue() != null) {
            String name = f2.getDefaultValue().getName().toString();
            if (f2.getTyp().equals("date") && f2.getArt() == 0) {
                if (name.startsWith("'")) {
                    name = name.substring(1);
                }
                if (name.endsWith("'")) {
                    name = name.substring(0, name.length() - 1);
                }
            }
            result.append("<defaultwert><key><![CDATA[" + f2.getDefaultValue().getId() + "]]></key><name><![CDATA[" + name + "]]></name></defaultwert>\n");
        }
    }

    private static boolean isNodeWanted(Field f2, SelectableItemNode node, int maxLevel) {
        boolean dummy = true;
        boolean isWanted = true;
        if (node.isRoot() || node.isTemporary()) {
            isWanted = false;
        }
        if (isWanted && f2.getSichtgruppe() != null) {
            AbstractSicht sicht = f2.getSichtgruppe().getSelectedSicht();
            if (maxLevel > -1 && node.getLevel() > maxLevel) {
                isWanted = false;
            }
            if (isWanted && sicht.isAltHier() && !sicht.isVisible(new TreePath(node.getPath()))) {
                isWanted = false;
            }
        }
        return isWanted;
    }

    private static void appendSichtgruppe(Field f2, StringBuffer result) {
        if (f2.isOldOrganigrammArt() || f2.isSicht()) {
            if (f2.getSichtgruppe() == null) {
                throw new IllegalStateException("Kann Feld " + f2.getName() + "(" + f2.getId() + ") nicht als XML darstellen, solange variable sichtgruppe null ist");
            }
            result.append(f2.getSichtgruppe().toXml(f2.isOldOrganigrammArt()));
        }
    }

    private static StringBuffer getBasics(Field f2) {
        StringBuffer result = new StringBuffer("");
        result.append("  <tid>" + f2.getId() + "</tid>\n");
        result.append("  <name>" + f2.getName() + "</name>\n");
        if (f2.getCaptionShort() != null) {
            result.append("  <caption_short>" + f2.getCaptionShort() + "</caption_short>\n");
        }
        if (f2.getCaptionLong() != null) {
            result.append("  <caption_long><![CDATA[");
            if (f2.getCaptionLong() != null && f2.getCaptionLong().startsWith("<html>")) {
                result.append(f2.getCaptionLong().substring(6));
            } else {
                result.append(f2.getCaptionLong());
            }
            result.append("]]></caption_long>\n");
        }
        result.append("  <nummer>" + f2.getNummer() + "</nummer>\n");
        result.append("  <x>" + f2.getX() + "</x>\n");
        result.append("  <y>" + f2.getY() + "</y>\n");
        result.append("  <buttonbreite>" + f2.getButtonbreite() + "</buttonbreite>\n");
        result.append("  <feldbreite>" + f2.getFeldbreite() + "</feldbreite>\n");
        result.append("  <zeilenanzahl>" + f2.getZeilenanzahl() + "</zeilenanzahl>\n");
        result.append("  <typ>" + f2.getTyp() + "</typ>\n");
        result.append("  <laenge>" + f2.getLaenge() + "</laenge>\n");
        result.append("  <obligatorisch>" + (f2.isObligatorisch() ? "1" : "0") + "</obligatorisch>\n");
        result.append("  <art>" + f2.getArt() + "</art>\n");
        result.append(" <attribut hasDynamicSichtDefault=\"" + (f2.hasDynamicDefaultSicht() ? "true" : "false") + "\"><![CDATA[" + (f2.hasDynamicDefaultSicht() ? "" : f2.getAttribut()) + "]]></attribut>");
        return result;
    }
}

