/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpConnection
extends Thread {
    public static final int optProxy = 210;
    private String proxy = null;
    private URL url = null;
    private ByteArrayOutputStream dataOs = null;
    private ByteArrayInputStream dataIs = null;
    private int proxyVer = 0;
    private String session = null;
    private Hashtable cookies = null;
    private StringBuffer reqProps = null;
    private Hashtable resHdrs = null;
    static int STREAM_BUF_SIZE = 4096;
    private long interval = 0L;
    private long lastflush = 0L;
    private boolean flushInProgress = true;
    private boolean sendKeepAlives = false;

    public HttpConnection(String string) throws IOException {
        this.proxy = string;
        try {
            this.url = new URL(string);
        }
        catch (IOException iOException) {
            throw new IOException();
        }
        this.reqProps = new StringBuffer();
        this.cookies = new Hashtable();
        this.resHdrs = new Hashtable();
        this.dataOs = new ByteArrayOutputStream(STREAM_BUF_SIZE);
        this.dataIs = new ByteArrayInputStream(new byte[0]);
        this.updateFlushTime();
    }

    public ByteArrayOutputStream getOutputStream() {
        return this.dataOs;
    }

    public ByteArrayInputStream getInputStream() {
        return this.dataIs;
    }

    public void flush(URLConnection uRLConnection) throws IOException {
        this.flushInProgress = true;
        this.sendRequest(uRLConnection);
        this.getResponse(uRLConnection);
        this.updateFlushTime();
        this.flushInProgress = false;
    }

    private void sendRequest(URLConnection uRLConnection) throws IOException {
        this.setCookies(uRLConnection);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(uRLConnection.getOutputStream()));
            dataOutputStream.writeShort(this.reqProps.toString().length());
            dataOutputStream.writeBytes(this.reqProps.toString());
            this.reqProps = new StringBuffer();
            this.dataOs.writeTo(dataOutputStream);
            this.dataOs.reset();
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException();
        }
    }

    private void getResponse(URLConnection uRLConnection) throws IOException {
        short s = 0;
        short s2 = 0;
        byte[] byArray = null;
        this.dataIs = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(uRLConnection.getInputStream()));
            s = dataInputStream.readShort();
            if (s == -1) {
                throw new IOException();
            }
            byte[] byArray2 = new byte[s];
            dataInputStream.readFully(byArray2, 0, s);
            String string = new String(byArray2, 0, (int)s);
            this.parseResponse(string);
            if (dataInputStream.available() > 0) {
                s2 = dataInputStream.readShort();
                if (s2 != -1) {
                    byArray = new byte[s2];
                    dataInputStream.readFully(byArray);
                    this.dataIs = new ByteArrayInputStream(byArray);
                }
            } else {
                this.dataIs = new ByteArrayInputStream(new byte[0]);
            }
            dataInputStream.close();
        }
        catch (IOException iOException) {
            throw new IOException();
        }
    }

    public synchronized URLConnection openConnection(boolean bl, boolean bl2, boolean bl3) throws IOException {
        URLConnection uRLConnection = null;
        try {
            uRLConnection = this.url.openConnection();
            uRLConnection.setUseCaches(bl);
            uRLConnection.setRequestProperty("Content-Type", "application/binary");
            uRLConnection.setDoOutput(bl2);
            uRLConnection.setDoInput(bl3);
        }
        catch (IOException iOException) {
            throw new IOException();
        }
        return uRLConnection;
    }

    public String getHeaderField(String string) {
        String string2 = null;
        string2 = (String)this.resHdrs.get(string);
        return string2;
    }

    public void setRequestProperty(String string, String string2) {
        this.reqProps.append(string + "=" + string2 + "&");
    }

    public void saveCookie(String string) {
        if (string != null) {
            Object object;
            StringTokenizer stringTokenizer = null;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ";");
            while (stringTokenizer2.hasMoreTokens()) {
                object = stringTokenizer2.nextToken().trim();
                stringTokenizer = new StringTokenizer((String)object, "=");
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.equalsIgnoreCase("Comment") || string2.equalsIgnoreCase("Discard") || string2.equalsIgnoreCase("Domain") || string2.equalsIgnoreCase("Expires") || string2.equalsIgnoreCase("Max-Age") || string2.equalsIgnoreCase("Path") || string2.equalsIgnoreCase("Secure") || string2.equalsIgnoreCase("Version")) continue;
                stringBuffer.append((String)object + ";");
            }
            if (stringBuffer.length() > 0) {
                object = new Integer(this.cookies.size());
                this.cookies.put(object, stringBuffer);
            }
        }
    }

    public void setCookies(URLConnection uRLConnection) {
        if (this.cookies.size() > 0) {
            Enumeration enumeration = this.cookies.elements();
            while (enumeration.hasMoreElements()) {
                uRLConnection.setRequestProperty("Cookie", enumeration.nextElement().toString());
            }
        }
    }

    private void parseResponse(String string) {
        this.resHdrs = new Hashtable();
        StringTokenizer stringTokenizer = null;
        if (string != null) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, ";");
            while (stringTokenizer2.hasMoreTokens()) {
                String string2 = stringTokenizer2.nextToken(";");
                stringTokenizer = new StringTokenizer(string2, "=");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken(";").substring(1);
                this.resHdrs.put(string3, string4);
            }
        }
    }

    public void setProxyVersion(int n) {
        this.proxyVer = n;
    }

    public int getProxyVersion() {
        return this.proxyVer;
    }

    private synchronized void updateFlushTime() {
        this.lastflush = System.currentTimeMillis();
    }

    public void startKeepAlive(String string, long l2) throws IOException {
        this.interval = l2 * 1000L;
        this.session = string;
        if (this.proxyVer >= 210) {
            this.sendKeepAlives = true;
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.start();
        }
    }

    public void run() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JDBC_SESSION=" + this.session + "&" + "JDBC_REQUEST" + "=KEEPALIVE&");
        long l2 = 0L;
        long l3 = 0L;
        long l4 = this.interval;
        while (this.sendKeepAlives) {
            try {
                Thread.sleep(l4);
                l3 = System.currentTimeMillis();
                l2 = l3 - this.lastflush;
                if (l2 >= this.interval) {
                    if (!this.flushInProgress && this.sendKeepAlives) {
                        try {
                            URLConnection uRLConnection = this.openConnection(false, true, true);
                            this.setCookies(uRLConnection);
                            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(uRLConnection.getOutputStream()));
                            dataOutputStream.writeShort(stringBuffer.toString().length());
                            dataOutputStream.writeBytes(stringBuffer.toString());
                            dataOutputStream.close();
                            InputStream inputStream = uRLConnection.getInputStream();
                            inputStream.close();
                            this.updateFlushTime();
                            l4 = this.interval;
                        }
                        catch (IOException iOException) {
                            this.sendKeepAlives = false;
                        }
                        continue;
                    }
                    l4 = this.interval;
                    continue;
                }
                l4 = this.interval - l2;
            }
            catch (InterruptedException interruptedException) {
                this.sendKeepAlives = false;
            }
        }
    }

    public void stopKeepAlive() throws IOException {
        this.sendKeepAlives = false;
    }
}

